/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.justificativaplanejamentoorcamentario;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.JustificativaPlanejamentoOrcamentario;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentario;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItem;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentarioItemPer;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoJustificativaPlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.intervalocontrolegerper.ServiceIntervaloControleGerPerImpl;
import com.touchcomp.basementorservice.service.impl.lancamentoctbgerencial.ServiceLancamentoCtbGerencialImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementorservice.service.interfaces.ServicePlanoContaGerencial;
import com.touchcomp.touchvomodel.vo.justificativaplanejamentoorcamentario.web.DTOValoresJustificativaPlanejamento;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceJustificativaPlanejamentoOrcamentarioImpl
extends ServiceGenericEntityImpl<JustificativaPlanejamentoOrcamentario, Long, DaoJustificativaPlanejamentoOrcamentarioImpl> {
    ServiceIntervaloControleGerPerImpl serviceIntervaloControleGerPer;
    ServicePlanoContaGerencial servicePlanoContaGerencial;
    ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentario;
    ServiceLancamentoCtbGerencialImpl serviceLancamentoCtbGerencial;
    ServiceEmpresaImpl serviceEmpresaImpl;

    @Autowired
    public ServiceJustificativaPlanejamentoOrcamentarioImpl(DaoJustificativaPlanejamentoOrcamentarioImpl dao, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentario, ServiceIntervaloControleGerPerImpl serviceIntervaloControleGerPer, ServicePlanoContaGerencial servicePlanoContaGerencial, ServiceLancamentoCtbGerencialImpl serviceLancamentoCtbGerencial, ServiceEmpresaImpl serviceEmpresaImpl) {
        super(dao);
        this.serviceIntervaloControleGerPer = serviceIntervaloControleGerPer;
        this.servicePlanoContaGerencial = servicePlanoContaGerencial;
        this.servicePlanejamentoOrcamentario = servicePlanejamentoOrcamentario;
        this.serviceLancamentoCtbGerencial = serviceLancamentoCtbGerencial;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
    }

    public DTOValoresJustificativaPlanejamento calcularJustificativa(Long idPacoteOrcamentario, Long idPeriodo, Long idPlanoContaGerencial, Long idCentroCusto, CapsEmpresa capsEmpresa) throws ExceptionObjNotFound {
        Empresa emp = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
        IntervaloControleGerPer intervalo = (IntervaloControleGerPer)this.serviceIntervaloControleGerPer.get(idPeriodo);
        PlanoContaGerencial pcGenrencial = (PlanoContaGerencial)this.servicePlanoContaGerencial.get(idPlanoContaGerencial);
        PlanejamentoOrcamentario planejamento = this.servicePlanejamentoOrcamentario.getByPacoteOrcamentario(idPacoteOrcamentario, intervalo.getIdentificador());
        LinkedList<PlanejamentoOrcamentarioItemPer> planejamentosItensPerc = new LinkedList<PlanejamentoOrcamentarioItemPer>();
        for (PlanejamentoOrcamentarioItem item : planejamento.getItens()) {
            if (item.getPlanoContaGerencial() != pcGenrencial) continue;
            for (PlanejamentoOrcamentarioItemPer perItem : item.getPeriodos()) {
                if (perItem.getIntervaloControleGerPer() != intervalo) continue;
                planejamentosItensPerc.add(perItem);
            }
        }
        Double valorOrcado = 0.0;
        Double valorPlanejado = 0.0;
        for (PlanejamentoOrcamentarioItemPer perItem : planejamentosItensPerc) {
            valorPlanejado = valorPlanejado + this.serviceLancamentoCtbGerencial.getValorUtilizadoDeOrcamento(perItem.getIntervaloControleGerPer().getDataInicial(), perItem.getIntervaloControleGerPer().getDataFinal(), emp.getIdentificador(), pcGenrencial.getIdentificador(), idCentroCusto);
            valorOrcado = valorOrcado + perItem.getValorOrcado();
        }
        DTOValoresJustificativaPlanejamento dto = new DTOValoresJustificativaPlanejamento();
        dto.setValorPlanejado(valorPlanejado);
        dto.setValorOrcado(valorOrcado);
        dto.setValorJustificar(Double.valueOf(valorPlanejado - valorOrcado));
        return dto;
    }
}

