/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamento;

import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegAdiantViagemAdiantViagem;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.components.lancamentomovimentobancario.CompLancamentoMovimentoBancario;
import com.touchcomp.basementorservice.dao.impl.DaoLancamentoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.converters.DTOPlanoContaCodigoConverter;
import com.touchcomp.basementorservice.service.impl.bloqueiolancamentocontabil.ServiceBloqueioLancamentoContabilImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.lancamento.UtilLancamentoAdiantamentoViagem;
import com.touchcomp.basementorservice.service.interfaces.ServiceLancamento;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementorvalidator.entities.impl.lancamento.ValidLancamento;
import com.touchcomp.touchvomodel.vo.lotecontabil.web.DTOLoteContabil;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLancamentoImpl
extends ServiceGenericEntityImpl<Lancamento, Long, DaoLancamentoImpl>
implements ServiceLancamento {
    @Autowired
    DTOPlanoContaCodigoConverter dtoPlanoContaCodigoConverter;
    @Autowired
    CompLancamentoMovimentoBancario compLancamentoMovimentoBancario;
    @Autowired
    ServiceBloqueioLancamentoContabilImpl serviceBloqueioLancamentoContabil;
    @Autowired
    ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    @Autowired
    ValidLancamento validLancamento;

    @Override
    public Lancamento beforeSave(Lancamento vo) {
        List<BloqueioLancamentoContabil> bloqueios;
        if (vo.getLoteContabil() != null) {
            vo.setDataLancamento(vo.getLoteContabil().getDataLote());
        }
        if (ServiceLancamentoImpl.isWithData(bloqueios = this.serviceBloqueioLancamentoContabil.verificarBloqueioLancamento(vo.getDataLancamento(), vo.getGrupoEmpresa()))) {
            throw new ExceptionRuntimeBase("Existe um bloqueio de lan\u00e7amento cont\u00e1bil para o per\u00edodo do lan\u00e7amento " + ToolDate.dateToStr((Date)vo.getDataLancamento()));
        }
        return vo;
    }

    @Autowired
    public ServiceLancamentoImpl(DaoLancamentoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public LoteContabil gerarLancamentosMovimentoBancario(IntegracaoMovBancarioMovimento vo) {
        return this.compLancamentoMovimentoBancario.gerarLancamentos(vo);
    }

    @Override
    public LoteContabil gerarLancamentosAdiantamentoViagem(IntegAdiantViagemAdiantViagem adiantamentoViagem) {
        return new UtilLancamentoAdiantamentoViagem().gerarLancamentosAdiantamentoViagem(adiantamentoViagem);
    }

    @Override
    public Lancamento pesquisaUltimoLancamento() {
        return ((DaoLancamentoImpl)this.getGenericDao()).pesquisaUltimoLancamento();
    }

    @Override
    public List<Lancamento> buscarLancamentosPorLote(LoteContabil lote, GrupoEmpresa grupoEmpresa) {
        return ((DaoLancamentoImpl)this.getGenericDao()).buscarLancamentosPorLote(lote, grupoEmpresa);
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder dtoBuilder) {
        dtoBuilder.addDTOConverter((DTOEntityConversor)this.dtoPlanoContaCodigoConverter);
    }

    public WebDTOResult<DTOLoteContabil.DTOLancamento> conferenciaLancamento(DTOLoteContabil.DTOLancamento dto, Date dataLote, Long idGrupoEmpresa) throws ExceptionInvalidData, ExceptionObjNotFound {
        WebDTOResult res = new WebDTOResult();
        Lancamento vo = (Lancamento)this.buildToEntity(dto);
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.getOrThrow(idGrupoEmpresa);
        this.validLancamento.clearContainer();
        this.validLancamento.validarDadosLancamento(vo);
        if (this.validLancamento.hasErrors()) {
            this.validLancamento.buildResult(res);
        } else {
            List<BloqueioLancamentoContabil> bloqueios = this.serviceBloqueioLancamentoContabil.verificarBloqueioLancamento(dataLote, grupo);
            if (ServiceLancamentoImpl.isWithData(bloqueios)) {
                throw new ExceptionInvalidData("E.ERP.0379.002", new Object[0]);
            }
            res.setResult((Object)this.buildToDTO(vo, DTOLoteContabil.DTOLancamento.class));
        }
        return res;
    }
}

