/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import java.util.ArrayList;
import java.util.Date;

public class UtilLancamentoBaixaBem
extends CompLancamentoBase {
    public LoteContabil gerarLancamentos(Empresa emp, OpcoesPatrimonio opPatrimonio, BaixaBem vo, DepreciacaoBem depreBem) {
        if (opPatrimonio == null) {
            return null;
        }
        if (opPatrimonio.getPlanoContaCustoDeb() == null || opPatrimonio.getHistoricoBaixaBem() == null || opPatrimonio.getPlanoContaDepreAcum() == null || opPatrimonio.getPlanoContaCustoCred() == null || opPatrimonio.getHistoricoDepreAcum() == null) {
            return null;
        }
        LoteContabil lote = this.getLancamentosBaixaBem(emp, opPatrimonio, vo, depreBem);
        if (lote != null && lote.getLancamentos() != null && !lote.getLancamentos().isEmpty()) {
            return lote;
        }
        return null;
    }

    private LoteContabil getLancamentosBaixaBem(Empresa emp, OpcoesPatrimonio opPatrimonio, BaixaBem vo, DepreciacaoBem depreBem) {
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        LoteContabil lote = this.criarLoteContabil(vo.getLoteContabil(), vo.getDataBaixa(), vo.getBem().getEmpresa(), ConstEnumOrigemLoteContabil.BAIXA_BEM);
        Lancamento lancamento1 = CompLancamentoBase.newLancamento(lote, vo.getEmpresa());
        lancamento1.setLoteContabil(lote);
        lancamento1.setPlanoContaDeb(opPatrimonio.getPlanoContaCustoDeb());
        lancamento1.setPlanoContaCred(vo.getBem().getTipoBem().getPlanoContaBem());
        lancamento1.setHistoricoPadrao(opPatrimonio.getHistoricoBaixaBem());
        lancamento1.setValor(vo.getBem().getValorCompra());
        lancamento1.setHistorico(opPatrimonio.getHistoricoBaixaBem().getDescricao());
        lancamento1.setDataCadastro(new Date());
        lancamento1.setGerado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        lancamento1.setDataLancamento(vo.getDataBaixa());
        lancamento1.setCentroResultadoContFin(emp.getEmpresaDados().getCentroResultadoContFin());
        lancamento1.setGrupoEmpresa(emp.getEmpresaDados().getGrupoEmpresa());
        lancamento1.setEmpresa(emp);
        lancamentos.add(lancamento1);
        Lancamento lancamento2 = CompLancamentoBase.newLancamento(lote, vo.getEmpresa());
        lancamento2.setLoteContabil(lote);
        lancamento2.setPlanoContaDeb(opPatrimonio.getPlanoContaDepreAcum());
        lancamento2.setPlanoContaCred(opPatrimonio.getPlanoContaCustoCred());
        lancamento2.setHistoricoPadrao(opPatrimonio.getHistoricoDepreAcum());
        lancamento2.setValor(Double.valueOf(depreBem.getValorDepreciacao() + depreBem.getValorDeprecAcelerada()));
        lancamento2.setHistorico(opPatrimonio.getHistoricoDepreAcum().getDescricao());
        lancamento2.setDataCadastro(new Date());
        lancamento2.setGerado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        lancamento2.setDataLancamento(vo.getDataBaixa());
        lancamento2.setCentroResultadoContFin(emp.getEmpresaDados().getCentroResultadoContFin());
        lancamento2.setGrupoEmpresa(emp.getEmpresaDados().getGrupoEmpresa());
        lancamento2.setEmpresa(emp);
        lancamentos.add(lancamento2);
        lote.getLancamentos().addAll(lancamentos);
        return lote;
    }
}

