/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamentocomissaorepresentante;

import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementorservice.dao.impl.DaoLancamentoComissaoRepresentanteImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLancamentoComissaoRepresentanteImpl
extends ServiceGenericEntityImpl<LancamentoComissaoRepresentante, Long, DaoLancamentoComissaoRepresentanteImpl> {
    @Autowired
    public ServiceLancamentoComissaoRepresentanteImpl(DaoLancamentoComissaoRepresentanteImpl dao) {
        super(dao);
    }

    @Override
    public LancamentoComissaoRepresentante beforeSave(LancamentoComissaoRepresentante vo) {
        if (this.isAffimative(vo.getGerarMovimentoBancario()) && !this.isEquals(vo.getMovimentoBancario(), null)) {
            MovimentoBancario mov = vo.getMovimentoBancario();
            if (this.isEquals(mov.getDataCadastro(), null)) {
                mov.setDataCadastro(ToolDate.getCurrentDate());
            }
            mov.setDataLancamento(vo.getDataLancamento());
            mov.setDebCred(vo.getDebCred());
            mov.setValor(vo.getValor());
            mov.setEmpresa(vo.getEmpresa());
            if (!this.isEquals(mov.getModeloLancamentoBancario(), null)) {
                mov.setNaoContabilizarMov(mov.getModeloLancamentoBancario().getNaoContabilizarMov());
            }
            if (this.isEquals(mov.getModeloLancamentoBancario(), null) || !this.isStrWithData(mov.getHistorico())) {
                mov.setHistorico("Movimento gerado pelo lancamento de comissao de representante do dia: " + ToolDate.dateToStr((Date)mov.getDataLancamento()) + " no valor de: " + ToolFormatter.formataNumero((Number)mov.getValor(), (int)2));
            }
        } else {
            vo.setMovimentoBancario(null);
        }
        return vo;
    }
}

