/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamentoctbgerencial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.MovimentoPneu;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoLancamentoCtbGerencialImpl;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLancamentoCtbGerencialImpl
extends ServiceGenericEntityImpl<LancamentoCtbGerencial, Long, DaoLancamentoCtbGerencialImpl> {
    @Autowired
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    @Autowired
    public ServiceLancamentoCtbGerencialImpl(DaoLancamentoCtbGerencialImpl dao, HelperLancamentoCtbGerencial helperLancamentoCtbGerencial) {
        super(dao);
        this.helperLancamentoCtbGerencial = helperLancamentoCtbGerencial;
    }

    public Double getValorUtilizadoDeOrcamento(Date dataInicial, Date dataFinal, Long emp, Long planoContaGerencial, Long idCentroCusto) {
        return ((DaoLancamentoCtbGerencialImpl)this.getDao()).getValorUtilizadoDeOrcamento(dataInicial, dataFinal, emp, planoContaGerencial, idCentroCusto);
    }

    public void createOrUpdateLancamentoRecapagem(MovimentoPneu m, OpcoesGerenciais og) {
        if (m.getValorInitario() > 0.0 && this.isEquals(og.getGerarlancamentoGerencialRecapagem(), EnumConstantsMentorSimNao.SIM.getValue())) {
            if (this.isNull(m.getLancamentoRecapagem()).booleanValue()) {
                LancamentoCtbGerencial l = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, new Date(), m.getDataMovimento(), EnumLancamentoCTBGerencial.DEBITO.getValue(), m.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), m.getObservacao(), og.getPlanoContaRecapagem(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), this.isNull(m.getVeiculo()) == false ? m.getVeiculo().getEquipamento().getCentroCusto() : null, m.getValorInitario(), null);
                m.setLancamentoRecapagem(l);
            } else {
                m.getLancamentoRecapagem().setDataPrevista(m.getDataMovimento());
                m.getLancamentoRecapagem().setValor(m.getValorInitario());
            }
        }
    }

    public LancamentoCtbGerencial criarLancamentoGerencialMovimentoBancario(MovimentoBancario movDeb, Short debCred, PlanoContaGerencial planoContaGerencial, Double valor) {
        LancamentoCtbGerencial l = this.getBean(HelperLancamentoCtbGerencial.class).newLancamentoCtbGerencial(null, movDeb.getDataLancamento(), movDeb.getDataLancamento(), debCred, movDeb.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), movDeb.getHistorico(), planoContaGerencial, EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO.getValue(), null, valor, null);
        return l;
    }

    @Override
    public LancamentoCtbGerencial beforeSaveEntity(LancamentoCtbGerencial vo) {
        if (this.isAffimative(vo.getGerado())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0718.002"));
        }
        return super.beforeSaveEntity(vo);
    }
}

