/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamentoeventocooperado;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.ProvisaoJurosEventoCooperado;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.lancamentocooperado.CompLancamentoEventoCoooperado;
import com.touchcomp.basementorservice.dao.impl.DaoLancamentoEventoCooperadoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.lancamentoeventocooperado.web.DTOLancamentoEventoCooperadoRes;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceLancamentoEventoCooperadoImpl
extends ServiceGenericEntityImpl<LancamentoEventoCooperado, Long, DaoLancamentoEventoCooperadoImpl> {
    @Autowired
    CompLancamentoEventoCoooperado compLancamentoEventoCoooperado;

    @Autowired
    public ServiceLancamentoEventoCooperadoImpl(DaoLancamentoEventoCooperadoImpl dao) {
        super(dao);
    }

    public List<LancamentoEventoCooperado> pesquisarLancamentoEventoCooperadoPorPeriodo(Date dataInicial, Date dataFinal) {
        return ((DaoLancamentoEventoCooperadoImpl)this.getGenericDao()).pesquisarLancamentoEventoCooperadoPorPeriodo(dataInicial, dataFinal);
    }

    public List<LancamentoEventoCooperado> pesquisarLancEventoCoopPorPeriodoEventoCooperado(Date dataInicial, Date dataFinal, List<ProvisaoJurosEventoCooperado> listProvisaoJurosEventoCooperado) {
        return ((DaoLancamentoEventoCooperadoImpl)this.getGenericDao()).pesquisarLancEventoCoopPorPeriodoEventoCooperado(dataInicial, dataFinal, listProvisaoJurosEventoCooperado);
    }

    @Async
    public CompletableFuture contabilizar(List<DTOLancamentoEventoCooperadoRes> evt, OpcoesContabeis opContabeis) throws ExceptionInvalidData {
        for (DTOLancamentoEventoCooperadoRes l : evt) {
            LancamentoEventoCooperado vo = (LancamentoEventoCooperado)this.get(l.getIdentificador());
            this.compLancamentoEventoCoooperado.gerarLancContabilAdicionalDocFinanceiro(vo, opContabeis);
            this.saveOrUpdate(vo);
        }
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }
}

