/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lancamentospedpiscofins;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasPisCofinsSpedCont;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.PcSpedPisCofins;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.components.spedpiscofins.lancamentospedpiscofins.CompLancamentoSpedPisCofins;
import com.touchcomp.basementorservice.dao.impl.DaoLancamentoSpedPisCofinsImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceLancamentoSpedPisCofinsImpl
extends ServiceGenericEntityImpl<LancamentoSpedPisCofins, Long, DaoLancamentoSpedPisCofinsImpl> {
    public ServiceLancamentoSpedPisCofinsImpl(DaoLancamentoSpedPisCofinsImpl genericDao) {
        super(genericDao);
    }

    public List<LancamentoSpedPisCofins> gerarLancOutrosCredF100(Date dataIn, Date dataFinal, Empresa empresa, GrupoEmpresa grupoEmpresa, OpcoesImpostos opcoesImpostos) {
        List<ItemNotaTerceiros> itensTerc = ((DaoLancamentoSpedPisCofinsImpl)this.getDao()).gerarLancOutrosCredF100Terc(dataIn, dataFinal, grupoEmpresa);
        List<ItemNotaFiscalPropria> itensProp = ((DaoLancamentoSpedPisCofinsImpl)this.getDao()).gerarLancOutrosCredF100Prop(dataIn, dataFinal, grupoEmpresa);
        List<BaixaTitulo> baixas = ((DaoLancamentoSpedPisCofinsImpl)this.getDao()).gerarLancOutrosCredF100Baixas(dataIn, dataFinal, grupoEmpresa);
        List<Lancamento> lancamentos = ((DaoLancamentoSpedPisCofinsImpl)this.getDao()).gerarLancOutrosCredF100Lanc(dataIn, dataFinal, grupoEmpresa);
        LinkedList<LancamentoSpedPisCofins> lancamentosSpedPisCofins = new LinkedList<LancamentoSpedPisCofins>();
        for (ItemNotaTerceiros itemNotaTerceiros : itensTerc) {
            lancamentosSpedPisCofins.add(CompLancamentoSpedPisCofins.getNew(itemNotaTerceiros, empresa));
        }
        for (ItemNotaFiscalPropria itemNotaPropria : itensProp) {
            lancamentosSpedPisCofins.add(CompLancamentoSpedPisCofins.getNew(itemNotaPropria, empresa));
        }
        for (BaixaTitulo baixa : baixas) {
            lancamentosSpedPisCofins.add(CompLancamentoSpedPisCofins.getNew(baixa));
        }
        for (Lancamento lanc : lancamentos) {
            ContasPisCofinsSpedCont contasPisCofinsSpedContCred = this.verificarContasPisCofinsSpedCont(dataIn, lanc.getPlanoContaCred(), opcoesImpostos);
            ContasPisCofinsSpedCont contasPisCofinsSpedContDeb = this.verificarContasPisCofinsSpedCont(dataIn, lanc.getPlanoContaDeb(), opcoesImpostos);
            if (this.isNotNull(contasPisCofinsSpedContCred).booleanValue()) {
                lancamentosSpedPisCofins.add(CompLancamentoSpedPisCofins.getNew(lanc, lanc.getCentroResultadoContFin().getEmpresa(), contasPisCofinsSpedContCred, lanc.getPlanoContaCred()));
            }
            if (!this.isNotNull(contasPisCofinsSpedContDeb).booleanValue()) continue;
            lancamentosSpedPisCofins.add(CompLancamentoSpedPisCofins.getNew(lanc, lanc.getCentroResultadoContFin().getEmpresa(), contasPisCofinsSpedContDeb, lanc.getPlanoContaDeb()));
        }
        return lancamentosSpedPisCofins;
    }

    private ContasPisCofinsSpedCont verificarContasPisCofinsSpedCont(Date dataIn, PlanoConta planoConta, OpcoesImpostos opcoesImpostos) {
        for (ContasPisCofinsSpedCont contasPisCofinsSpedCont : opcoesImpostos.getContasPisCofinsSpedCont()) {
            if ((!this.isNull(contasPisCofinsSpedCont.getDataFinal()).booleanValue() || !dataIn.after(contasPisCofinsSpedCont.getDataInicial())) && !ToolDate.dateBetween((Date)dataIn, (Date)contasPisCofinsSpedCont.getDataInicial(), (Date)contasPisCofinsSpedCont.getDataFinal()).booleanValue()) continue;
            for (PcSpedPisCofins pcSpedPisCofins : contasPisCofinsSpedCont.getPcSpedPisCofins()) {
                if (!this.isEquals(pcSpedPisCofins.getPlanoConta(), planoConta)) continue;
                return contasPisCofinsSpedCont;
            }
        }
        return null;
    }
}

