/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.leadtimefornecedor;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoLeadTimeFornProduto;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.DTOLeadTimeSimples;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedoraval.ServiceLeadTimeFornecedorAvalImpl;
import com.touchcomp.touchvomodel.vo.leadtimefornecedor.web.DTOLeadTimeFornecedor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLeadTimeFornProdutoImpl
extends ServiceGenericEntityImpl<LeadTimeFornProduto, Long, DaoLeadTimeFornProduto> {
    private final ServiceGradeCorImpl serviceGradeCor;
    private final ServiceLeadTimeFornecedorAvalImpl serviceLeadTimeFornAval;

    @Autowired
    public ServiceLeadTimeFornProdutoImpl(DaoLeadTimeFornProduto genericDao, ServiceGradeCorImpl serviceGradeCor, ServiceLeadTimeFornecedorAvalImpl serviceLeadTimeFornAval) {
        super(genericDao);
        this.serviceGradeCor = serviceGradeCor;
        this.serviceLeadTimeFornAval = serviceLeadTimeFornAval;
    }

    public List<LeadTimeFornProduto> findLeadTimeGradeCorHomologado(GradeCor gradeCor, Empresa empresa) {
        return ((DaoLeadTimeFornProduto)this.getDao()).findLeadTimeGradeCorHomologado(gradeCor, empresa, EnumConstantsMentorSimNao.SIM.getValue());
    }

    public List<LeadTimeFornProduto> findLeadTimeProduto(GradeCor gradeCor, Empresa empresa) {
        return ((DaoLeadTimeFornProduto)this.getDao()).findLeadTimeGradeCorHomologado(gradeCor, empresa, EnumConstantsMentorSimNao.NAO.getValue());
    }

    public List<LeadTimeFornProduto> findLeadTimeProduto(Long idGradeCor, Empresa empresa) throws ExceptionObjNotFound {
        GradeCor gradeCor = (GradeCor)this.serviceGradeCor.getOrThrow(idGradeCor);
        return this.findLeadTimeProduto(gradeCor, empresa);
    }

    public List<DTOLeadTimeFornecedor.DTOLeadTimeFornProduto> findLeadTimeProdutoComAvaliacao(Long idGradeCor, Empresa empresa) throws ExceptionObjNotFound {
        ArrayList<DTOLeadTimeFornecedor.DTOLeadTimeFornProduto> result = new ArrayList<DTOLeadTimeFornecedor.DTOLeadTimeFornProduto>();
        List<LeadTimeFornProduto> fornecedores = this.findLeadTimeProduto(idGradeCor, empresa);
        for (LeadTimeFornProduto f : fornecedores) {
            if (this.isNull(f.getLeadTimeFornecedor()).booleanValue() || this.isNull(f.getLeadTimeFornecedor().getUnidadeFatFornecedor()).booleanValue()) continue;
            DTOLeadTimeFornecedor.DTOLeadTimeFornProduto dto = this.buildToDTO(f, DTOLeadTimeFornecedor.DTOLeadTimeFornProduto.class);
            dto.setEficiencia(this.serviceLeadTimeFornAval.getEficiencia(f.getLeadTimeFornecedor().getUnidadeFatFornecedor()));
            if (this.isNull(dto.getEficiencia()).booleanValue()) {
                dto.setEficiencia(Double.valueOf(0.0));
            }
            result.add(dto);
        }
        return result;
    }

    public boolean isAquisicaoPreferencial(UnidadeFatFornecedor unidade, GradeCor gradeCor, Empresa empresa) {
        Long idUnidadeFatForn = 0L;
        Long idGradeCor = 0L;
        Long idEmpresa = 0L;
        if (unidade != null) {
            idUnidadeFatForn = unidade.getIdentificador();
        }
        if (gradeCor != null) {
            idGradeCor = gradeCor.getIdentificador();
        }
        if (empresa != null) {
            idEmpresa = empresa.getIdentificador();
        }
        return ((DaoLeadTimeFornProduto)this.getDao()).isAquisicaoPreferencial(idUnidadeFatForn, idGradeCor, idEmpresa);
    }

    public boolean isAquisicaoPreferencial(Long idUnidadeFatForn, Long idGradeCor, Long idGradeEmpresa) {
        return ((DaoLeadTimeFornProduto)this.getDao()).isAquisicaoPreferencial(idUnidadeFatForn, idGradeCor, idGradeEmpresa);
    }

    public List<DTOLeadTimeSimples> getLeadsTimeCotacao(Long idCotacaoCompra) {
        return ((DaoLeadTimeFornProduto)this.getDao()).getLeadsTimeAssociadosCotacao(idCotacaoCompra);
    }
}

