/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.leituraarquivoponto;

import com.touchcomp.basementor.model.vo.ItemLeituraArquivoPonto;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.dao.impl.DaoItemLeituraArquivoPontoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.leituraarquivoponto.DTOItemLeituraArquivoPonto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceItemLeituraArquivoPontoImpl
extends ServiceGenericEntityImpl<ItemLeituraArquivoPonto, Long, DaoItemLeituraArquivoPontoImpl> {
    @Autowired
    public ServiceItemLeituraArquivoPontoImpl(DaoItemLeituraArquivoPontoImpl genericDao) {
        super(genericDao);
    }

    public void alterarDadosPonto(ItemLeituraArquivoPonto item, boolean setAlterado) throws ExceptionReflection, ExceptionIO {
        if (!ToolMethods.isAffirmative((Number)item.getInformarManual())) {
            DTOItemLeituraArquivoPonto dto = this.buildToDTO(item, DTOItemLeituraArquivoPonto.class);
            String json = ToolJson.toJson((Object)dto);
            item.setDadosItemAntesAlteracao(json);
            if (setAlterado) {
                item.setInformarManual(Short.valueOf((short)1));
            }
        }
    }

    public void recuperarDadosPonto(ItemLeituraArquivoPonto item) throws ExceptionIO, ExceptionReflection {
        if (ToolMethods.isAffirmative((Number)item.getInformarManual())) {
            if (!ToolMethods.isStrWithData((String)item.getDadosItemAntesAlteracao())) {
                return;
            }
            DTOItemLeituraArquivoPonto dto = (DTOItemLeituraArquivoPonto)ToolJson.readJson((String)item.getDadosItemAntesAlteracao(), DTOItemLeituraArquivoPonto.class);
            this.buildToEntity(dto, item);
        }
    }
}

