/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaolotesfab;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.FichaTecnicaLibLotesFab;
import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.LiberacaoLotesFab;
import com.touchcomp.basementor.model.vo.LiberacaoLotesFabLote;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.ModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.ValoresFichaLibLotesFab;
import com.touchcomp.basementor.model.vo.ValoresFichaLoteFab;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoLotesFabImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelofichatecnica.ServiceModeloFichaTecnicaImpl;
import com.touchcomp.touchvomodel.vo.fichatecnicaliblotesfab.web.DTOFichaTecnicaLibLotesFab;
import com.touchcomp.touchvomodel.vo.liberacaolotesfablote.web.DTOLiberacaoLotesFabLote;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTOLoteFabricacao;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoLotesFabImpl
extends ServiceGenericEntityImpl<LiberacaoLotesFab, Long, DaoLiberacaoLotesFabImpl> {
    ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl;
    ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl;

    @Autowired
    public ServiceLiberacaoLotesFabImpl(DaoLiberacaoLotesFabImpl genericDao, ServiceLoteFabricacaoImpl serviceLoteFabricacaoImpl, ServiceModeloFichaTecnicaImpl serviceModeloFichaTecnicaImpl) {
        super(genericDao);
        this.serviceLoteFabricacaoImpl = serviceLoteFabricacaoImpl;
        this.serviceModeloFichaTecnicaImpl = serviceModeloFichaTecnicaImpl;
    }

    @Override
    public LiberacaoLotesFab beforeSaveEntity(LiberacaoLotesFab aux) {
        aux.getFichaTecnicaLiberLotesFab().forEach(i -> {
            i.setLiberacaoLotesFab(aux);
            i.getValoresFichaLibLotesFab().forEach(v -> v.setFichaTecnicaLibLotesFab(i));
        });
        aux.getLiberacaoLotesFabLote().forEach(i -> {
            i.setLiberacaoLotesFab(aux);
            if (this.isEquals(i.getLoteFabricacao().getStatusLoteFabricacao().getLoteBloqueado(), EnumConstantsMentorSimNao.NAO.getValue())) {
                i.getLoteFabricacao().setDataLiberacao(aux.getDataLiberacao());
                i.getLoteFabricacao().setUsuario(aux.getUsuario());
                i.getLoteFabricacao().setLoteBloqueado(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            }
            i.getLoteFabricacao().getFichaTecnica().forEach(f -> {
                f.setLoteFabricacao(i.getLoteFabricacao());
                f.getValoresFicha().forEach(v -> v.setFichaTecnica(f));
            });
        });
        return aux;
    }

    public WebDTOResult getLiberacaoLotesFabLote(Long[] ids) {
        WebDTOResult dto = new WebDTOResult();
        List lotesFabricacao = this.serviceLoteFabricacaoImpl.gets(ids);
        List liberacaoLotesFabLote = lotesFabricacao.stream().filter(i -> this.isEquals(i.getLoteBloqueado(), EnumConstantsMentorSimNao.SIM.getValue())).map(i -> {
            LiberacaoLotesFabLote item = new LiberacaoLotesFabLote();
            item.setLoteFabricacao(i);
            return item;
        }).collect(Collectors.toList());
        if (!this.isEquals(lotesFabricacao.size(), liberacaoLotesFabLote.size())) {
            dto.addWarning("E.ERP.1687.001");
        }
        return dto.setResult(this.buildToDTOGeneric(liberacaoLotesFabLote, DTOLiberacaoLotesFabLote.class));
    }

    public List<DTOFichaTecnicaLibLotesFab> getFichaTecnicaLibLotesFab(List<DTOLiberacaoLotesFabLote> input, Long[] ids) {
        List listModeloFichaTecnica = this.serviceModeloFichaTecnicaImpl.gets(ids);
        ArrayList<FichaTecnicaLibLotesFab> listFichaTecnicaLibLotesFab = new ArrayList<FichaTecnicaLibLotesFab>();
        for (ModeloFichaTecnica modeloFicha : listModeloFichaTecnica) {
            FichaTecnicaLibLotesFab fichaTecnica = new FichaTecnicaLibLotesFab();
            fichaTecnica.setModeloFichaTecnica(modeloFicha);
            ArrayList<ValoresFichaLibLotesFab> valores = new ArrayList<ValoresFichaLibLotesFab>();
            for (ItemModeloFichaTecnica itemModelo : modeloFicha.getItensModeloFichaTecnica()) {
                ValoresFichaLibLotesFab valoresFicha = new ValoresFichaLibLotesFab();
                valoresFicha.setItemModeloFichaTecnica(itemModelo);
                valoresFicha.setFichaTecnicaLibLotesFab(fichaTecnica);
                valoresFicha.setChave(itemModelo.getDescricao());
                valoresFicha.setValorObrigatorio(itemModelo.getCampoObrigatorio());
                valores.add(valoresFicha);
            }
            fichaTecnica.setValoresFichaLibLotesFab(valores);
            listFichaTecnicaLibLotesFab.add(fichaTecnica);
        }
        return this.buildToDTOGeneric(listFichaTecnicaLibLotesFab, DTOFichaTecnicaLibLotesFab.class);
    }

    public List<DTOLoteFabricacao.DTOFichaTecnicaLoteFabricacao> getFichaTecnicaLibLotesFabIndividual(Long[] idsLote, Long[] idsModeloFichaTecnica) throws ExceptionObjNotFound {
        List listLote = this.serviceLoteFabricacaoImpl.gets(idsLote);
        List listModeloFichaTecnica = this.serviceModeloFichaTecnicaImpl.gets(idsModeloFichaTecnica);
        ArrayList<FichaTecnicaLoteFabricacao> listFichaTecnicaLoteFab = new ArrayList<FichaTecnicaLoteFabricacao>();
        for (LoteFabricacao lote : listLote) {
            for (ModeloFichaTecnica modeloFicha : listModeloFichaTecnica) {
                FichaTecnicaLoteFabricacao fichaTecnicaLoteFab = new FichaTecnicaLoteFabricacao();
                fichaTecnicaLoteFab.setModeloFichaTecnica(modeloFicha);
                fichaTecnicaLoteFab.setLoteFabricacao(lote);
                ArrayList<ValoresFichaLoteFab> valores = new ArrayList<ValoresFichaLoteFab>();
                for (ItemModeloFichaTecnica itemModelo : modeloFicha.getItensModeloFichaTecnica()) {
                    ValoresFichaLoteFab valoresFicha = new ValoresFichaLoteFab();
                    valoresFicha.setItemModeloFichaTecnica(itemModelo);
                    valoresFicha.setFichaTecnica(fichaTecnicaLoteFab);
                    valoresFicha.setChave(itemModelo.getDescricao());
                    valoresFicha.setValorObrigatorio(itemModelo.getCampoObrigatorio());
                    valores.add(valoresFicha);
                }
                fichaTecnicaLoteFab.setValoresFicha(valores);
                listFichaTecnicaLoteFab.add(fichaTecnicaLoteFab);
            }
        }
        return this.buildToDTOGeneric(listFichaTecnicaLoteFab, DTOLoteFabricacao.DTOFichaTecnicaLoteFabricacao.class);
    }
}

