/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaoneccompra;

import com.touchcomp.basementor.constants.enums.liberacaonecessidadecompra.EnumConstTipoOperacao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LiberacaoNecCompra;
import com.touchcomp.basementor.model.vo.LiberacaoNecCompraItem;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoNecCompraImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.touchvomodel.vo.liberacaoneccompraitem.web.DTOLiberacaoNecCompraItem;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoNecCompraImpl
extends ServiceGenericEntityImpl<LiberacaoNecCompra, Long, DaoLiberacaoNecCompraImpl> {
    ServiceNecessidadeCompraImpl serviceNecessidadeCompraImpl;

    @Autowired
    public ServiceLiberacaoNecCompraImpl(DaoLiberacaoNecCompraImpl dao, ServiceNecessidadeCompraImpl serviceNecessidadeCompraImpl) {
        super(dao);
        this.serviceNecessidadeCompraImpl = serviceNecessidadeCompraImpl;
    }

    @Override
    public LiberacaoNecCompra beforeSaveEntity(LiberacaoNecCompra aux) {
        aux.setItensLiberacao(aux.getItensLiberacao().stream().filter(i -> !this.isEquals(i.getTipoOperacao(), EnumConstTipoOperacao.NAO_LIBERAR.getValue())).peek(i -> {
            i.setLiberacaoNecCompra(aux);
            if (this.isNotNull(this.getSharedData().getOpcoesCompraSuprimentos(aux.getEmpresa())).booleanValue()) {
                if (this.isEquals(i.getTipoOperacao(), EnumConstTipoOperacao.LIBERADO.getValue())) {
                    i.getNecessidadeCompra().setSituacaoNecessidadeCompra(this.getSharedData().getOpcoesCompraSuprimentos(aux.getEmpresa()).getSituacaoNecessidadeLiberada());
                } else {
                    i.getNecessidadeCompra().setSituacaoNecessidadeCompra(this.getSharedData().getOpcoesCompraSuprimentos(aux.getEmpresa()).getSituacaoNecessidadeDesistencia());
                    i.getNecessidadeCompra().setDesativarNecessidade(Short.valueOf((short)1));
                    i.getNecessidadeCompra().setMotivoDesativacao("Desist\u00eancia realizada automaticamente pelo recurso de Libera\u00e7\u00e3o de Necessidades.");
                }
            }
        }).collect(Collectors.toList()));
        if (!ServiceLiberacaoNecCompraImpl.isWithData(aux.getItensLiberacao())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1245.004"));
        }
        return aux;
    }

    public List<DTOLiberacaoNecCompraItem> getItensLiberacao(Long dtInicial, Long dtFinal, Empresa empresa, Short filtrarGrupoNecessidadeCompra, Long idGrupoNecessidadeCompra, Short filtrarUsuarioSolicitante, Long idUsuarioSolicitante, Short filtrarCentroCusto, Long idCentroCusto, Long idUsuarioLiberacao) throws ExceptionObjNotFound {
        if (this.isNull(dtInicial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1245.001", new Object[]{dtInicial}));
        }
        if (this.isNull(dtFinal).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1245.002", new Object[]{dtFinal}));
        }
        Date dataInicial = new Date(dtInicial);
        Date dataFinal = new Date(dtFinal);
        if (dataFinal.before(dataInicial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1245.003", new Object[]{dtFinal}));
        }
        List<NecessidadeCompra> nec = this.serviceNecessidadeCompraImpl.getNecessidadesCompraNaoLiberadas(dataInicial, dataFinal, empresa.getIdentificador(), filtrarGrupoNecessidadeCompra, idGrupoNecessidadeCompra, filtrarUsuarioSolicitante, idUsuarioSolicitante, filtrarCentroCusto, idCentroCusto, idUsuarioLiberacao);
        return this.buildToDTOGeneric(this.criarLiberacaoNecCompraItem(nec), DTOLiberacaoNecCompraItem.class);
    }

    public List<LiberacaoNecCompraItem> criarLiberacaoNecCompraItem(List<NecessidadeCompra> necessidade) {
        List<LiberacaoNecCompraItem> itensLiberacao = necessidade.stream().map(i -> {
            LiberacaoNecCompraItem l = new LiberacaoNecCompraItem();
            l.setNecessidadeCompra(i);
            l.setTipoOperacao(null);
            return l;
        }).collect(Collectors.toList());
        return itensLiberacao;
    }

    public WebDTOResult getNecessidadeCompra(Long[] ids) {
        WebDTOResult dto = new WebDTOResult();
        Object idNecessidadesLiberadas = "";
        ArrayList<NecessidadeCompra> necessidades = new ArrayList<NecessidadeCompra>();
        for (NecessidadeCompra n : this.serviceNecessidadeCompraImpl.gets(ids)) {
            if (this.isNull(n.getLiberacaoNecCompraItem()).booleanValue()) {
                necessidades.add(n);
                continue;
            }
            if (!this.isStrWithData((String)idNecessidadesLiberadas)) {
                idNecessidadesLiberadas = (String)idNecessidadesLiberadas + n.getIdentificador();
                continue;
            }
            idNecessidadesLiberadas = (String)idNecessidadesLiberadas + "," + n.getIdentificador();
        }
        if (this.isStrWithData((String)idNecessidadesLiberadas)) {
            dto.addWarning("E.ERP.1245.005", new Object[]{idNecessidadesLiberadas});
        }
        return dto.setResult(this.buildToDTOGeneric(this.criarLiberacaoNecCompraItem(necessidades), DTOLiberacaoNecCompraItem.class));
    }
}

