/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaonfterceiros;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.liberacaonotaterceiros.EnumLiberacaoNFTerceiros;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemConfNFTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFinanceiro;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoNotaFiscalTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.liberacaonfterceiros.ServiceLiberacaoNFTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.requisicao.ServiceRequisicaoImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SCompLiberacaoNFTerceirosImpl
extends ServiceGenericImpl {
    @Autowired
    CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    @Autowired
    ServiceRequisicaoImpl serviceRequisicaoImpl;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    @Autowired
    ServiceLiberacaoNFTerceirosImpl serviceLiberacaoNFTerceirosImpl;

    public void salvaLiberacaoFinanceiraNFTerceiros(LiberacaoNFTerceirosFinanceiro vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        if (this.isEquals(vo.getConferida(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, opcoesContabeis);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, false);
            nota = this.updateNotaTerceiros(nota);
        }
    }

    public void excluirLiberacaoFinanceiraNFTerceiros(LiberacaoNFTerceirosFinanceiro vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) {
        if (this.isEquals(vo.getConferida(), EnumConstantsMentorSimNao.SIM.getValue())) {
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, false);
        }
        vo.getLiberacaoNota().setLiberacaoFinanceira(null);
        this.serviceLiberacaoNFTerceirosImpl.saveOrUpdate(vo.getLiberacaoNota());
    }

    public void salvaLiberacaoFiscalNFTerceiros(LiberacaoNFTerceirosFiscal vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        if (this.isEquals(vo.getConferida(), EnumConstantsMentorSimNao.SIM.getValue())) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, opcoesContabeis);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, false);
            nota = this.updateNotaTerceiros(nota);
        }
    }

    public void excluirLiberacaoFiscalNFTerceiros(LiberacaoNFTerceirosFiscal vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        if (this.isEquals(vo.getConferida(), EnumConstantsMentorSimNao.SIM.getValue())) {
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            this.gerarLivrosFiscais(nota, opcoesCompra, false);
            this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, false, opcoesContabeis);
        }
        vo.getLiberacaoNota().setLiberacaoFiscal(null);
        this.serviceLiberacaoNFTerceirosImpl.saveOrUpdate(vo.getLiberacaoNota());
    }

    private void isValidAndCreateUltimaLiberacao(OpcoesCompraSuprimentos opcoesCompra, LiberacaoNFTerceiros liberacaoNota, EmpresaContabilidade empresaContabilidade, Boolean liberada, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        int countTiposLiberacao = (int)Stream.of(opcoesCompra.getLiberacaoEstoque(), opcoesCompra.getLiberacaoFinanceiro(), opcoesCompra.getLiberacaoFiscal(), opcoesCompra.getLiberacaoQualidade()).filter(liberacao -> this.isEquals(EnumConstantsMentorSimNao.SIM.getValue(), liberacao)).count();
        if (countTiposLiberacao > 0 && (this.isNotNull(liberacaoNota.getLiberacaoEstoque()) != false && this.isEquals(liberacaoNota.getLiberacaoEstoque().getConferida(), EnumConstantsMentorSimNao.SIM.getValue()) || this.isNotNull(liberacaoNota.getLiberacaoFinanceira()) != false && this.isEquals(liberacaoNota.getLiberacaoFinanceira().getConferida(), EnumConstantsMentorSimNao.SIM.getValue()) || this.isNotNull(liberacaoNota.getLiberacaoFiscal()) != false && this.isEquals(liberacaoNota.getLiberacaoFiscal().getConferida(), EnumConstantsMentorSimNao.SIM.getValue()) || this.isNotNull(liberacaoNota.getLiberacaoQualidade()).booleanValue() && this.isEquals(liberacaoNota.getLiberacaoQualidade().getConferida(), EnumConstantsMentorSimNao.SIM.getValue()))) {
            this.createLiberacoes(liberacaoNota, opcoesCompra, empresaContabilidade, liberada, opcoesContabeis);
        }
    }

    private void createLiberacoes(LiberacaoNFTerceiros liberacaoNota, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, Boolean liberada, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        liberacaoNota.setConferidaTotalmente(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        liberacaoNota.setDataConferenciaTotal(new Date());
        NotaFiscalTerceiros nota = liberacaoNota.getNotaTerceiros();
        this.atualizarDataNF(nota, opcoesCompra);
        this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, liberada);
        this.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, liberada);
        this.gerarLivrosFiscais(nota, opcoesCompra, liberada);
        this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, liberada, opcoesContabeis);
        nota = this.updateNotaTerceiros(nota);
        this.gerarRequisicao(nota);
    }

    private void atualizarDataNF(NotaFiscalTerceiros nota, OpcoesCompraSuprimentos opcoesCompra) {
        if (this.isEquals(opcoesCompra.getAtualizarDataNFLiberacao(), EnumConstantsMentorSimNao.SIM.getValue())) {
            nota.setDataEntrada(new Date());
            nota.getItemNotaTerceiros().forEach(item -> item.getGrade().forEach(grade -> grade.setDataEntradaSaida(nota.getDataEntrada())));
            nota.getLivrosFiscais().forEach(livro -> livro.setDataLivro(nota.getDataEntrada()));
        }
    }

    private void atualizarTitulosNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberada) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || this.isEquals(opcoesCompra.getUtilizarSomenteLibSel(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isNotNull(opcoesCompra.getLiberacaoFinanceiro()).booleanValue() && this.isEquals(opcoesCompra.getLiberacaoFinanceiro(), EnumConstantsMentorSimNao.SIM.getValue())) {
            notaTerceiros.getInfPagamentoNfTerceiros().forEach(inf -> inf.getTitulos().forEach(titulo -> titulo.setProvisao(liberada != false ? EnumConstTituloProvReal.REALIZADO.getValue() : EnumConstTituloProvReal.PROVISIONADO.getValue())));
        }
    }

    private void atualizarMovimentacaoEstoqueNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberada) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || this.isEquals(opcoesCompra.getUtilizarSomenteLibSel(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isNotNull(opcoesCompra.getLiberacaoEstoque()).booleanValue() && this.isEquals(opcoesCompra.getLiberacaoEstoque(), EnumConstantsMentorSimNao.SIM.getValue())) {
            notaTerceiros.getItemNotaTerceiros().stream().filter(itemNota -> this.isEquals(itemNota.getModeloFiscal().getMovimentacaoFisica(), EnumConstantsMentorSimNao.SIM.getValue())).forEach(itemNota -> itemNota.getGrade().forEach(grade -> grade.setMovimentacaoFisica(Short.valueOf(liberada != false ? EnumConstantsMentorSimNao.SIM.getValue() : EnumConstantsMentorSimNao.NAO.getValue()))));
        }
    }

    private void gerarLivrosFiscais(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberada) {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || this.isEquals(opcoesCompra.getUtilizarSomenteLibSel(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isNotNull(opcoesCompra.getLiberacaoFiscal()).booleanValue() && this.isEquals(opcoesCompra.getLiberacaoFiscal(), EnumConstantsMentorSimNao.SIM.getValue())) {
            notaTerceiros.getLivrosFiscais().forEach(livroFiscal -> livroFiscal.setCancelado(Short.valueOf(liberada != false ? EnumConstantsMentorSimNao.NAO.getValue() : EnumConstantsMentorSimNao.SIM.getValue())));
        }
    }

    private void gerarLancamentosContabeis(NotaFiscalTerceiros notaTerceiros, EmpresaContabilidade empresaContabilidade, OpcoesCompraSuprimentos opcoesCompra, Boolean liberada, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        if (this.isNull(opcoesCompra.getUtilizarSomenteLibSel()).booleanValue() || this.isEquals(opcoesCompra.getUtilizarSomenteLibSel(), EnumConstantsMentorSimNao.NAO.getValue()) || this.isNotNull(opcoesCompra.getLiberacaoFiscal()).booleanValue() && this.isEquals(opcoesCompra.getLiberacaoFiscal(), EnumConstantsMentorSimNao.SIM.getValue())) {
            notaTerceiros.setIntegracaoNotaTerceiros(null);
            if (liberada.booleanValue() && this.isEquals(empresaContabilidade.getLancNotaTerceiros(), (short)0)) {
                LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(notaTerceiros, opcoesContabeis);
                IntegracaoNotaTerceirosNotas integracaoNotaTerceirosNotas = notaTerceiros.getIntegracaoNotaTerceiros();
                if (this.isNull(integracaoNotaTerceirosNotas).booleanValue()) {
                    integracaoNotaTerceirosNotas = new IntegracaoNotaTerceirosNotas();
                    integracaoNotaTerceirosNotas.setNotaFiscalTerceiros(notaTerceiros);
                }
                integracaoNotaTerceirosNotas.setLoteContabil(loteContabil);
                notaTerceiros.setIntegracaoNotaTerceiros(integracaoNotaTerceirosNotas);
            }
        }
    }

    private NotaFiscalTerceiros updateNotaTerceiros(NotaFiscalTerceiros notaTerceiros) {
        if (this.isNotNull(notaTerceiros.getRequisicao()).booleanValue()) {
            this.serviceRequisicaoImpl.delete(notaTerceiros.getRequisicao());
            notaTerceiros.setRequisicao(null);
        }
        return this.serviceNotaFiscalTerceirosImpl.saveOrUpdate(notaTerceiros);
    }

    private void gerarRequisicao(NotaFiscalTerceiros notaTerceiros) {
        Requisicao requisicao = new CompRequisicaoNotaFiscalTerceiros().criarRequisicaoNotaTerceiros(notaTerceiros);
        if (this.isNotNull(requisicao).booleanValue()) {
            requisicao.setNotaFiscalTerc(notaTerceiros);
            notaTerceiros.setRequisicao(this.serviceRequisicaoImpl.saveOrUpdate(requisicao));
        }
    }

    public List getLiberacacoes(List<NotaFiscalTerceiros> notas, Empresa empresa, Usuario usuario, EnumLiberacaoNFTerceiros tipoLiberacao) {
        if (SCompLiberacaoNFTerceirosImpl.isWithData(notas)) {
            switch (tipoLiberacao) {
                case LIBERACAO_ESTOQUE: {
                    return this.createAndSaveLiberacaoEstoqueNFT(notas, empresa, usuario);
                }
                case LIBERACAO_QUALIDADE: {
                    return new ArrayList();
                }
                case LIBERACAO_FINANCEIRA: {
                    return new ArrayList();
                }
                case LIBERACAO_FISCAL: {
                    return new ArrayList();
                }
            }
        }
        return new ArrayList();
    }

    private List<ConferenciaNFTerceiros> createAndSaveLiberacaoEstoqueNFT(List<NotaFiscalTerceiros> notas, Empresa empresa, Usuario usuario) {
        ArrayList<ConferenciaNFTerceiros> aux = new ArrayList<ConferenciaNFTerceiros>();
        if (SCompLiberacaoNFTerceirosImpl.isWithData(notas)) {
            for (NotaFiscalTerceiros n : notas) {
                ConferenciaNFTerceiros vo = new ConferenciaNFTerceiros();
                vo.setConferida(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                vo.setDataCadastro(new Date());
                vo.setDataLiberacao(null);
                vo.setEmpresa(empresa);
                vo.setUsuario(usuario);
                LiberacaoNFTerceiros lib = n.getLiberacaoNFTerceiros();
                if (this.isNull(lib).booleanValue()) {
                    lib = new LiberacaoNFTerceiros();
                    lib.setNotaTerceiros(n);
                }
                vo.setItemConfNFTerceiros(this.createItemConfNFTerceiros(n, vo));
                lib.setLiberacaoEstoque(vo);
                lib.setNotaTerceiros(n);
                vo.setLiberacaoNota(lib);
                n.setLiberacaoNFTerceiros(lib);
                aux.add(vo);
            }
        }
        return aux;
    }

    private List<ItemConfNFTerceiros> createItemConfNFTerceiros(NotaFiscalTerceiros n, ConferenciaNFTerceiros vo) {
        if (this.isNull(n).booleanValue()) {
            return new ArrayList<ItemConfNFTerceiros>();
        }
        ArrayList<ItemConfNFTerceiros> dados = new ArrayList<ItemConfNFTerceiros>();
        for (ItemNotaTerceiros i : n.getItemNotaTerceiros()) {
            HashMap<GradeCor, Double> h = new HashMap<GradeCor, Double>();
            for (GradeItemNotaTerceiros g : i.getGrade()) {
                if (h.containsKey(g.getGradeCor())) {
                    Double qtdeAnt = (Double)h.get(g.getGradeCor());
                    h.put(g.getGradeCor(), qtdeAnt + g.getQuantidade() * i.getFatorConversao());
                    continue;
                }
                h.put(g.getGradeCor(), g.getQuantidade() * i.getFatorConversao());
            }
            Set set = h.keySet();
            for (GradeCor gradeCor : set) {
                Double qtde = (Double)h.get(gradeCor);
                ItemConfNFTerceiros itemConf = new ItemConfNFTerceiros();
                itemConf.setGradeCor(gradeCor);
                itemConf.setQuantidadeAConferir(qtde);
                itemConf.setConferenciaNFTerceiros(vo);
                dados.add(itemConf);
            }
        }
        return dados;
    }
}

