/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaonfterceirosfinanceiro;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFinanceiro;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoNFTerceirosFinanceiroImpl;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.liberacaonotaterceiros.HelperLiberacaoNotaTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.liberacaonfterceiros.SCompLiberacaoNFTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoNFTerceirosFinanceiroImpl
extends ServiceGenericEntityImpl<LiberacaoNFTerceirosFinanceiro, Long, DaoLiberacaoNFTerceirosFinanceiroImpl> {
    @Autowired
    HelperLiberacaoNotaTerceiros helperLiberacaoNotaTerceiros;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    SCompLiberacaoNFTerceirosImpl sCompLiberacaoNFTerceirosImpl;
    @Autowired
    ServiceOpcoesContabeisImpl serviceOpcoesContabeisImpl;
    @Autowired
    ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl;
    @Autowired
    ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidadeImpl;

    @Autowired
    public ServiceLiberacaoNFTerceirosFinanceiroImpl(DaoLiberacaoNFTerceirosFinanceiroImpl dao) {
        super(dao);
    }

    @Override
    public LiberacaoNFTerceirosFinanceiro beforeSaveEntity(LiberacaoNFTerceirosFinanceiro vo) {
        if (vo.getLiberacaoNota() != null) {
            vo.getLiberacaoNota().setLiberacaoFinanceira(vo);
            vo.getLiberacaoNota().getNotaTerceiros().setLiberacaoNFTerceiros(vo.getLiberacaoNota());
        }
        return vo;
    }

    @Override
    public LiberacaoNFTerceirosFinanceiro afterSaveEntity(LiberacaoNFTerceirosFinanceiro vo) {
        OpcoesCompraSuprimentos opcoesCompra = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidadeImpl.findByEmpresa(vo.getEmpresa());
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        try {
            this.sCompLiberacaoNFTerceirosImpl.salvaLiberacaoFinanceiraNFTerceiros(vo, opcoesCompra, empresaContabilidade, opcoesContabeis);
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
        return vo;
    }

    @Override
    public LiberacaoNFTerceirosFinanceiro beforeDeleteEntity(LiberacaoNFTerceirosFinanceiro vo) {
        OpcoesCompraSuprimentos opcoesCompra = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidadeImpl.findByEmpresa(vo.getEmpresa());
        if (this.isNotNull(vo.getLiberacaoNota().getConferidaTotalmente()).booleanValue() && this.isEquals(vo.getLiberacaoNota().getConferidaTotalmente(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1749.001"));
        }
        this.sCompLiberacaoNFTerceirosImpl.excluirLiberacaoFinanceiraNFTerceiros(vo, opcoesCompra, empresaContabilidade);
        return vo;
    }

    public List<LiberacaoNFTerceirosFinanceiro> findNotasNaoLiberadasFinanceiro(Date dataInicial, Date dataFinal, Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoesCompras) {
        List<NotaFiscalTerceiros> notas = this.serviceNotaFiscalTerceiros.findNotasNaoLiberadasFinanceiro(dataInicial, dataFinal, empresa, opcoesCompras);
        ArrayList<LiberacaoNFTerceirosFinanceiro> response = new ArrayList<LiberacaoNFTerceirosFinanceiro>();
        if (notas != null) {
            for (NotaFiscalTerceiros n : notas) {
                if (this.isNotNull(n.getLiberacaoNFTerceiros()).booleanValue()) {
                    this.reload(n.getLiberacaoNFTerceiros());
                }
                ((DaoNotaFiscalTerceirosImpl)this.serviceNotaFiscalTerceiros.getGenericDao()).evict(n);
                response.add(this.helperLiberacaoNotaTerceiros.build(n).createLiberacaoFinanceiraNFT(empresa, usuario));
            }
        }
        return response;
    }
}

