/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaonfterceirosfiscal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoNFTerceirosFiscalImpl;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.liberacaonotaterceiros.HelperLiberacaoNotaTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.liberacaonfterceiros.SCompLiberacaoNFTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoNFTerceirosFiscalImpl
extends ServiceGenericEntityImpl<LiberacaoNFTerceirosFiscal, Long, DaoLiberacaoNFTerceirosFiscalImpl> {
    @Autowired
    HelperLiberacaoNotaTerceiros helperLiberacaoNotaTerceiros;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    SCompLiberacaoNFTerceirosImpl sCompLiberacaoNFTerceirosImpl;
    @Autowired
    ServiceOpcoesContabeisImpl serviceOpcoesContabeisImpl;
    @Autowired
    ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl;
    @Autowired
    ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidadeImpl;

    @Autowired
    public ServiceLiberacaoNFTerceirosFiscalImpl(DaoLiberacaoNFTerceirosFiscalImpl dao) {
        super(dao);
    }

    @Override
    public LiberacaoNFTerceirosFiscal beforeSave(LiberacaoNFTerceirosFiscal vo) {
        if (vo.getLiberacaoNota() != null) {
            vo.getLiberacaoNota().setLiberacaoFiscal(vo);
            vo.getLiberacaoNota().getNotaTerceiros().setLiberacaoNFTerceiros(vo.getLiberacaoNota());
        }
        return vo;
    }

    @Override
    public LiberacaoNFTerceirosFiscal afterSaveEntity(LiberacaoNFTerceirosFiscal vo) {
        OpcoesCompraSuprimentos opcoesCompra = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidadeImpl.findByEmpresa(vo.getEmpresa());
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        try {
            this.sCompLiberacaoNFTerceirosImpl.salvaLiberacaoFiscalNFTerceiros(vo, opcoesCompra, empresaContabilidade, opcoesContabeis);
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
        return vo;
    }

    @Override
    public LiberacaoNFTerceirosFiscal beforeDeleteEntity(LiberacaoNFTerceirosFiscal vo) {
        OpcoesCompraSuprimentos opcoesCompra = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidadeImpl.findByEmpresa(vo.getEmpresa());
        OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.getByIdEmpresa(vo.getEmpresa().getIdentificador());
        if (this.isNotNull(vo.getLiberacaoNota().getConferidaTotalmente()).booleanValue() && this.isEquals(vo.getLiberacaoNota().getConferidaTotalmente(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1750.001"));
        }
        try {
            this.sCompLiberacaoNFTerceirosImpl.excluirLiberacaoFiscalNFTerceiros(vo, opcoesCompra, empresaContabilidade, opcoesContabeis);
        }
        catch (ExceptionInvalidData ex) {
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
        return vo;
    }

    public List<LiberacaoNFTerceirosFiscal> findNotasNaoLiberadasFiscal(Date dataInicial, Date dataFinal, Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoesCompras) {
        List<NotaFiscalTerceiros> notas = this.serviceNotaFiscalTerceiros.findNotasNaoLiberadasFiscal(dataInicial, dataFinal, empresa, opcoesCompras);
        ArrayList<LiberacaoNFTerceirosFiscal> response = new ArrayList<LiberacaoNFTerceirosFiscal>();
        if (notas != null) {
            for (NotaFiscalTerceiros n : notas) {
                ((DaoNotaFiscalTerceirosImpl)this.serviceNotaFiscalTerceiros.getGenericDao()).evict(n);
                response.add(this.helperLiberacaoNotaTerceiros.build(n).createLiberacaoFiscalNFT(empresa, usuario));
            }
        }
        return response;
    }
}

