/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaonftqualidade;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InfAdicionalItemConfNFTerc;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemConfNFTerc;
import com.touchcomp.basementor.model.vo.ItemLiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoNFTerceirosQualidadeImpl;
import com.touchcomp.basementorservice.dao.impl.DaoNotaFiscalTerceirosImpl;
import com.touchcomp.basementorservice.helpers.impl.liberacaonotaterceiros.HelperLiberacaoNotaTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.liberacaonfterceiros.ServiceLiberacaoNFTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoNFTerceirosQualidadeImpl
extends ServiceGenericEntityImpl<LiberacaoNFTerceirosQualidade, Long, DaoLiberacaoNFTerceirosQualidadeImpl> {
    @Autowired
    HelperLiberacaoNotaTerceiros helperLiberacaoNotaTerceiros;
    @Autowired
    ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;
    @Autowired
    ServiceLiberacaoNFTerceirosImpl serviceLiberacaoNFTerceiros;

    @Autowired
    public ServiceLiberacaoNFTerceirosQualidadeImpl(DaoLiberacaoNFTerceirosQualidadeImpl genericDao) {
        super(genericDao);
    }

    @Override
    public LiberacaoNFTerceirosQualidade beforeSave(LiberacaoNFTerceirosQualidade vo) {
        if (vo.getItensLiberacao() != null) {
            for (ItemLiberacaoNFTerceirosQualidade i : vo.getItensLiberacao()) {
                i.setLiberacaoQualidade(vo);
                InfAdicionalItemConfNFTerc infAd = i.getInfAdicionalItemConfNFTerc();
                infAd.setItemLiberacaoQualidade(i);
                if (infAd == null || infAd.getItemInfAdicionalItemConfNFe() == null) continue;
                for (ItemInfAdicionalItemConfNFTerc j : infAd.getItemInfAdicionalItemConfNFe()) {
                    j.setInfAdicionalItemConfNFe(infAd);
                }
            }
        }
        if (vo.getLiberacaoNota() != null) {
            LiberacaoNFTerceiros lib = vo.getLiberacaoNota();
            lib.getNotaTerceiros().setLiberacaoNFTerceiros(vo.getLiberacaoNota());
            lib.setLiberacaoQualidade(vo);
        }
        return vo;
    }

    public List<LiberacaoNFTerceirosQualidade> findNotasNaoLiberadasQualidade(Date dataInicial, Date dataFinal, Empresa empresa, Usuario usuario, OpcoesCompraSuprimentos opcoesCompras) {
        List<NotaFiscalTerceiros> notas = this.serviceNotaFiscalTerceiros.findNotasNaoLiberadasQualidade(dataInicial, dataFinal, empresa, opcoesCompras);
        ArrayList<LiberacaoNFTerceirosQualidade> response = new ArrayList<LiberacaoNFTerceirosQualidade>();
        if (notas != null) {
            for (NotaFiscalTerceiros n : notas) {
                ((DaoNotaFiscalTerceirosImpl)this.serviceNotaFiscalTerceiros.getGenericDao()).evict(n);
                response.add(this.helperLiberacaoNotaTerceiros.build(n).createLiberacaoQualidadeNFT(empresa, usuario));
            }
        }
        return response;
    }
}

