/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaoordemcompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ordemcompra.EnumConstOrdemCompraStatus;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.GrupoLiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.ItemConfLibOrdemCompraUsuario;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoGrupoLiberacaoOrdemCompraItemImpl;
import com.touchcomp.basementorservice.dao.impl.DaoOrdemCompraImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.configuracaoliberacaoordemcompra.ServiceItemConfLibOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.liberacaoordemcompra.ServiceLiberacaoOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.liberacaoordemcompra.ServiceLiberacaoOrdemCompraItem;
import com.touchcomp.basementorservice.service.impl.ordemcompra.ServiceOrdemCompraImpl;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceGrupoLiberacaoOrdemCompraItemImpl
extends ServiceGenericEntityImpl<GrupoLiberacaoOrdemCompraItem, Long, DaoGrupoLiberacaoOrdemCompraItemImpl> {
    @Autowired
    ServiceLiberacaoOrdemCompraImpl serviceLiberacaoOrdemCompraImpl;
    @Autowired
    ServiceItemConfLibOrdemCompraImpl serviceConf;
    @Autowired
    ServiceOrdemCompraImpl serviceOrdemCompra;
    @Autowired
    ServiceBoletoTituloImpl serviceBoletoTitulo;
    @Autowired
    ServiceLiberacaoOrdemCompraItem serviceLiberacaoOrdemCompraItem;

    public ServiceGrupoLiberacaoOrdemCompraItemImpl(DaoGrupoLiberacaoOrdemCompraItemImpl genericDao) {
        super(genericDao);
    }

    @Override
    public GrupoLiberacaoOrdemCompraItem saveOrUpdateOnly(GrupoLiberacaoOrdemCompraItem vo) {
        ItemConfLibOrdemCompraUsuario conf = this.serviceConf.get(vo.getEmpresa(), vo.getUsuario());
        HashMap<Long, LiberacaoOrdemCompra> map = new HashMap<Long, LiberacaoOrdemCompra>();
        LinkedList<LiberacaoOrdemCompra> aux = new LinkedList<LiberacaoOrdemCompra>();
        LinkedList<LiberacaoOrdemCompraItem> itens = new LinkedList<LiberacaoOrdemCompraItem>();
        for (LiberacaoOrdemCompraItem item : vo.getItens()) {
            if (Objects.equals(item.getCancelado(), (short)1)) {
                if (item.getLiberacaoOrdemCompra().getOrdemCompra().getStatusOrdemCompra().getStatus().shortValue() != EnumConstOrdemCompraStatus.CANCELADO.getValue()) {
                    throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0274.002"));
                }
                this.cancelaOrdemCompra(item.getLiberacaoOrdemCompra());
                LiberacaoOrdemCompraItem lib = (LiberacaoOrdemCompraItem)this.serviceLiberacaoOrdemCompraItem.get(item.getIdentificador());
                if (lib == null) continue;
                lib.setCancelado(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                itens.add(lib);
                continue;
            }
            if (!Objects.equals(item.getLiberado(), (short)1)) continue;
            if (!map.containsKey(item.getLiberacaoOrdemCompra().getIdentificador())) {
                map.put(item.getLiberacaoOrdemCompra().getIdentificador(), (LiberacaoOrdemCompra)this.serviceLiberacaoOrdemCompraImpl.get(item.getLiberacaoOrdemCompra().getIdentificador()));
            }
            LiberacaoOrdemCompra l = (LiberacaoOrdemCompra)map.get(item.getLiberacaoOrdemCompra().getIdentificador());
            l.getItens().forEach(it -> {
                if (it.equals((Object)item)) {
                    it.setLiberado(item.getLiberado());
                    it.setCancelado(item.getCancelado());
                    it.setUsuario(vo.getUsuario());
                    it.setDataLiberacao(vo.getDataCadastro());
                    it.setPontuacao(conf.getPontuacao());
                    itens.add((LiberacaoOrdemCompraItem)it);
                }
            });
        }
        for (LiberacaoOrdemCompra lib : map.values()) {
            boolean all = true;
            Double pontuacao = this.getSharedData().getOpcoesCompraSuprimentos(lib.getEmpresa()).getPontuacao();
            if (ToolMethods.isWithData((Number)pontuacao)) {
                boolean bl = all = all && this.verificarPontuacao(lib, pontuacao);
                if (!all) {
                    this.criarLiberacaoOrdemCompraItem(lib, vo, itens);
                }
            } else {
                for (LiberacaoOrdemCompraItem item : lib.getItens()) {
                    all = all && Objects.equals(item.getLiberado(), (short)1);
                }
            }
            if (all) {
                lib.setLiberado(Short.valueOf((short)1));
                lib.setUsuario(vo.getUsuario());
                lib.getOrdemCompra().setStatusOrdemCompra(conf.getConfLiberacaoOC().getStatusOCLiberado());
                aux.add(lib);
                lib.getOrdemCompra().setLiberada(Short.valueOf((short)1));
                continue;
            }
            lib.getOrdemCompra().setLiberada(Short.valueOf((short)0));
        }
        vo.setItens(itens);
        for (LiberacaoOrdemCompraItem it2 : itens) {
            it2.setGrupoLibOrdemCompraItem(vo);
        }
        GrupoLiberacaoOrdemCompraItem ret = ((DaoGrupoLiberacaoOrdemCompraItemImpl)this.getGenericDao()).saveOrUpdate(vo);
        this.serviceLiberacaoOrdemCompraImpl.saveOrUpdate(aux);
        return ret;
    }

    private boolean verificarPontuacao(LiberacaoOrdemCompra lib, Double pontuacao) {
        Double pontuacaoTotal = 0.0;
        for (LiberacaoOrdemCompraItem item : lib.getItens()) {
            if (!this.isEquals(item.getLiberado(), (short)1)) continue;
            pontuacaoTotal = pontuacaoTotal + item.getPontuacao();
        }
        return pontuacaoTotal >= pontuacao;
    }

    private void cancelaOrdemCompra(LiberacaoOrdemCompra liberacaoOrdemCompra) {
        OrdemCompra ordemCompra = liberacaoOrdemCompra.getOrdemCompra();
        OrdemCompra vo = (OrdemCompra)this.serviceOrdemCompra.get(ordemCompra.getIdentificador());
        vo.setStatusOrdemCompra(ordemCompra.getStatusOrdemCompra());
        if (vo != null && vo.getTitulos() != null) {
            for (Titulo t : vo.getTitulos()) {
                for (BoletoTitulo b : t.getBoletoTitulo()) {
                    b.setTitulo(null);
                    b.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                }
                this.serviceBoletoTitulo.saveOrUpdate(t.getBoletoTitulo());
            }
            vo.getTitulos().clear();
            vo.setMotivoCancelamento("Cancelamento efetuado pelo recurso 274");
            ((DaoOrdemCompraImpl)this.serviceOrdemCompra.getGenericDao()).saveOrUpdate(vo);
        }
    }

    private void criarLiberacaoOrdemCompraItem(LiberacaoOrdemCompra lib, GrupoLiberacaoOrdemCompraItem vo, List<LiberacaoOrdemCompraItem> itens) {
        try {
            LiberacaoOrdemCompraItem l = (LiberacaoOrdemCompraItem)ToolClone.cloneEntity((Object)((LiberacaoOrdemCompraItem)lib.getItens().get(0)));
            l.setDataLiberacao(null);
            l.setLiberado(Short.valueOf((short)0));
            l.setUsuario(null);
            l.setPontuacao(Double.valueOf(0.0));
            l.setGrupoLibOrdemCompraItem(null);
            l.setLiberacaoOrdemCompra(lib);
            lib.getItens().add(l);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

