/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaoordemcompra;

import com.touchcomp.basementor.constants.enums.liberacaoordemcompra.ConstEnumLiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemConfLibOrdemCompraUsuario;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoOrdemCompraItemImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.configuracaoliberacaoordemcompra.ServiceItemConfLibOrdemCompraImpl;
import com.touchcomp.touchvomodel.vo.liberacaoordemcompra.DTOGrupoLiberacaoOrdemCompraItem;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoOrdemCompraItem
extends ServiceGenericEntityImpl<LiberacaoOrdemCompraItem, Long, DaoLiberacaoOrdemCompraItemImpl> {
    @Autowired
    private ServiceItemConfLibOrdemCompraImpl serviceConfLiberacaoOCImpl;

    public ServiceLiberacaoOrdemCompraItem(DaoLiberacaoOrdemCompraItemImpl genericDao) {
        super(genericDao);
    }

    public List<DTOGrupoLiberacaoOrdemCompraItem.DTOLiberacaoOrdemCompraItem> getOrdensCompraPassiveisLibDTO(Usuario user, Empresa empresa) throws ExceptionInvalidData {
        return this.buildToDTO(this.getOrdensCompraPassiveisLib(user, empresa), DTOGrupoLiberacaoOrdemCompraItem.DTOLiberacaoOrdemCompraItem.class);
    }

    public List<LiberacaoOrdemCompraItem> getOrdensCompraPassiveisLib(Usuario user, Empresa empresa) throws ExceptionInvalidData {
        ItemConfLibOrdemCompraUsuario conf = this.serviceConfLiberacaoOCImpl.get(empresa, user);
        if (conf == null || conf.getConfLiberacaoOC() == null || conf.getConfLiberacaoOC().getTipoLiberacaoOC() == null) {
            throw new ExceptionInvalidData("E.ERP.0274.001", new Object[]{user, empresa});
        }
        ConstEnumLiberacaoOrdemCompra tipoLiberacaoOC = ConstEnumLiberacaoOrdemCompra.get((Object)conf.getConfLiberacaoOC().getTipoLiberacaoOC());
        switch (tipoLiberacaoOC) {
            case TIPO_LIBERACAO_CLASSIFICACAO: {
                return ((DaoLiberacaoOrdemCompraItemImpl)this.getGenericDao()).getOrdensCompraConfConfigLibClassificacao(conf.getItemClassificacao(), empresa, user);
            }
            case TIPO_LIBERACAO_VALOR: {
                if (conf.getItemConfLibOCValor() == null) {
                    throw new ExceptionInvalidData("E.ERP.0274.001", new Object[]{user, empresa});
                }
                return ((DaoLiberacaoOrdemCompraItemImpl)this.getGenericDao()).getOrdensCompraConfConfigLibValor(conf.getItemConfLibOCValor(), empresa, user);
            }
            case TIPO_LIBERACAO_ESPECIE: {
                return ((DaoLiberacaoOrdemCompraItemImpl)this.getGenericDao()).getOrdensCompraConfConfigLibEspecie(conf.getEspecieLiberacaoOrdemCompra(), empresa, user);
            }
            case TIPO_LIBERACAO_NENHUM: {
                throw new ExceptionInvalidData("E.ERP.0274.001", new Object[]{user, empresa});
            }
        }
        throw new ExceptionErroProgramacao("Tipo de liberacao de ordem de compra nao mapeado " + String.valueOf(tipoLiberacaoOC));
    }
}

