/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.liberacaotitulos;

import com.touchcomp.basementor.model.vo.GeracaoTitulosFolhaPagamento;
import com.touchcomp.basementor.model.vo.LiberacaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoLiberacaoTitulosImpl;
import com.touchcomp.basementorservice.helpers.impl.liberacaotitulos.HelperLiberacaoTitulos;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.geracaotitulosfolhapagamento.ServiceGeracaoTitulosFolhaPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.touchvomodel.vo.liberacaotitulo.DTOLiberacaoTitulos;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLiberacaoTitulosImpl
extends ServiceGenericEntityImpl<LiberacaoTitulos, Long, DaoLiberacaoTitulosImpl> {
    HelperLiberacaoTitulos helperLiberacao;
    ServiceGeracaoTitulosFolhaPagamentoImpl serviceGeracaoTitulosFolhaPagamentoImpl;
    ServiceTituloImpl serviceTituloImpl;

    @Autowired
    public ServiceLiberacaoTitulosImpl(DaoLiberacaoTitulosImpl genericDao, HelperLiberacaoTitulos helperLiberacao, ServiceGeracaoTitulosFolhaPagamentoImpl serviceGeracaoTitulosFolhaPagamentoImpl, ServiceTituloImpl serviceTituloImpl) {
        super(genericDao);
        this.helperLiberacao = helperLiberacao;
        this.serviceGeracaoTitulosFolhaPagamentoImpl = serviceGeracaoTitulosFolhaPagamentoImpl;
        this.serviceTituloImpl = serviceTituloImpl;
    }

    @Override
    public LiberacaoTitulos beforeSave(LiberacaoTitulos aux) {
        aux.getItemLiberacao().forEach(i -> i.setLiberacaoTitulo(aux));
        this.helperLiberacao.build(aux).calcularTotais();
        return aux;
    }

    public List<DTOLiberacaoTitulos.DTOItemLiberacaoTitulo> efetuarLiberacao(Long geracaoTitulosFolhaPagamento) throws ExceptionObjNotFound {
        GeracaoTitulosFolhaPagamento geracaoTitulos = (GeracaoTitulosFolhaPagamento)this.serviceGeracaoTitulosFolhaPagamentoImpl.getOrThrow(geracaoTitulosFolhaPagamento);
        List dto = geracaoTitulos.getTitulos().stream().map(i -> {
            DTOLiberacaoTitulos.DTOItemLiberacaoTitulo item = this.serviceTituloImpl.findTituloNaoLiberado(i.getIdentificador());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(dto, DTOLiberacaoTitulos.DTOItemLiberacaoTitulo.class);
    }
}

