/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.livrofiscal;

import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ObservacaoLivroFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.service.impl.livrofiscal.LivroFiscalSource;
import com.touchcomp.basementorservice.service.impl.livrofiscal.SCAjustesObrigacoesLivroFiscal;
import com.touchcomp.basementorservice.service.impl.livrofiscal.adapters.LivroFiscalSourceNFTerceiros;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SCompLivroFiscal {
    public void getLivroFiscal(NotaFiscalTerceiros nf, List<LivroFiscal> livrosFiscalOld) throws ExceptionAvaliadorExpressoes {
        LinkedList<LivroFiscalSource> sources = new LinkedList<LivroFiscalSource>();
        nf.getItemNotaTerceiros().forEach(i -> sources.add(new LivroFiscalSourceNFTerceiros((ItemNotaTerceiros)i)));
        nf.setLivrosFiscais(this.getLivroFiscal(sources, livrosFiscalOld, nf.getLivrosFiscais()));
    }

    private List<LivroFiscal> getLivroFiscal(List<LivroFiscalSource> sources, List<LivroFiscal> livrosFiscalOld, List<LivroFiscal> livros) throws ExceptionAvaliadorExpressoes {
        for (LivroFiscalSource livroSource : sources) {
            LivroFiscal livro = new LivroFiscal(livroSource.getCfop(), livroSource.getPlanoConta(), livroSource.getIncidenciaIcms(), livroSource.getIncidenciaIpi(), livroSource.getAliquotaIcms(), livroSource.getAliquotaIcmsProduto(), livroSource.getDataLivro(), livroSource.getIncidenciaPis(), livroSource.getIncidenciaCofins(), livroSource.getAliquotaPis(), livroSource.getAliquotaCofins(), livroSource.getAliquotaPisQtde(), livroSource.getAliquotaCofinsQtde());
            int aux = livros.indexOf(livro);
            if (aux > -1) {
                livro = livros.get(aux);
            } else {
                livros.add(livro);
            }
            livro.setValorFreteIcmsST(Double.valueOf(livro.getValorFreteIcmsST() + livroSource.getValorFreteIcmsST()));
            livro.setValorBCIcmsSt(Double.valueOf(livro.getValorBCIcmsSt() + livroSource.getValorBCIcmsSt()));
            livro.setValorIcms(ToolFormatter.arrredondarNumero((Double)(livro.getValorIcms() + livroSource.getValorIcms()), (int)2));
            livro.setValorIcmsIsento(Double.valueOf(livro.getValorIcmsIsento() + livroSource.getValorIcmsIsento()));
            livro.setValorIcmsOutros(Double.valueOf(livro.getValorIcmsOutros() + livroSource.getValorIcmsOutros()));
            livro.setValorIcmsSt(Double.valueOf(livro.getValorIcmsSt() + livroSource.getValorIcmsSt()));
            livro.setValorIcmsTributado(Double.valueOf(livro.getValorIcmsTributado() + livroSource.getValorIcmsTributado()));
            livro.setValorIcmsSemAprov(Double.valueOf(livro.getValorIcmsSemAprov() + livroSource.getValorIcmsSemAprov()));
            livro.setValorInss(Double.valueOf(livro.getValorInss() + livroSource.getValorInss()));
            livro.setValorIpiIndustria(Double.valueOf(livro.getValorIpiIndustria() + livroSource.getValorIpiIndustria()));
            livro.setValorIpiIsento(Double.valueOf(livro.getValorIpiIsento() + livroSource.getValorIpiIsento()));
            livro.setValorIpiOutros(Double.valueOf(livro.getValorIpiOutros() + livroSource.getValorIpiOutros()));
            livro.setValorIpiTributado(Double.valueOf(livro.getValorIpiTributado() + livroSource.getValorIpiTributado()));
            livro.setValorIpiComercio(Double.valueOf(livro.getValorIpiComercio() + livroSource.getValorIpiComercio()));
            livro.setValorIpiObservacao(Double.valueOf(livro.getValorIpiObservacao() + livroSource.getValorIpiObservacao()));
            livro.setValorIrrf(Double.valueOf(livro.getValorIrrf() + livroSource.getValorIrrf()));
            livro.setValorIss(Double.valueOf(livro.getValorIss() + livroSource.getValorIss()));
            livro.setValorLei10833(Double.valueOf(livro.getValorLei10833() + livroSource.getValorLei10833()));
            livro.setValorFunrural(Double.valueOf(livro.getValorFunrural() + livroSource.getValorFunrural()));
            livro.setValorOutros(Double.valueOf(livro.getValorOutros() + livroSource.getValorOutros()));
            livro.setValorTotal(ToolFormatter.arrredondarNumero((Double)(livro.getValorTotal() + livroSource.getValorTotal()), (int)2));
            livro.setVrBCCofins(Double.valueOf(livro.getVrBCCofins() + livroSource.getVrBCCofins()));
            livro.setVrBCPis(Double.valueOf(livro.getVrBCPis() + livroSource.getVrBCPis()));
            livro.setValorDifAliquota(Double.valueOf(livro.getValorDifAliquota() + livroSource.getValorDifAliquota()));
            livro.setUfIcmsSt(livroSource.getUfIcmsSt());
            livro.setValorContSocial(Double.valueOf(livro.getValorContSocial() + livroSource.getValorContSocial()));
            livro.setValorCofins(Double.valueOf(livro.getValorCofins() + livroSource.getValorCofins()));
            livro.setValorPis(Double.valueOf(livro.getValorPis() + livroSource.getValorPis()));
            livro.setValorSestSenat(Double.valueOf(livro.getValorSestSenat() + livroSource.getValorSestSenat()));
            livro.setVrNaoTribIcms(Double.valueOf(livro.getVrNaoTribIcms() + livroSource.getVrNaoTribIcms()));
            livro.setValorIcmsDesonerado(Double.valueOf(livro.getValorIcmsDesonerado() + livroSource.getValorIcmsDesonerado()));
            livro.setValorFCP(Double.valueOf(livro.getValorFCP() + livroSource.getValorFCP()));
            livro.setAliquotaFCP(livroSource.getAliquotaFCP());
            livro.setValorFCPSt(Double.valueOf(livro.getValorFCPSt() + livroSource.getValorFCPSt()));
            livro.setAliquotaFCPSt(livroSource.getAliquotaFCPSt());
            livro.setValorFCPStRetido(Double.valueOf(livro.getValorFCPStRetido() + livroSource.getValorFCPStRetido()));
            livro.setAliquotaFCPStRetido(livroSource.getAliquotaFCPStRetido());
            livro.setValorIpiDevolucao(Double.valueOf(livro.getValorIpiDevolucao() + livroSource.getValorIpiDevolucao()));
            livro.setEmpresa(livroSource.getEmpresa());
            livro.setUf(livroSource.getUf());
            livro.setCidade(livroSource.getCidade());
            livro.setEntradaSaidaNaturezaOp(livroSource.getEntradaSaidaNaturezaOp());
            livro.setDescartarDapi(livroSource.getDescartarDapi());
            livro.setCancelado(livroSource.getCancelado());
            livro.setVrBCCustoICMSST(Double.valueOf(livro.getVrBCCustoICMSST() + livroSource.getVrBCCustoICMSST()));
            livro.setVrCustoICMSST(Double.valueOf(livro.getVrCustoICMSST() + livroSource.getVrCustoICMSST()));
            this.updateLivros(livros, livrosFiscalOld);
            new SCAjustesObrigacoesLivroFiscal().gerarAjustesIcmsDocFiscal(livro, livroSource.getModeloFiscal(), livroSource.getProduto(), livroSource.getMapParamsAjuste());
        }
        return livros;
    }

    private void updateLivros(List<LivroFiscal> livros, List<LivroFiscal> livrosFiscalOld) {
        if (ToolMethods.isNotNull(livrosFiscalOld).booleanValue() && !livrosFiscalOld.isEmpty()) {
            for (LivroFiscal newLivro : livros) {
                int index = livrosFiscalOld.indexOf(newLivro);
                if (index <= 1) continue;
                LivroFiscal lvOld = livrosFiscalOld.get(index);
                newLivro.setIdentificador(lvOld.getIdentificador());
                newLivro.setObsLivroFiscal(lvOld.getObsLivroFiscal());
                if (newLivro.getObsLivroFiscal() == null) continue;
                for (Object oc : newLivro.getObsLivroFiscal()) {
                    ObservacaoLivroFiscal os = (ObservacaoLivroFiscal)oc;
                    os.setLivroFiscal(newLivro);
                }
            }
        }
    }
}

