/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.livrofiscal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.recepcaomercadorias.EnumConstTipoNotaFiscalRecepcao;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNotaPropria;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNotaTerceiros;
import com.touchcomp.basementorservice.dao.impl.DaoLivroFiscalImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceLivroFiscalImpl
extends ServiceGenericEntityImpl<LivroFiscal, Long, DaoLivroFiscalImpl> {
    @Autowired
    private CompLivroFiscalNotaPropria compLivroFiscalNotaPropria;
    @Autowired
    private CompLivroFiscalNotaTerceiros compLivroFiscalNotaTerceiros;
    @Autowired
    private ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropria;
    @Autowired
    private ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceiros;

    @Autowired
    public ServiceLivroFiscalImpl(DaoLivroFiscalImpl dao) {
        super(dao);
    }

    @Async
    public CompletableFuture<EnumConstantsMentorStatus> regerarLivrosFiscais(Date dataIn, Date dataFim, Short tipoNota, Short informarNumeracaoNotas, Integer numeroInicial, Integer numeroFinal) throws ExceptionAvaliadorExpressoes {
        block3: {
            block2: {
                if (!tipoNota.equals(EnumConstTipoNotaFiscalRecepcao.NOTA_PROPRIA.getValue())) break block2;
                List<NotaFiscalPropria> notasProprias = this.serviceNotaFiscalPropria.findNotasPeriodoAndNumeroNota(dataIn, dataFim, informarNumeracaoNotas, numeroInicial, numeroFinal);
                for (NotaFiscalPropria n : notasProprias) {
                    this.compLivroFiscalNotaPropria.regerarLivrosFiscaisNotasProprias(n);
                    this.saveOrUpdate(n.getLivrosFiscais());
                }
                break block3;
            }
            if (!tipoNota.equals(EnumConstTipoNotaFiscalRecepcao.NOTA_TERCEIROS.getValue())) break block3;
            List<NotaFiscalTerceiros> notasTerceiros = this.serviceNotaFiscalTerceiros.findNotasPeriodoAndNumeroNota(dataIn, dataFim, informarNumeracaoNotas, numeroInicial, numeroFinal);
            for (NotaFiscalTerceiros n : notasTerceiros) {
                n = this.compLivroFiscalNotaTerceiros.regerarLivrosFiscaisNotasTerceiros(n);
                this.saveOrUpdate(n.getLivrosFiscais());
            }
        }
        return CompletableFuture.completedFuture(EnumConstantsMentorStatus.SUCESSO);
    }
}

