/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.livrofiscal.adapters;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.service.impl.livrofiscal.LivroFiscalSource;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LivroFiscalSourceNFTerceiros
implements LivroFiscalSource {
    private final ItemNotaTerceiros item;

    public LivroFiscalSourceNFTerceiros(ItemNotaTerceiros item) {
        this.item = item;
    }

    @Override
    public Cfop getCfop() {
        return this.item.getItemNotaLivroFiscal().getCfop();
    }

    @Override
    public PlanoConta getPlanoConta() {
        return this.item.getPlanoContaDeb();
    }

    @Override
    public IncidenciaIcms getIncidenciaIcms() {
        return this.item.getIncidenciaIcms();
    }

    @Override
    public IncidenciaIpi getIncidenciaIpi() {
        return this.item.getIncidenciaIpi();
    }

    @Override
    public Double getAliquotaIcms() {
        return this.item.getItemNotaLivroFiscal().getAliquotaIcms();
    }

    @Override
    public Double getAliquotaIcmsProduto() {
        return this.item.getProduto().getAliquotaIcms();
    }

    @Override
    public Date getDataLivro() {
        return ToolMethods.isNotNull((Object)this.item.getNotaFiscalTerceiros()) != false ? this.item.getNotaFiscalTerceiros().getDataEntrada() : new Date();
    }

    @Override
    public IncidenciaPisCofins getIncidenciaPis() {
        return this.item.getIncidenciaPisCofins();
    }

    @Override
    public IncidenciaPisCofins getIncidenciaCofins() {
        return this.item.getIncidenciaPisCofins();
    }

    @Override
    public Double getAliquotaPis() {
        return this.item.getItemNotaLivroFiscal().getAliquotaPis();
    }

    @Override
    public Double getAliquotaCofins() {
        return this.item.getItemNotaLivroFiscal().getAliquotaCofins();
    }

    @Override
    public Double getAliquotaPisQtde() {
        return this.item.getItemNotaLivroFiscal().getAliquotaPisQtde();
    }

    @Override
    public Double getAliquotaCofinsQtde() {
        return this.item.getItemNotaLivroFiscal().getAliquotaCofinsQtde();
    }

    @Override
    public Double getValorFreteIcmsST() {
        return this.item.getItemNotaLivroFiscal().getFreteIcmsST();
    }

    @Override
    public Double getValorBCIcmsSt() {
        return this.item.getItemNotaLivroFiscal().getVrBcCalculoIcmsSt();
    }

    @Override
    public Double getValorIcms() {
        return this.item.getItemNotaLivroFiscal().getVrIcms();
    }

    @Override
    public Double getValorIcmsIsento() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsIsento();
    }

    @Override
    public Double getValorIcmsOutros() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsOutros();
    }

    @Override
    public Double getValorIcmsSt() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsSt();
    }

    @Override
    public Double getValorIcmsTributado() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsTributado();
    }

    @Override
    public Double getValorIcmsSemAprov() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsSemAprov();
    }

    @Override
    public Double getValorInss() {
        return this.item.getItemNotaLivroFiscal().getVrInss();
    }

    @Override
    public Double getValorIpiIndustria() {
        return this.item.getItemNotaLivroFiscal().getVrIpiIndustria();
    }

    @Override
    public Double getValorIpiIsento() {
        return this.item.getItemNotaLivroFiscal().getVrIpiIsento();
    }

    @Override
    public Double getValorIpiOutros() {
        return this.item.getItemNotaLivroFiscal().getVrIpiOutros();
    }

    @Override
    public Double getValorIpiTributado() {
        return this.item.getItemNotaLivroFiscal().getVrIpiTributado();
    }

    @Override
    public Double getValorIpiObservacao() {
        return this.item.getItemNotaLivroFiscal().getVrIpiComercio();
    }

    @Override
    public Double getValorIpiComercio() {
        return this.item.getItemNotaLivroFiscal().getVrIpiObservacao();
    }

    @Override
    public Double getValorIrrf() {
        return this.item.getItemNotaLivroFiscal().getVrIrrf();
    }

    @Override
    public Double getValorIss() {
        return this.item.getItemNotaLivroFiscal().getVrIss();
    }

    @Override
    public Double getValorLei10833() {
        return this.item.getItemNotaLivroFiscal().getVrLei10833();
    }

    @Override
    public Double getValorFunrural() {
        return this.item.getItemNotaLivroFiscal().getVrFunrural();
    }

    @Override
    public Double getValorOutros() {
        return this.item.getItemNotaLivroFiscal().getVrOutros();
    }

    @Override
    public Double getValorTotal() {
        return this.item.getItemNotaLivroFiscal().getValorTotal();
    }

    @Override
    public Double getVrBCCofins() {
        return this.item.getItemNotaLivroFiscal().getVrBCCofins();
    }

    @Override
    public Double getVrBCPis() {
        return this.item.getItemNotaLivroFiscal().getVrBCPis();
    }

    @Override
    public Double getValorDifAliquota() {
        return this.item.getItemNotaLivroFiscal().getVrDifAliquota();
    }

    @Override
    public UnidadeFederativa getUfIcmsSt() {
        return this.item.getItemNotaLivroFiscal().getUfIcmsSt();
    }

    @Override
    public Double getValorContSocial() {
        return this.item.getItemNotaLivroFiscal().getVrContSoc();
    }

    @Override
    public Double getValorCofins() {
        return this.item.getItemNotaLivroFiscal().getVrCofins();
    }

    @Override
    public Double getValorPis() {
        return this.item.getItemNotaLivroFiscal().getVrPis();
    }

    @Override
    public Double getValorSestSenat() {
        return this.item.getItemNotaLivroFiscal().getValorSestSenat();
    }

    @Override
    public Double getVrNaoTribIcms() {
        return this.item.getItemNotaLivroFiscal().getVrNaoTribICMS();
    }

    @Override
    public Double getValorIcmsDesonerado() {
        return this.item.getItemNotaLivroFiscal().getVrIcmsDesonerado();
    }

    @Override
    public Double getValorFCP() {
        return this.item.getItemNotaLivroFiscal().getValorFCP();
    }

    @Override
    public Double getAliquotaFCP() {
        return this.item.getItemNotaLivroFiscal().getAliquotaFCP();
    }

    @Override
    public Double getValorFCPSt() {
        return this.item.getItemNotaLivroFiscal().getValorFCPSt();
    }

    @Override
    public Double getAliquotaFCPSt() {
        return this.item.getItemNotaLivroFiscal().getAliquotaFCPSt();
    }

    @Override
    public Double getValorFCPStRetido() {
        return this.item.getItemNotaLivroFiscal().getValorFCPStRetido();
    }

    @Override
    public Double getAliquotaFCPStRetido() {
        return this.item.getItemNotaLivroFiscal().getAliquotaFCPStRetido();
    }

    @Override
    public Double getValorIpiDevolucao() {
        return this.item.getItemNotaLivroFiscal().getValorIpiDevolucao();
    }

    @Override
    public Empresa getEmpresa() {
        return this.item.getItemNotaLivroFiscal().getItemNotaTerceiros().getNotaFiscalTerceiros().getEmpresa();
    }

    @Override
    public UnidadeFederativa getUf() {
        return ToolMethods.isNotNull((Object)this.item.getNotaFiscalTerceiros().getUfPrestacao()) != false ? this.item.getNotaFiscalTerceiros().getUfPrestacao() : this.item.getNotaFiscalTerceiros().getUnidadeFatFornecedor().getPessoa().getEndereco().getCidade().getUf();
    }

    @Override
    public Cidade getCidade() {
        return ToolMethods.isNotNull((Object)this.item.getNotaFiscalTerceiros().getCidadePrestacao()) != false ? this.item.getNotaFiscalTerceiros().getCidadePrestacao() : this.item.getNotaFiscalTerceiros().getUnidadeFatFornecedor().getFornecedor().getPessoa().getEndereco().getCidade();
    }

    @Override
    public Short getEntradaSaidaNaturezaOp() {
        return ToolMethods.isNotNull((Object)this.item.getNaturezaOperacao()) != false ? this.item.getNaturezaOperacao().getEntradaSaida().shortValue() : EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Override
    public Short getDescartarDapi() {
        return ToolMethods.isNotNull((Object)this.item.getModeloFiscal()) != false ? this.item.getModeloFiscal().getDescartarDapi().shortValue() : EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Override
    public Short getCancelado() {
        if (ToolMethods.isNotNull((Object)this.item.getNotaFiscalTerceiros().getSituacaoDocumento()).booleanValue() && ToolMethods.isEquals((Object)this.item.getNotaFiscalTerceiros().getSituacaoDocumento().getCodigo(), (Object)EnumConstSituacaoDocumento.CANCELADO.getValue())) {
            return EnumConstantsMentorSimNao.SIM.getValue();
        }
        return EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Override
    public Double getVrBCCustoICMSST() {
        return this.item.getItemNotaLivroFiscal().getVrBCCustoICMSST();
    }

    @Override
    public Double getVrCustoICMSST() {
        return this.item.getItemNotaLivroFiscal().getVrCustoICMSST();
    }

    @Override
    public ModeloFiscal getModeloFiscal() {
        return this.item.getModeloFiscal();
    }

    @Override
    public Produto getProduto() {
        return this.item.getProduto();
    }

    @Override
    public Map<String, Object> getMapParamsAjuste() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(ItemNotaTerceiros.class.getCanonicalName(), this.item);
        values.put(NotaFiscalTerceiros.class.getCanonicalName(), this.item.getNotaFiscalTerceiros());
        values.put(ItemNotaLivroFiscal.class.getCanonicalName(), this.item.getItemNotaLivroFiscal());
        values.put(Produto.class.getCanonicalName(), this.item.getProduto());
        return values;
    }
}

