/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.logatualizacaoversaocli;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstAtualizacaoStatus;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.InformacoesTecnicasCliente;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCli;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCliQuery;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.TipoBDVersao;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.dao.impl.DaoLogAtualizacaoVersaoCliImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.clientefinanccontsistemas.ServiceClienteFinancContSistemasImpl;
import com.touchcomp.basementorservice.service.impl.servidorcliente.ServiceServidorClienteImpl;
import com.touchcomp.basementorservice.service.impl.tipobdversao.ServiceTipoBDVersaoImpl;
import com.touchcomp.basementorservice.service.impl.versaomentor.ServiceVersaoMentorImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.informacoestecnicascliente.atualizador.DTOInfAtualizacaoRealizada;
import com.touchcomp.touchvomodel.vo.informacoestecnicascliente.atualizador.VOQuerySQL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLogAtualizacaoVersaoCliImpl
extends ServiceGenericEntityImpl<LogAtualizacaoVersaoCli, Long, DaoLogAtualizacaoVersaoCliImpl> {
    @Autowired
    private ServiceClienteFinancContSistemasImpl serviceClienteFin;
    @Autowired
    private ServiceTipoBDVersaoImpl serviceTipoBDVersao;
    @Autowired
    private ServiceVersaoMentorImpl serviceVersaoMentor;
    @Autowired
    private ServiceServidorClienteImpl serviceServidorClienteImpl;

    @Autowired
    public ServiceLogAtualizacaoVersaoCliImpl(DaoLogAtualizacaoVersaoCliImpl genericDao) {
        super(genericDao);
    }

    public void inserirLogAtualizacaoSistema(Long idServidor, Long codigoVersao, Short codigoSistema, Short versaoBetaBloqueada) {
        TipoBDVersao tp = this.serviceTipoBDVersao.getTipoBD(codigoSistema);
        VersaoMentor versao = this.serviceVersaoMentor.getByCodigo(codigoVersao);
        ServidorCliente serv = (ServidorCliente)this.serviceServidorClienteImpl.get(idServidor);
        LogAtualizacaoVersaoCli log = ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getLog(serv, versao, tp);
        if (log == null) {
            log = new LogAtualizacaoVersaoCli();
            log.setCodigoVersao(codigoVersao);
            log.setTipoBDVersao(tp);
            log.setVersaoMentor(versao);
            log.setServidorCliente(serv);
            log.setVersaoBetaBloqueada(versaoBetaBloqueada);
            log.setDataAtualizacao(new Date());
        }
        this.saveOrUpdate(log);
    }

    public void inserirLogAtualizacaoSistema(String codigoCliente, Long codigoVersao, Short codigoSistema, Short versaoBetaBloqueada) {
        TipoBDVersao tp = this.serviceTipoBDVersao.getTipoBD(codigoSistema);
        VersaoMentor versao = this.serviceVersaoMentor.getByCodigo(codigoVersao);
        List<ServidorCliente> servidores = this.serviceServidorClienteImpl.getByCodigoCliente(codigoCliente);
        for (ServidorCliente serv : servidores) {
            LogAtualizacaoVersaoCli log = ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getLog(serv, versao, tp);
            if (log != null) continue;
            log = new LogAtualizacaoVersaoCli();
            log.setCodigoVersao(codigoVersao);
            log.setTipoBDVersao(tp);
            log.setVersaoMentor(versao);
            log.setServidorCliente(serv);
            log.setVersaoBetaBloqueada(versaoBetaBloqueada);
            this.saveOrUpdate(log);
        }
    }

    public LogAtualizacaoVersaoCli findUltimoLogAtualizacaoByIdCliente(Long idCliente) {
        return ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).findUltimoLogAtualizacaoByIdCliente(idCliente);
    }

    public void inserirLogAtualizacaoSistema(DTOInfAtualizacaoRealizada info) throws ExceptionIO, ExceptionInvalidData {
        TipoBDVersao tp = this.serviceTipoBDVersao.getTipoBD(info.getCodigoSistema());
        VersaoMentor versao = this.serviceVersaoMentor.getByCodigo(info.getCodigoVersao());
        ServidorCliente serv = (ServidorCliente)this.serviceServidorClienteImpl.get(info.getIdServidor());
        Object[] macsServer = ToolString.splitString((String)serv.getMacAddress(), (char[])new char[]{'-', ':'});
        String[] macsInfo = ToolString.splitString((String)info.getMacAddress(), (char[])new char[]{'-', ':'});
        boolean isServidorAt = false;
        for (String mac : macsInfo) {
            if (!ToolMethods.containsInArray((Object[])macsServer, (Object)mac)) continue;
            isServidorAt = true;
            break;
        }
        if (!isServidorAt) {
            throw new ExceptionInvalidData("E.ERP.1931.002", new Object[]{info.getMacAddress(), serv.getIdentificador(), serv.getDescricao(), serv.getInformacoesTecnicaCliente().getClienteContSistemas().getTomadorPrestadorRps().getPessoa()});
        }
        LogAtualizacaoVersaoCli log = ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getLog(serv, versao, tp);
        if (log == null) {
            log = new LogAtualizacaoVersaoCli();
            log.setCodigoVersao(info.getCodigoVersao());
            log.setTipoBDVersao(tp);
            log.setVersaoMentor(versao);
            log.setServidorCliente(serv);
            log.setMaturidade(info.getMaturidade());
            log.setVersaoBetaBloqueada(info.getVersaoBetaBloqueada());
            log.setTipoRevisao(Integer.valueOf(EnumConstAtualizacaoStatus.ATUALIZACAO_OK.getValue()));
            log.setDataAtualizacao(new Date());
        }
        if (log.getDataAtualizacao() == null) {
            log.setDataAtualizacao(new Date());
        }
        if (TMethods.isStrWithData((String)info.getQueries())) {
            List queries = ToolJson.readJsonList((String)info.getQueries(), VOQuerySQL.class);
            List aux = log.getQueries();
            aux.clear();
            for (VOQuerySQL query : queries) {
                LogAtualizacaoVersaoCliQuery l = new LogAtualizacaoVersaoCliQuery();
                l.setLogAtualizacao(log);
                l.setQuery(TString.cut((String)query.getQuery(), (int)10000));
                l.setMensagemqueryProblema(TString.cut((String)query.getQueryErrorMessage(), (int)10000));
                l.setStatus(query.getStatus());
                if (query.getQueryType() != null) {
                    l.setQueryType(Short.valueOf(query.getQueryType().shortValue()));
                }
                aux.add(l);
            }
            if (ToolMethods.isWithData((Collection)aux) && !ToolMethods.isEquals((Object)EnumConstAtualizacaoStatus.ATUALIZACAO_REVISADA.getValue(), (Object)log.getTipoRevisao())) {
                log.setTipoRevisao(Integer.valueOf(EnumConstAtualizacaoStatus.ATUALIZACAO_AGUARDA_REVISAO.getValue()));
            }
        }
        if (!(!TMethods.isStrWithData((String)info.getSgbdVersion()) || info.getSgbd() == null || TMethods.isEquals((Object)serv.getSgbd(), (Object)info.getSgbd()) && TMethods.isEqualsIgnoreCase((String)serv.getSgbdVersion(), (String)info.getSgbdVersion()))) {
            serv.setSgbd(info.getSgbd());
            serv.setSgbdVersion(info.getSgbdVersion());
            serv = this.serviceServidorClienteImpl.saveOrUpdate(serv);
            log.setServidorCliente(serv);
        }
        this.saveOrUpdate(log);
    }

    public List<LogAtualizacaoVersaoCli> getLogsAguardandoRevisao() {
        return ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getLogsAguardandoRevisao();
    }

    public List<LogAtualizacaoVersaoCli> getLogs(InformacoesTecnicasCliente inf) {
        return ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getLogs(inf);
    }

    public LogAtualizacaoVersaoCli getUltimaAtualizacao(ClienteContSistemas cliente) {
        return ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getUltimaAtualizacao(cliente);
    }

    public LogAtualizacaoVersaoCli getUltimaAtualizacao(UsuarioBasico usuarioCliente) {
        if (this.isNotNull(usuarioCliente).booleanValue()) {
            return ((DaoLogAtualizacaoVersaoCliImpl)this.getDao()).getUltimaAtualizacao(usuarioCliente);
        }
        return null;
    }
}

