/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.logerror;

import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogacoes.model.LogError;
import com.touchcomp.basementorlogacoes.service.impl.logerror.ServiceLogErrosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.nodo.ServiceNodoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.textfile.writter.ToolTextFileWritter;
import com.touchcomp.touchvomodel.vo.logacoesusuario.web.DTOLogErros;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLogErrosSistemaImpl
extends ServiceGenericImpl {
    @Autowired
    private ServiceLogErrosImpl serviceLogErros;
    @Autowired
    private ServiceNodoImpl serviceNodo;

    public List<DTOLogErros> findLogErros(Long dataInicial, Long dataFinal, Short filtrarUsuario, Long idUsuario, Short filtrarRecurso, Long idRecurso) throws ExceptionInvalidData {
        Date dataF;
        Date dataI;
        if (TMethods.isNull((Object)dataInicial).booleanValue() || dataInicial == 0L || TMethods.isNull((Object)dataFinal).booleanValue() || dataFinal == 0L) {
            dataI = ToolDate.dataPrimHora((Date)new Date());
            dataF = ToolDate.dataUltHora((Date)new Date());
        } else {
            dataI = ToolDate.dataPrimHora((Date)new Date(dataInicial));
            dataF = ToolDate.dataUltHora((Date)new Date(dataFinal));
        }
        if (TMethods.isAffirmative((Number)filtrarUsuario) && TMethods.isNull((Object)idUsuario).booleanValue()) {
            throw new ExceptionInvalidData("\u00c9 obrigat\u00f3rio informar um usu\u00e1rio para o filtro", new Object[0]);
        }
        if (TMethods.isAffirmative((Number)filtrarRecurso) && TMethods.isNull((Object)idRecurso).booleanValue()) {
            throw new ExceptionInvalidData("\u00c9 obrigat\u00f3rio informar um recurso para o filtro", new Object[0]);
        }
        LinkedList<DTOLogErros> result = new LinkedList<DTOLogErros>();
        List logs = this.serviceLogErros.getLogs(dataI, dataF, TMethods.isAffirmative((Number)filtrarUsuario), idUsuario, TMethods.isAffirmative((Number)filtrarRecurso), idRecurso);
        if (TMethods.isWithData((Collection)logs)) {
            for (LogError l : logs) {
                DTOLogErros dto = this.buildDTOLog(l);
                result.add(dto);
            }
        }
        return result;
    }

    public void deleteLogAnterioresA10dias() {
        this.serviceLogErros.deleteLogBeforeThan(ToolDate.previousDays((Date)new Date(), (int)10));
    }

    public DTOLogErros buildDTOLog(LogError l) {
        Nodo nodo;
        DTOLogErros dto = new DTOLogErros();
        dto.setCodigo(l.getCodigo());
        dto.setDataEvento(l.getDataEvento());
        dto.setIdUsuario(l.getIdUsuario());
        dto.setIdentificador(l.getIdentificador());
        dto.setMessage(l.getMessage());
        dto.setNomeUsuario(l.getNomeUsuario());
        dto.setRecurso(l.getRecurso());
        if (TMethods.isNotNull((Object)l.getRecurso()).booleanValue() && TMethods.isNotNull((Object)(nodo = (Nodo)this.serviceNodo.get(l.getRecurso()))).booleanValue()) {
            dto.setNomeRecurso(nodo.getDescricao());
        }
        dto.setStackTrace(l.getStackTrace());
        dto.setUid(l.getUid());
        return dto;
    }

    public File gerarArquivoLogErro(Long identificador) throws ExceptionInvalidData, ExceptionIO, IOException {
        LogError log = (LogError)this.serviceLogErros.get((Serializable)identificador);
        if (TMethods.isNull((Object)log).booleanValue()) {
            throw new ExceptionInvalidData("Nenhum log encontrado com o identificador informado!", new Object[0]);
        }
        File file = ToolFile.createTempFile((String)("log_" + ToolDate.dateToStr((Date)log.getDataEvento(), (String)"dd_MM_yyyy_HH_mm_ss") + ".txt"));
        ToolTextFileWritter tool = new ToolTextFileWritter();
        tool.setRegisterSeparator("");
        tool.newLine().newReg("Identificador: " + String.valueOf(log.getIdentificador()));
        tool.newLine().newReg("UID: " + log.getUid());
        tool.newLine().newReg("Data/Hora: " + ToolDate.dateToStr((Date)log.getDataEvento(), (String)"dd/MM/yyyy hh:mm:ss"));
        tool.newLine().newReg("Recurso: " + String.valueOf(log.getRecurso()));
        tool.newLine().newReg("Usu\u00e1rio: " + String.valueOf(log.getIdUsuario()) + " - " + log.getNomeUsuario());
        tool.newLine().newReg("Descri\u00e7\u00e3o: " + log.getMessage());
        tool.newLine().newReg("StackTrace: " + log.getStackTrace());
        tool.writeOnOutputStream(file);
        return file;
    }
}

