/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.logusuario;

import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorlogacoes.model.LogAcoesUsuario;
import com.touchcomp.basementorlogacoes.service.impl.logusuario.ServiceLogAcoesUsuarioImpl;
import com.touchcomp.basementorservice.dao.impl.DaoLogUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.touchvomodel.vo.logacoesusuario.web.DTOLogAcoesUsuario;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLogUsuarioImpl {
    @Autowired
    ServiceLogAcoesUsuarioImpl serviceLogAcoes;
    @Autowired
    ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    DaoLogUsuarioImpl daoLogUsuario;

    public Object getEntity(String entidade, Serializable idObject) {
        return this.daoLogUsuario.getEntity(entidade, idObject);
    }

    public List<DTOLogAcoesUsuario> getLogs(boolean filtrarData, Date dataInicial, Date dataFinal, boolean filtrarUsuario, Long idUsuario, boolean filtrarRegistro, Long idRegistro, String path) throws ExceptionZip, ExceptionIO {
        List logs = this.serviceLogAcoes.getLogs(filtrarData, dataInicial, dataFinal, filtrarUsuario, idUsuario, filtrarRegistro, idRegistro, path);
        LinkedList<DTOLogAcoesUsuario> ret = new LinkedList<DTOLogAcoesUsuario>();
        HashMap<Long, Usuario> cache = new HashMap<Long, Usuario>();
        for (LogAcoesUsuario log : logs) {
            DTOLogAcoesUsuario d = new DTOLogAcoesUsuario();
            d.setDataLog(log.getDataLog());
            d.setDescricao(log.getDescricao());
            d.setIdEntidade(log.getIdEntidade());
            d.setIdUsuario(log.getIdUsuario());
            d.setIdentificador(log.getIdentificador());
            d.setPathClass(log.getPathClass());
            d.setTipoOperacaoLog(log.getTipoOperacaoLog());
            ret.add(d);
            Usuario u = (Usuario)cache.get(idUsuario);
            if (u == null) {
                u = (Usuario)this.serviceUsuarioImpl.get(idUsuario);
                cache.put(idUsuario, u);
            }
            if (u != null) {
                d.setNomeUsuario(u.getUsuarioBasico().getPessoa().getNome());
                d.setNomeFantasiaUsuario(u.getUsuarioBasico().getPessoa().getNomeFantasia());
            }
            if (log.getDetalhes() == null) continue;
            String json = log.getDetalhes();
            List data = ToolJson.readJsonList((String)json, DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet.class);
            d.setDetalhes(data);
        }
        return ret;
    }
}

