/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lotecontabil;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabil;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoCTBCentroCustos;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoLoteContabilImpl;
import com.touchcomp.basementorservice.helpers.impl.lancamento.HelperLancamento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.bloqueiolancamentocontabil.ServiceBloqueioLancamentoContabilImpl;
import com.touchcomp.basementorservice.service.impl.encerramentocontabil.ServiceEncerramentoContabilImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceLoteContabil;
import com.touchcomp.touchvomodel.vo.lotecontabil.web.DTOLoteContabil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLoteContabilImpl
extends ServiceGenericEntityImpl<LoteContabil, Long, DaoLoteContabilImpl>
implements ServiceLoteContabil {
    @Autowired
    private ServiceEncerramentoContabilImpl serviceEncerramentoContabil;
    @Autowired
    private ServiceBloqueioLancamentoContabilImpl serviceBloqueioLancamentoContabil;

    @Autowired
    public ServiceLoteContabilImpl(DaoLoteContabilImpl genericDao) {
        super(genericDao);
    }

    @Override
    public LoteContabil beforeSave(LoteContabil vo) {
        List<BloqueioLancamentoContabil> bloqueios;
        Date maiorData = null;
        if (vo != null && vo.getLancamentos() != null) {
            for (Lancamento l : vo.getLancamentos()) {
                if (this.isNull(maiorData).booleanValue() || l.getDataLancamento().after(maiorData)) {
                    maiorData = l.getDataLancamento();
                }
                l.setLoteContabil(vo);
                if (l.getLancamentosCtbCentroCustos() == null) continue;
                for (LancamentoCTBCentroCustos lcc : l.getLancamentosCtbCentroCustos()) {
                    lcc.setLancamentoContabil(l);
                }
            }
        }
        if (this.isNotNull(maiorData).booleanValue()) {
            vo.setDataLote(maiorData);
        }
        if (ServiceLoteContabilImpl.isWithData(bloqueios = this.serviceBloqueioLancamentoContabil.verificarBloqueioLancamento(vo.getDataLote(), vo.getGrupoEmpresa()))) {
            throw new ExceptionRuntimeBase("E.ERP.0379.002");
        }
        return vo;
    }

    @Override
    public List<LoteContabil> getLotesInconsistentes(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoLoteContabilImpl)this.getGenericDao()).getLotesInconsistentes(dataInicial, dataFinal, grupoEmpresa);
    }

    @Override
    public LoteContabil getLoteByNumero(Long numeroLote, GrupoEmpresa grupoEmpresa) {
        return ((DaoLoteContabilImpl)this.getGenericDao()).getLoteByNumero(numeroLote, grupoEmpresa);
    }

    @Override
    public List<LoteContabil> getLotesByIntervaloNumero(Long numeroLoteInicial, Long numeroLoteFinal) {
        return ((DaoLoteContabilImpl)this.getGenericDao()).getLotesByIntervaloNumero(numeroLoteInicial, numeroLoteFinal);
    }

    @Override
    public List<LoteContabil> getLotesByIntervaloDatas(Date dataInicial, Date dataFinal) {
        return ((DaoLoteContabilImpl)this.getGenericDao()).getLotesByIntervaloDatas(dataInicial, dataFinal);
    }

    @Override
    public void deleteLoteQuery(LoteContabil lote) {
        ((DaoLoteContabilImpl)this.getGenericDao()).deleteLoteQuery(lote);
    }

    public Boolean habilitarEdicaoLoteContabil(Long id, Empresa empresa) throws ExceptionObjNotFound, ExceptionInvalidData {
        EncerramentoContabil aux;
        LoteContabil lote = (LoteContabil)this.getOrThrow(id);
        if (lote.getDataLote() != null && this.isNotNull(aux = this.serviceEncerramentoContabil.getVerificarExisteEncerramentoContabilNaDataEmpresaBloquearPeriodo(lote.getDataLote(), empresa, EnumConstantsMentorSimNao.SIM.getValue())).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.0379.001", new Object[0]);
        }
        List<BloqueioLancamentoContabil> bloqueios = this.serviceBloqueioLancamentoContabil.verificarBloqueioLancamento(lote.getDataLote(), lote.getGrupoEmpresa());
        if (ServiceLoteContabilImpl.isWithData(bloqueios)) {
            throw new ExceptionInvalidData("E.ERP.0379.002", new Object[0]);
        }
        return true;
    }

    public DTOLoteContabil.DTOLancamento adicionarLancamentoLote(DTOLoteContabil dtoLote, Empresa empresa) {
        Collections.sort(dtoLote.getLancamentos(), (l1, l2) -> l1.getDataCadastro().compareTo(l2.getDataCadastro()));
        LoteContabil lote = (LoteContabil)this.buildToEntity(dtoLote);
        Lancamento novoLancamento = !ServiceLoteContabilImpl.isWithData(lote.getLancamentos()) ? new HelperLancamento(null).buildLancamento(empresa, null, EnumConstantsMentorSimNao.NAO) : new HelperLancamento(null).buildLancamento(empresa, (Lancamento)lote.getLancamentos().getLast(), EnumConstantsMentorSimNao.NAO);
        return this.buildToDTOGeneric(novoLancamento, DTOLoteContabil.DTOLancamento.class);
    }
}

