/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.lotefabricacao;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AjusteEstoque;
import com.touchcomp.basementor.model.vo.FichaTecnicaAvaliador;
import com.touchcomp.basementor.model.vo.FichaTecnicaLoteFabricacao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ValoresFichaLoteFab;
import com.touchcomp.basementorservice.dao.impl.DaoLoteFabricacaoImpl;
import com.touchcomp.basementorservice.helpers.impl.lotefabricacao.HelperLoteFabricacao;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceLoteFabricacao;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTOLoteFabricacaoRes;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLoteFabricacaoImpl
extends ServiceGenericEntityImpl<LoteFabricacao, Long, DaoLoteFabricacaoImpl>
implements ServiceLoteFabricacao {
    HelperLoteFabricacao helperLoteFabricacao;

    @Autowired
    public ServiceLoteFabricacaoImpl(DaoLoteFabricacaoImpl genericDao, HelperLoteFabricacao helperLoteFabricacao) {
        super(genericDao);
        this.helperLoteFabricacao = helperLoteFabricacao;
    }

    @Override
    public LoteFabricacao findOrCreateLoteUnico(GradeCor gradeCor) {
        LoteFabricacao lote = ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteUnico(gradeCor);
        if (lote == null) {
            lote = this.helperLoteFabricacao.getLoteUnico(gradeCor);
            lote = this.saveOrUpdate(lote);
        }
        return lote;
    }

    @Override
    public LoteFabricacao findLoteUnico(GradeCor gradeCor) {
        return ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteUnico(gradeCor);
    }

    @Override
    public LoteFabricacao findLoteUnico(Produto produto) {
        if (produto == null) {
            return null;
        }
        return this.findLoteUnico(produto.getIdentificador());
    }

    public LoteFabricacao findLoteUnico(Long idProduto) {
        return ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteUnico(idProduto);
    }

    public DTOLoteFabricacaoRes findLoteUnicoDTO(Long idProduto) {
        return this.buildToDTO(this.findLoteUnico(idProduto), DTOLoteFabricacaoRes.class);
    }

    @Override
    public LoteFabricacao findOrCreateLoteUnico(Produto produto) {
        if (produto == null) {
            return null;
        }
        LoteFabricacao lote = ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteUnico(produto.getIdentificador());
        if (lote == null) {
            lote = this.helperLoteFabricacao.getLoteUnico(produto);
            lote = this.saveOrUpdate(lote);
        }
        return lote;
    }

    public LoteFabricacao findOrCreateLote(Produto produto, String nrLoteFab) {
        return this.findOrCreateLote(produto, nrLoteFab, true);
    }

    public LoteFabricacao findOrCreateLote(Produto produto, String nrLoteFab, boolean save) {
        LoteFabricacao lote = this.findLoteFabricacao(produto, nrLoteFab);
        if (lote == null) {
            lote = this.helperLoteFabricacao.getLote(produto, nrLoteFab);
            if (save) {
                lote = this.saveOrUpdate(lote);
            }
        }
        return lote;
    }

    public LoteFabricacao findOrCreateLote(GradeCor gradeCor, String nrLoteFab) {
        return this.findOrCreateLote(gradeCor.getProdutoGrade().getProduto(), nrLoteFab);
    }

    public LoteFabricacao findLoteFabricacao(Produto produto, String nrLoteFab) {
        return ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteFabricacao(produto, nrLoteFab);
    }

    public List<LoteFabricacao> findLoteFabricacaoProduto(Produto produto) {
        if (produto == null) {
            return new ArrayList<LoteFabricacao>();
        }
        return ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteFabricacao(produto.getIdentificador());
    }

    public List<LoteFabricacao> findLoteFabricacaoProduto(Long produto) {
        return ((DaoLoteFabricacaoImpl)this.getGenericDao()).findLoteFabricacao(produto);
    }

    public void verificaAjusteEstoque(LoteFabricacao lote, OpcoesTicketFiscal opcoesTicketFiscal) throws Exception {
        if (opcoesTicketFiscal == null) {
            return;
        }
        TicketFiscalTerceiros ticket = null;
        List<Object> listTicket = new ArrayList();
        if (lote.getIdentificador() != null) {
            listTicket = ((DaoLoteFabricacaoImpl)this.getGenericDao()).findTicketFiscalTerceirosVinculado(lote);
        }
        if (!this.isEquals(opcoesTicketFiscal.getHabilitarMaisTicketNota(), (short)1) && !listTicket.isEmpty() && listTicket.size() > 1) {
            throw new Exception("H\u00e1 dois Tickets Fiscais de Entrada com o mesmo Lote de Fabrica\u00e7\u00e3o!\nSe desejar editar o Lote de Fabrica\u00e7\u00e3o, dever\u00e1 acessar o recurso 1820 - Op\u00e7\u00f5es de Ticket Fiscal\ne selecionar a op\u00e7\u00e3o 'Habilitar para vincular duas ou mais notas em um ticket (Ticket de Entrada)'");
        }
        if (!listTicket.isEmpty()) {
            ticket = (TicketFiscalTerceiros)listTicket.get(0);
        }
        if (!this.isEquals(ticket, null)) {
            for (FichaTecnicaLoteFabricacao f : lote.getFichaTecnica()) {
                if (f.getModeloFichaTecnica().getFichasTecnicasAvaliador().isEmpty()) continue;
                AjusteEstoque ajuste = f.getAjusteEstoque();
                if (f.getAjusteEstoque() == null) {
                    ajuste = new AjusteEstoque();
                }
                if (!this.isEquals(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getItemVlrBruto(), null)) {
                    ajuste.setQtdeBruto(this.pesquisarValorFichaTecnica(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getItemVlrBruto(), lote));
                }
                if (!this.isEquals(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getItemVlrLiquido(), null)) {
                    ajuste.setQtdeLiquida(this.pesquisarValorFichaTecnica(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getItemVlrLiquido(), lote));
                }
                if (!this.isEquals(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getUmidade(), null)) {
                    ajuste.setQtdeUmidade(this.pesquisarValorFichaTecnica(((FichaTecnicaAvaliador)f.getModeloFichaTecnica().getFichasTecnicasAvaliador().get(0)).getUmidade(), lote));
                }
                ajuste.setTicket(ticket);
                f.setAjusteEstoque(ajuste);
            }
        }
    }

    private Double pesquisarValorFichaTecnica(ItemModeloFichaTecnica itemModeloFichaTecnica, LoteFabricacao lote) {
        for (FichaTecnicaLoteFabricacao ficha : lote.getFichaTecnica()) {
            for (ValoresFichaLoteFab valores : ficha.getValoresFicha()) {
                if (!this.isEquals(valores.getItemModeloFichaTecnica(), itemModeloFichaTecnica)) continue;
                return Double.valueOf(valores.getValor());
            }
        }
        return 0.0;
    }

    public List<DTOLoteFabricacaoRes> getLotes(Long idProduto, String typed, boolean useIlike) {
        List<LoteFabricacao> lotes = ((DaoLoteFabricacaoImpl)this.getDao()).getLotes(idProduto, typed, useIlike);
        return this.buildToDTO(lotes, DTOLoteFabricacaoRes.class);
    }

    public DTOLoteFabricacaoRes getLote(Long idProduto, String loteFabricacao) {
        LoteFabricacao lote = ((DaoLoteFabricacaoImpl)this.getDao()).getLote(idProduto, loteFabricacao);
        return this.buildToDTO(lote, DTOLoteFabricacaoRes.class);
    }

    public LoteFabricacao avaliarCriarLoteFab(Produto entity) {
        if (!this.isAffimative(entity.getLoteUnico())) {
            return null;
        }
        if (!this.isAffimative(entity.getAtivo())) {
            return null;
        }
        return this.findOrCreateLoteUnico(entity);
    }

    public LoteFabricacao getSugestaoLote(Produto produto) {
        if (this.isEquals(produto.getLoteUnico(), EnumConstantsMentorSimNao.SIM.getValue())) {
            return this.findOrCreateLoteUnico(produto);
        }
        return this.helperLoteFabricacao.getLoteAuto(produto);
    }
}

