/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.manifestocteeletronico;

import com.touchcomp.basementor.model.vo.VersaoManifestoCte;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.notafiscal.CompNotaFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.manifestocteeletronico.ServiceManifestoCteEletronicoImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLManifestoCte;
import com.touchcomp.basementorxml.service.impl.xmlmanifestocte.ServiceXMLManifestoCteImpl;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceManifestoCteEletronicoXMLImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceManifestoCteEletronicoImpl serviceManifestoCteEletronicoImpl;
    @Autowired
    ServiceXMLManifestoCteImpl serviceXML;

    public File getXMLsZipFile(String ... chaves) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLsZipFile(ToolMethods.toList((Object[])chaves));
    }

    public File getXMLsZipFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(ids));
        return zip;
    }

    public List<File> getXMLsFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<Long> aux = new LinkedList<Long>();
        for (Long id : ids) {
            if (aux.contains(id)) continue;
            files.add(this.getXMLFile(id));
            aux.add(id);
        }
        return files;
    }

    public File getXMLFile(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(idNota, false);
    }

    public String getXMLStr(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        File f = this.getXMLFile(idNota, false);
        return ToolFile.getConteudoArquivo((File)f);
    }

    public File getXMLFile(Long idManifesto, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        try {
            XMLManifestoCte aux = this.serviceXML.getXMLManifestoCte(idManifesto);
            if (aux == null) {
                throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{idManifesto});
            }
            String xml = aux.getConteudoXML();
            if (removeInvalidUTF) {
                xml = ToolString.removeIllegalXMLChar((String)xml);
            }
            VersaoManifestoCte versao = this.serviceManifestoCteEletronicoImpl.getVersaoEmissao(idManifesto);
            String chaveCTe = this.serviceManifestoCteEletronicoImpl.getChave(idManifesto);
            Document document = ToolJdom.getDocument((String)xml);
            Element e = null;
            if (aux.getConteudoAprovacao() != null) {
                Document a = ToolJdom.getDocument((String)aux.getConteudoAprovacao());
                e = a.detachRootElement();
            }
            Element mdfeProc = new Element("mdfeProc");
            Attribute at = new Attribute("versao", versao.getCodigo());
            mdfeProc.setAttribute(at);
            mdfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/mdfe"));
            Element root = document.detachRootElement();
            mdfeProc.addContent((Content)root);
            if (e != null) {
                mdfeProc.addContent((Content)e);
            }
            document.setRootElement(mdfeProc);
            File tmpDir = ToolFile.getFileTMPDir();
            File temp = new File(tmpDir.getAbsolutePath() + File.separator + CompNotaFiscal.getFileNameMDFe(chaveCTe));
            ToolJdom.writeXMLPretty((Document)document, (File)temp, (String)"ISO-8859-1");
            return temp;
        }
        catch (ExceptionJDom ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO((Exception)((Object)ex), new Object[0]);
        }
    }
}

