/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.manutencaorotinasperiodicaspessoas;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.ItemManutencaoRotinasPessoas;
import com.touchcomp.basementor.model.vo.ManutencaoRotinasPeriodicasPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoManutencaoRotinasPeriodicasPessoasImpl;
import com.touchcomp.basementorservice.helpers.impl.manutencaorotinasperiodicas.HelperManutencaoRotinasPeriodicas;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.exameperiodo.ServiceExamePeriodoImpl;
import com.touchcomp.basementorservice.service.impl.funcao.ServiceFuncaoImpl;
import com.touchcomp.basementorservice.service.impl.manutencaorotinasperiodicaspessoas.UtilManutencaoRotinasPeriodicasPessoas;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.veiculo.ServiceVeiculoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.itemmanutencaorotinaspessoas.web.DTOItemManutencaoRotinasPessoas;
import com.touchcomp.touchvomodel.vo.manutencaorotinasperiodicaspessoas.web.DTOManutencaoRotinasPeriodicasPessoas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceManutencaoRotinasPeriodicasPessoasImpl
extends ServiceGenericEntityImpl<ManutencaoRotinasPeriodicasPessoas, Long, DaoManutencaoRotinasPeriodicasPessoasImpl> {
    private ServiceExamePeriodoImpl serviceExamePeriodo;
    private ServiceEmpresaImpl serviceEmpresa;
    private HelperManutencaoRotinasPeriodicas helper;
    private ServiceColaboradorImpl serviceColaborador;
    private ServicePessoaImpl servicePessoa;
    private ServiceVeiculoImpl serviceVeiculo;
    ServicePessoaImpl servicePessoaImpl;
    ServiceVeiculoImpl serviceVeiculoImpl;
    ServiceFuncaoImpl serviceFuncaoImpl;

    @Autowired
    public ServiceManutencaoRotinasPeriodicasPessoasImpl(DaoManutencaoRotinasPeriodicasPessoasImpl dao, ServicePessoaImpl servicePessoaImpl, ServiceVeiculoImpl serviceVeiculoImpl, ServiceFuncaoImpl serviceFuncaoImpl, ServiceExamePeriodoImpl serviceExamePeriodo, HelperManutencaoRotinasPeriodicas helper, ServiceEmpresaImpl serviceEmpresa, ServiceColaboradorImpl serviceColaborador, ServicePessoaImpl servicePessoa, ServiceVeiculoImpl serviceVeiculo) {
        super(dao);
        this.servicePessoaImpl = servicePessoaImpl;
        this.serviceVeiculoImpl = serviceVeiculoImpl;
        this.serviceFuncaoImpl = serviceFuncaoImpl;
        this.serviceExamePeriodo = serviceExamePeriodo;
        this.serviceEmpresa = serviceEmpresa;
        this.helper = helper;
        this.serviceColaborador = serviceColaborador;
        this.servicePessoa = servicePessoa;
        this.serviceVeiculo = serviceVeiculo;
    }

    public List pesquisarRotinasPeriodicasSemManutencaoFuncao(ExamePeriodo rotinaPeriodica, Colaborador colaborador, Short filtrarEmpresa, Empresa empresa) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasSemManutencaoFuncao(rotinaPeriodica, colaborador, filtrarEmpresa, empresa);
    }

    public List pesquisarRotinasPeriodicasSemManutencaoPessoa(ExamePeriodo rotinaPeriodica, Pessoa pessoa) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasSemManutencaoPessoa(rotinaPeriodica, pessoa);
    }

    public List pesquisarRotinasPeriodicasSemManutencaoVeiculo(ExamePeriodo rotinaPeriodica, Veiculo veiculo) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasSemManutencaoVeiculo(rotinaPeriodica, veiculo);
    }

    public List pesquisarRotinasPeriodicasManutencaoFuncaoVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Colaborador colaborador) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasManutencaoFuncaoVencida(rotinaPeriodica, dataApuracao, colaborador);
    }

    public List pesquisarRotinasPeriodicasManutencaoPessoaVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Pessoa pessoa) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasManutencaoPessoaVencida(rotinaPeriodica, dataApuracao, pessoa);
    }

    public List pesquisarRotinasPeriodicasManutencaoVeiculoVencida(ExamePeriodo rotinaPeriodica, Date dataApuracao, Veiculo veiculo) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasManutencaoVeiculoVencida(rotinaPeriodica, dataApuracao, veiculo);
    }

    public List pesquisarRotinasPeriodicasVencidasPessoa(Pessoa pessoa) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasVencidasPessoa(pessoa);
    }

    public List pesquisarRotinasPeriodicasVencidasVeiculo(Veiculo veiculo) {
        return ((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPeriodicasVencidasVeiculo(veiculo);
    }

    public String validarDocumentosVeiculoMotorista(ConjuntoTransportador conjuntoTransportador, Date dataEmissao) {
        return UtilManutencaoRotinasPeriodicasPessoas.validarDocumentosVeiculoMotorista(conjuntoTransportador, dataEmissao);
    }

    public DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas getNovoItemPessoa(Long idPessoa) {
        Pessoa p = (Pessoa)this.servicePessoaImpl.get(idPessoa);
        if (this.isNull(p).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1309.001", new Object[]{p}));
        }
        DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas item = new DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas();
        item.setPessoa(p.toString());
        item.setPessoaIdentificador(p.getIdentificador());
        return item;
    }

    public DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas getNovoItemVeiculo(Long idVeiculo) {
        Veiculo v = (Veiculo)this.serviceVeiculoImpl.get(idVeiculo);
        if (this.isNull(v).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0911.002", new Object[]{idVeiculo}));
        }
        DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas item = new DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas();
        item.setVeiculo(v.toString());
        item.setVeiculoIdentificador(v.getIdentificador());
        return item;
    }

    public DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas getNovoItemFuncao(Long idFuncao) {
        Funcao f = (Funcao)this.serviceFuncaoImpl.get(idFuncao);
        if (this.isNull(f).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0911.003", new Object[]{idFuncao}));
        }
        DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas item = new DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas();
        item.setFuncao(f.toString());
        item.setFuncaoIdentificador(f.getIdentificador());
        return item;
    }

    public List<DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas> adicionarColaborador(Long dataApuracao, Short filtrarRotina, Long examePeriodo, Short filtrarEmpresa, Long empresa, Long[] colaboradores) throws ExceptionValidacaoDados {
        List<ExamePeriodo> listRotinasPeriodicas = this.getRotinasPeriodicasFiltro(filtrarRotina, examePeriodo);
        Empresa emp = this.getEmpresaFiltro(filtrarEmpresa, empresa);
        List colaboradors = this.serviceColaborador.gets(colaboradores);
        ArrayList<ItemManutencaoRotinasPessoas> listManutencao = new ArrayList<ItemManutencaoRotinasPessoas>();
        for (Colaborador colaborador : colaboradors) {
            for (ExamePeriodo rotinaPeriodicas : listRotinasPeriodicas) {
                List listFuncao = this.pesquisarRotinasPeriodicasSemManutencaoFuncao(rotinaPeriodicas, colaborador, filtrarEmpresa, emp);
                List listFuncaoPessoaVeiculoVencida = this.pesquisarRotinasPeriodicasManutencaoFuncaoVencida(rotinaPeriodicas, new Date(dataApuracao), colaborador);
                this.helper.getItensManutencao(listFuncao, new ArrayList<Pessoa>(), new ArrayList<Veiculo>(), listFuncaoPessoaVeiculoVencida, listManutencao, rotinaPeriodicas);
            }
        }
        return this.buildToDTOGeneric(listManutencao, DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas.class);
    }

    public List<DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas> adicionarPessoa(Long dataApuracao, Short filtrarRotina, Long examePeriodo, Long[] pessoas) throws ExceptionValidacaoDados {
        List<ExamePeriodo> listRotinasPeriodicas = this.getRotinasPeriodicasFiltro(filtrarRotina, examePeriodo);
        List pessoaList = this.servicePessoa.gets(pessoas);
        ArrayList<ItemManutencaoRotinasPessoas> listManutencao = new ArrayList<ItemManutencaoRotinasPessoas>();
        for (Pessoa pessoa : pessoaList) {
            for (ExamePeriodo rotinaPeriodicas : listRotinasPeriodicas) {
                List listPessoa = this.pesquisarRotinasPeriodicasSemManutencaoPessoa(rotinaPeriodicas, pessoa);
                List listFuncaoPessoaVeiculoVencida = this.pesquisarRotinasPeriodicasManutencaoPessoaVencida(rotinaPeriodicas, new Date(dataApuracao), pessoa);
                this.helper.getItensManutencao(new ArrayList<Colaborador>(), listPessoa, new ArrayList<Veiculo>(), listFuncaoPessoaVeiculoVencida, listManutencao, rotinaPeriodicas);
            }
        }
        return this.buildToDTOGeneric(listManutencao, DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas.class);
    }

    public List<DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas> adicionarVeiculo(Long dataApuracao, Short filtrarRotina, Long examePeriodo, Long[] veiculos) throws ExceptionValidacaoDados {
        List<ExamePeriodo> listRotinasPeriodicas = this.getRotinasPeriodicasFiltro(filtrarRotina, examePeriodo);
        List veiculoList = this.serviceVeiculo.gets(veiculos);
        ArrayList<ItemManutencaoRotinasPessoas> listManutencao = new ArrayList<ItemManutencaoRotinasPessoas>();
        for (Veiculo veiculo : veiculoList) {
            for (ExamePeriodo rotinaPeriodicas : listRotinasPeriodicas) {
                List listVeiculo = this.pesquisarRotinasPeriodicasSemManutencaoVeiculo(rotinaPeriodicas, veiculo);
                List listFuncaoPessoaVeiculoVencida = this.pesquisarRotinasPeriodicasManutencaoVeiculoVencida(rotinaPeriodicas, new Date(dataApuracao), veiculo);
                this.helper.getItensManutencao(new ArrayList<Colaborador>(), new ArrayList<Pessoa>(), listVeiculo, listFuncaoPessoaVeiculoVencida, listManutencao, rotinaPeriodicas);
            }
        }
        return this.buildToDTOGeneric(listManutencao, DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas.class);
    }

    private List<ExamePeriodo> getRotinasPeriodicasFiltro(Short filtrarRotina, Long examePeriodo) throws ExceptionValidacaoDados {
        ExamePeriodo ex = (ExamePeriodo)this.serviceExamePeriodo.get(examePeriodo);
        if (this.isAffimative(filtrarRotina) && this.isNull(ex).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1309.002", new Object[0]);
        }
        ArrayList<ExamePeriodo> listRotinasPeriodicas = new ArrayList<ExamePeriodo>();
        if (!this.isNull(ex).booleanValue()) {
            listRotinasPeriodicas.add(ex);
        } else {
            listRotinasPeriodicas.addAll(this.serviceExamePeriodo.findAll());
        }
        return listRotinasPeriodicas;
    }

    private Empresa getEmpresaFiltro(Short filtrarEmpresa, Long empresa) throws ExceptionValidacaoDados {
        Empresa emp = (Empresa)this.serviceEmpresa.get(empresa);
        if (this.isAffimative(filtrarEmpresa) && this.isNull(emp).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1309.003", new Object[0]);
        }
        return emp;
    }

    public List<DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas> processarManutencao(Long dataApuracao, Short filtrarRotina, Long examePeriodo, Short filtrarEmpresa, Long empresa) throws ExceptionValidacaoDados {
        if (this.isNull(dataApuracao).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1309.001", new Object[0]);
        }
        List<ExamePeriodo> listRotinasPeriodicas = this.getRotinasPeriodicasFiltro(filtrarRotina, examePeriodo);
        Empresa emp = this.getEmpresaFiltro(filtrarEmpresa, empresa);
        ArrayList<ItemManutencaoRotinasPessoas> listManutencao = new ArrayList<ItemManutencaoRotinasPessoas>();
        for (ExamePeriodo rotinaPeriodicas : listRotinasPeriodicas) {
            List listFuncao = this.pesquisarRotinasPeriodicasSemManutencaoFuncao(rotinaPeriodicas, null, filtrarEmpresa, emp);
            List listPessoa = this.pesquisarRotinasPeriodicasSemManutencaoPessoa(rotinaPeriodicas, null);
            List listVeiculo = this.pesquisarRotinasPeriodicasSemManutencaoVeiculo(rotinaPeriodicas, null);
            List listFuncaoPessoaVeiculoVencida = this.pesquisarRotinasPeriodicasManutencaoFuncaoVencida(rotinaPeriodicas, new Date(dataApuracao), null);
            listFuncaoPessoaVeiculoVencida.addAll(this.pesquisarRotinasPeriodicasManutencaoPessoaVencida(rotinaPeriodicas, new Date(dataApuracao), null));
            listFuncaoPessoaVeiculoVencida.addAll(this.pesquisarRotinasPeriodicasManutencaoVeiculoVencida(rotinaPeriodicas, new Date(dataApuracao), null));
            this.helper.getItensManutencao(listFuncao, listPessoa, listVeiculo, listFuncaoPessoaVeiculoVencida, listManutencao, rotinaPeriodicas);
        }
        return this.buildToDTOGeneric(listManutencao, DTOManutencaoRotinasPeriodicasPessoas.DTOItemManutencaoRotinasPessoas.class);
    }

    public Date calcularDataVencimento(Long rotinaIdentificador, Long dataRealizacao, Long qtdOcorrenciaRealizada) {
        Date dataVencimento;
        ExamePeriodo rotina = (ExamePeriodo)this.serviceExamePeriodo.get(rotinaIdentificador);
        if (this.isNotNull(rotina).booleanValue() && TMethods.isNotNull((Object)dataRealizacao).booleanValue() && this.isNotNull(qtdOcorrenciaRealizada).booleanValue() && this.isNotNull(rotina.getNrOcorrencia()).booleanValue() && qtdOcorrenciaRealizada < rotina.getNrOcorrencia() && this.isNotNull(dataVencimento = ToolDate.nextDays((Date)new Date(dataRealizacao), (int)rotina.getQtdadeDias())).booleanValue()) {
            return dataVencimento;
        }
        return null;
    }

    @Override
    public ManutencaoRotinasPeriodicasPessoas beforeSave(ManutencaoRotinasPeriodicasPessoas vo) {
        for (ItemManutencaoRotinasPessoas i : vo.getRotinasPessoas()) {
            i.setManutencao(vo);
        }
        return vo;
    }

    public List<DTOItemManutencaoRotinasPessoas> pesquisarRotinasPessoa(Long idPessoa) {
        Pessoa pessoa = (Pessoa)this.servicePessoa.get(idPessoa);
        return this.buildToDTOGeneric(((DaoManutencaoRotinasPeriodicasPessoasImpl)this.getGenericDao()).pesquisarRotinasPessoa(pessoa), DTOItemManutencaoRotinasPessoas.class);
    }
}

