/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.modeloenviomensagens;

import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.ModeloEnvioMsgBI;
import com.touchcomp.basementor.model.vo.ModeloEnvioMsgPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoModeloEnvioMensagensImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.businessintelligence.ServiceBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import org.springframework.stereotype.Service;

@Service
public class ServiceModeloEnvioMensagensImpl
extends ServiceGenericEntityImpl<ModeloEnvioMensagens, Long, DaoModeloEnvioMensagensImpl> {
    final ServicePessoaImpl servicePessoa;
    final ServiceBusinessIntelligenceImpl serviceBI;

    public ServiceModeloEnvioMensagensImpl(ServicePessoaImpl servicePessoa, ServiceBusinessIntelligenceImpl serviceBI, DaoModeloEnvioMensagensImpl genericDao) {
        super(genericDao);
        this.servicePessoa = servicePessoa;
        this.serviceBI = serviceBI;
    }

    public <T> T getPessoaDestinatario(Long idPessoa, Class<T> aClass) throws ExceptionObjNotFound {
        Pessoa pes = (Pessoa)this.servicePessoa.getOrThrow(idPessoa);
        ModeloEnvioMsgPessoa me = new ModeloEnvioMsgPessoa();
        me.setPessoa(pes);
        return this.buildToDTOGeneric(me, aClass);
    }

    public <T> T getBIAnexo(Long idBI, Class<T> aClass) throws ExceptionObjNotFound {
        BusinessIntelligence bi = (BusinessIntelligence)this.serviceBI.getOrThrow(idBI);
        ModeloEnvioMsgBI m = new ModeloEnvioMsgBI();
        m.setBusinessIntelligence(bi);
        return this.buildToDTOGeneric(m, aClass);
    }

    @Override
    public ModeloEnvioMensagens beforeSave(ModeloEnvioMensagens aux) {
        aux.getBusinessIntelligenceAnexos().forEach(i -> i.setModeloEnvioMensagens(aux));
        aux.getPessoasEnvio().forEach(i -> i.setModeloEnvioMensagens(aux));
        return aux;
    }
}

