/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.modelofiscal;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstPercReducaoBaseCalcIcms;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoModeloFiscalImpl;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalProdutoImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalProdutosImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceModeloFiscal;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.impostos.web.DTOAliquotaImpostos;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ServiceModeloFiscalImpl
extends ServiceGenericEntityImpl<ModeloFiscal, Long, DaoModeloFiscalImpl>
implements ServiceModeloFiscal {
    ServiceModeloFiscalProdutoImpl serviceModeloFiscalProduto;
    ServiceModeloFiscalProdutosImpl serviceModeloFiscalProdutos;
    ServiceProdutoImpl serviceProduto;
    ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor;
    ServiceNaturezaOperacaoImpl serviceNaturezaOperacao;

    @Autowired
    public ServiceModeloFiscalImpl(DaoModeloFiscalImpl genericDao, ServiceModeloFiscalProdutoImpl serviceModeloFiscalProduto, ServiceModeloFiscalProdutosImpl serviceModeloFiscalProdutos, ServiceProdutoImpl serviceProduto, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor, ServiceNaturezaOperacaoImpl serviceNaturezaOperacao) {
        super(genericDao);
        this.serviceModeloFiscalProduto = serviceModeloFiscalProduto;
        this.serviceModeloFiscalProdutos = serviceModeloFiscalProdutos;
        this.serviceProduto = serviceProduto;
        this.serviceUnidadeFatFornecedor = serviceUnidadeFatFornecedor;
        this.serviceNaturezaOperacao = serviceNaturezaOperacao;
    }

    @Override
    public DaoModeloFiscalImpl getGenericDao() {
        return (DaoModeloFiscalImpl)super.getGenericDao();
    }

    @Override
    public ModeloFiscal beforeSave(ModeloFiscal vo) {
        if (vo.getObservacoesContrib() != null) {
            vo.getObservacoesContrib().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getObservacoesFisco() != null) {
            vo.getObservacoesFisco().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getUnidadeFederativas() != null) {
            vo.getUnidadeFederativas().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getModeloFiscalProduto() != null) {
            vo.getModeloFiscalProduto().setModeloFiscal(vo);
            if (vo.getModeloFiscalProduto().getProduto() != null) {
                vo.getModeloFiscalProduto().getProduto().forEach(it -> it.setModeloFiscalProduto(vo.getModeloFiscalProduto()));
            }
        }
        if (vo.getEmpresas() != null) {
            vo.getEmpresas().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getNcms() != null) {
            vo.getNcms().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getCategoriaPessoa() != null) {
            vo.getCategoriaPessoa().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getNaturezaOperacao() != null) {
            vo.getNaturezaOperacao().forEach(it -> it.setModeloFiscal(vo));
        }
        if (vo.getConfiguracaoAjusteIcmsDocFiscal() != null) {
            vo.getConfiguracaoAjusteIcmsDocFiscal().forEach(it -> it.setModeloFiscal(vo));
        }
        return vo;
    }

    @Override
    public ModeloFiscal getFirst(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String cnpj, Short contribuinteEstado, Short habilitarSuframa, Empresa empresa) {
        Short tipoInscFederal = this.buildTipoInscFederal(cnpj);
        Short tipoInscEstadual = contribuinteEstado;
        return this.getGenericDao().getFirst(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitarSuframa, empresa);
    }

    @Override
    public ModeloFiscal getModeloCondValida(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String cnpj, Short contribuinteEstado, Short habilitarSuframa, Empresa empresa, ModeloFiscal modelo) {
        Short tipoInscFederal = this.buildTipoInscFederal(cnpj);
        Short tipoInscEstadual = contribuinteEstado;
        return this.getGenericDao().getModeloCondValida(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitarSuframa, empresa, modelo);
    }

    @Override
    public List<ModeloFiscal> get(CategoriaPessoa categoriaPessoa, Produto produto, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String inscFederal, Short contribuinteEstado, Short habilitarSuframa, Empresa empresa) {
        Short tipoInscFederal = this.buildTipoInscFederal(inscFederal);
        Short tipoInscEstadual = contribuinteEstado;
        return this.getGenericDao().get(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitarSuframa, empresa);
    }

    public List<DTOEntidadeRes> getResumido(CategoriaPessoa categoriaPessoa, Produto produto, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String inscFederal, Short contribuinteEstado, Short habilitarSuframa, Empresa empresa) {
        Short tipoInscFederal = this.buildTipoInscFederal(inscFederal);
        Short tipoInscEstadual = contribuinteEstado;
        return this.getGenericDao().getResumido(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitarSuframa, empresa);
    }

    public List<DTOEntidadeRes> getResumido(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        return this.getGenericDao().getResumido(produto, naturezaOperacao, empresa, categoriaPessoa, usarPesqCategoria, usarPesqNcm, usarPesqProduto);
    }

    @Override
    public List<ModeloFiscal> get(Produto produto, UnidadeFederativa uf) {
        return this.getGenericDao().get(produto, uf);
    }

    private Short buildTipoInscFederal(String cnpjCPF) {
        Short tipoInscFederal = ToolString.refina((String)cnpjCPF).length() > 11 ? (short)0 : 1;
        return tipoInscFederal;
    }

    @Override
    public Short movimentacaoFisicaByModelo(Long idModelo) {
        return this.getGenericDao().movimentacaoFisicaByModelo(idModelo);
    }

    public ModeloFiscal getFirst(Produto prod, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String cnpj, Short contribuinteEstado, Short habilitarSuframa, Empresa empresa, IncidenciaIcms inc) {
        return ((DaoModeloFiscalImpl)this.getDao()).getFirst(prod, categoriaPessoa, uf, naturezaOperacao, this.buildTipoInscFederal(cnpj), contribuinteEstado, habilitarSuframa, empresa, inc);
    }

    public ModeloFiscal getFirstNFCe(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        if (produto == null || naturezaOperacao == null || empresa == null) {
            return null;
        }
        return ((DaoModeloFiscalImpl)this.getDao()).getFirstNFCe(produto, naturezaOperacao, empresa, categoriaPessoa, usarPesqCategoria, usarPesqNcm, usarPesqProduto);
    }

    @Override
    public List<ModeloFiscal> get(NaturezaOperacao nat) {
        return ((DaoModeloFiscalImpl)this.getDao()).get(nat);
    }

    public List<ModeloFiscal> pesquisaModeloFiscalAtivoEntrada() {
        return ((DaoModeloFiscalImpl)this.getDao()).pesquisaModeloFiscalAtivoEntrada();
    }

    public boolean forcarDataAtualizacaoProdutos(ModeloFiscal modeloFiscal) {
        return ((DaoModeloFiscalImpl)this.getDao()).forcarDataAtualizacaoProdutos(modeloFiscal);
    }

    public boolean existeModeloFiscalAtivoComModFiscalIpi(ModeloFiscalIpi m) {
        return ((DaoModeloFiscalImpl)this.getDao()).existeModeloFiscalAtivoComModFiscalIpi(m);
    }

    public boolean existeModeloFiscalAtivoComModFiscalICMS(ModeloFiscalIcms m) {
        return ((DaoModeloFiscalImpl)this.getDao()).existeModeloFiscalAtivoComModFiscalICMS(m);
    }

    public boolean existeModeloFiscalAtivoComModFiscalPisCofins(ModeloFiscalPisCofins m) {
        return ((DaoModeloFiscalImpl)this.getDao()).existeModeloFiscalAtivoComModFiscalPisCofins(m);
    }

    public DTOAliquotaImpostos calculaAliquotaImpostos(UnidadeFederativa unidadeFederativafOrigem, UnidadeFederativa unidadeFederativaDestino, ModeloFiscal modeloFiscal, Produto produto) {
        HelperModeloFiscal helperModeloFiscal = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
        Double aliquotaIpi = helperModeloFiscal.getAliquotaIpi(produto, modeloFiscal);
        Double aliquotaIcms = helperModeloFiscal.getAliquotaICMS(unidadeFederativafOrigem, unidadeFederativaDestino, produto, modeloFiscal);
        Double reducaoBaseCalcIcms = helperModeloFiscal.getReducaoBaseCalcIcms(produto, modeloFiscal);
        DTOAliquotaImpostos dto = new DTOAliquotaImpostos();
        dto.setAliquotaIcms(aliquotaIcms);
        dto.setAliquotaIpi(aliquotaIpi);
        dto.setReducaoBaseCalcIcms(reducaoBaseCalcIcms);
        return dto;
    }

    public Double getPercRedBC(Long produto, Long modeloFiscal) throws ExceptionObjNotFound {
        ModeloFiscal modFiscal = (ModeloFiscal)this.getOrThrow(modeloFiscal);
        Produto prod = (Produto)this.serviceProduto.getOrThrow(produto);
        return this.getPercRedBC(prod, modFiscal);
    }

    public Double getPercRedBC(Produto produto, ModeloFiscal modeloFiscal) {
        if (modeloFiscal != null && this.isEquals(modeloFiscal.getModeloFiscalIcms().getTipoPercReducaoBaseCalcIcms(), EnumConstPercReducaoBaseCalcIcms.TIPO_PERC_REDUCAO_BC_ICMS_MODELO.getValue())) {
            return modeloFiscal.getModeloFiscalIcms().getReducaoBaseCalcIcms();
        }
        if (produto != null) {
            return produto.getReducaoBaseCalcIcms();
        }
        return 0.0;
    }

    @Override
    public ModeloFiscal afterSaveEntity(final ModeloFiscal entity) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                ServiceModeloFiscalImpl.this.serviceModeloFiscalProdutos.forcarDtAtualizacaoProdAlterados(entity.getModeloFiscalProduto());
            }
        });
        return entity;
    }

    public ModeloFiscal getModeloFiscalByCnae(CNAE cnae) {
        return this.getGenericDao().getModeloFiscalByCnae(cnae);
    }
}

