/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.modelorps;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloRPS;
import com.touchcomp.basementor.model.vo.ModeloRpsCategoriaPessoa;
import com.touchcomp.basementor.model.vo.ModeloRpsCidade;
import com.touchcomp.basementor.model.vo.ModeloRpsEmpresa;
import com.touchcomp.basementor.model.vo.ModeloRpsServico;
import com.touchcomp.basementor.model.vo.ServicoRPS;
import com.touchcomp.basementorservice.dao.impl.DaoModeloRPSImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.categoriapessoa.ServiceCategoriaPessoaImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.servicorps.ServiceServicoRPSImpl;
import com.touchcomp.touchvomodel.vo.modelorpscategoriapessoa.web.DTOModeloRpsCategoriaPessoa;
import com.touchcomp.touchvomodel.vo.modelorpscidade.web.DTOModeloRpsCidade;
import com.touchcomp.touchvomodel.vo.modelorpsempresa.web.DTOModeloRpsEmpresa;
import com.touchcomp.touchvomodel.vo.modeorpsservico.web.DTOModeloRpsServico;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceModeloRPSImpl
extends ServiceGenericEntityImpl<ModeloRPS, Long, DaoModeloRPSImpl> {
    ServiceCidadeImpl serviceCidadeImpl;
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceCategoriaPessoaImpl serviceCategoriaPessoaImpl;
    ServiceServicoRPSImpl serviceServicoRPSImpl;

    @Autowired
    public ServiceModeloRPSImpl(DaoModeloRPSImpl dao, ServiceCidadeImpl serviceCidadeImpl, ServiceEmpresaImpl serviceEmpresaImpl, ServiceCategoriaPessoaImpl serviceCategoriaPessoaImpl, ServiceServicoRPSImpl serviceServicoRPSImpl) {
        super(dao);
        this.serviceCidadeImpl = serviceCidadeImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceCategoriaPessoaImpl = serviceCategoriaPessoaImpl;
        this.serviceServicoRPSImpl = serviceServicoRPSImpl;
    }

    @Override
    public ModeloRPS beforeSaveEntity(ModeloRPS aux) {
        aux.getModeloRpsCidade().forEach(i -> i.setModeloRps(aux));
        aux.getModeloRpsEmpresas().forEach(i -> i.setModeloRps(aux));
        aux.getModeloRpsCategoriaPessoa().forEach(i -> i.setModeloRps(aux));
        aux.getModeloRpsServico().forEach(i -> i.setModeloRps(aux));
        return aux;
    }

    public List<DTOModeloRpsCidade> getModeloRpsCidade(Long[] ids) {
        List cidades = this.serviceCidadeImpl.gets(ids);
        List modeloRpsCidade = cidades.stream().map(i -> {
            ModeloRpsCidade item = new ModeloRpsCidade();
            item.setCidade(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(modeloRpsCidade, DTOModeloRpsCidade.class);
    }

    public List<DTOModeloRpsEmpresa> getModeloRpsEmpresa(Long[] ids) {
        List empresas = this.serviceEmpresaImpl.gets(ids);
        List modeloRpsEmpresa = empresas.stream().map(i -> {
            ModeloRpsEmpresa item = new ModeloRpsEmpresa();
            item.setEmpresa(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(modeloRpsEmpresa, DTOModeloRpsEmpresa.class);
    }

    public List<DTOModeloRpsCategoriaPessoa> getModeloRpsCategoriaPessoa(Long[] ids) {
        List categoriaPessoa = this.serviceCategoriaPessoaImpl.gets(ids);
        List modeloRpsCategoriaPessoa = categoriaPessoa.stream().map(i -> {
            ModeloRpsCategoriaPessoa item = new ModeloRpsCategoriaPessoa();
            item.setCategoriaPessoa(i);
            item.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(modeloRpsCategoriaPessoa, DTOModeloRpsCategoriaPessoa.class);
    }

    public List<DTOModeloRpsServico> getModeloRpsServico(Long[] ids) {
        List servicoRPS = this.serviceServicoRPSImpl.gets(ids);
        List modeloRpsServico = servicoRPS.stream().map(i -> {
            ModeloRpsServico item = new ModeloRpsServico();
            item.setServicoRPS(i);
            item.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(modeloRpsServico, DTOModeloRpsServico.class);
    }

    public List<ModeloRPS> pesquisarModeloRpsCategoriaPessoaServicoRps(CategoriaPessoa categoriaPessoa, ServicoRPS servicoRps, Empresa empresa) {
        return ((DaoModeloRPSImpl)this.getGenericDao()).pesquisarModeloRpsCategoriaPessoaServicoRps(categoriaPessoa, servicoRps, empresa);
    }
}

