/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.movimentobancario;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.modelolancamentobancario.EnumConstModeloLancamentoBancario;
import com.touchcomp.basementor.constants.enums.movimentobancario.EnumConstTipoIntegMovimentoBancario;
import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.CompensacaoCheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.ContraPartMovimentoBancario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IntegracaoMovBancarioMovimento;
import com.touchcomp.basementor.model.vo.ItemBorderoCobranca;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.ModeloLancBancario;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.movimentobancario.CompMovimentoBancario;
import com.touchcomp.basementorservice.dao.impl.DaoMovimentoBancarioImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.borderotitulos.ServiceBorderoTitulosImpl;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.lancamento.ServiceLancamentoImpl;
import com.touchcomp.basementorservice.service.impl.lotecontabil.ServiceLoteContabilImpl;
import com.touchcomp.basementorservice.service.impl.modelolancbancario.ServiceModeloLancBancarioImpl;
import com.touchcomp.basementorservice.service.impl.movimentobancario.HelperValidarToleranciaMovimentoFinanceiro;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.opcoesgerenciais.ServiceOpcoesGerenciaisImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceMovimentoBancario;
import com.touchcomp.touchvomodel.res.DTOEntidadeResIdNome;
import com.touchcomp.touchvomodel.vo.contrapartmovimentobancario.web.DTOContraPartMovimentoBancario;
import com.touchcomp.touchvomodel.vo.movimentobancario.web.DTOMovimentoBancario;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ServiceMovimentoBancarioImpl
extends ServiceGenericEntityImpl<MovimentoBancario, Long, DaoMovimentoBancarioImpl>
implements ServiceMovimentoBancario {
    ServiceModeloLancBancarioImpl serviceModeloLancBancarioImpl;
    CompMovimentoBancario compMovimentoBancario;
    ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidadeImpl;
    HelperValidarToleranciaMovimentoFinanceiro helperValidarToleranciaMovimentoFinanceiro;
    ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceirasImpl;
    ServiceOpcoesGerenciaisImpl serviceOpcoesGerenciaisImpl;
    ServiceLoteContabilImpl serviceLoteContabilImpl;
    ServiceLancamentoImpl serviceLancamentoImpl;
    ServiceBorderoTitulosImpl serviceBorderoTitulosImpl;

    @Autowired
    public ServiceMovimentoBancarioImpl(DaoMovimentoBancarioImpl genericDao, ServiceModeloLancBancarioImpl serviceModeloLancBancarioImpl, CompMovimentoBancario compMovimentoBancario, ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidadeImpl, HelperValidarToleranciaMovimentoFinanceiro helperValidarToleranciaMovimentoFinanceiro, ServiceOpcoesFinanceirasImpl serviceOpcoesFinanceirasImpl, ServiceOpcoesGerenciaisImpl serviceOpcoesGerenciaisImpl, ServiceLoteContabilImpl serviceLoteContabilImpl, ServiceLancamentoImpl serviceLancamentoImpl, ServiceBorderoTitulosImpl serviceBorderoTitulosImpl) {
        super(genericDao);
        this.serviceModeloLancBancarioImpl = serviceModeloLancBancarioImpl;
        this.compMovimentoBancario = compMovimentoBancario;
        this.serviceEmpresaContabilidadeImpl = serviceEmpresaContabilidadeImpl;
        this.helperValidarToleranciaMovimentoFinanceiro = helperValidarToleranciaMovimentoFinanceiro;
        this.serviceOpcoesFinanceirasImpl = serviceOpcoesFinanceirasImpl;
        this.serviceOpcoesGerenciaisImpl = serviceOpcoesGerenciaisImpl;
        this.serviceLoteContabilImpl = serviceLoteContabilImpl;
        this.serviceLancamentoImpl = serviceLancamentoImpl;
        this.serviceBorderoTitulosImpl = serviceBorderoTitulosImpl;
    }

    @Override
    public DaoMovimentoBancarioImpl getGenericDao() {
        return (DaoMovimentoBancarioImpl)super.getGenericDao();
    }

    public void beforeShow(MovimentoBancario entity, Empresa empresa) {
        if (this.isNotNull(empresa).booleanValue() && this.isNotNull(empresa.getEmpresaDados()).booleanValue() && this.isNotNull(empresa.getEmpresaDados().getCentroResultadoContFin()).booleanValue()) {
            this.reload(empresa.getEmpresaDados().getCentroResultadoContFin());
            entity.setCentroResultadoContFin(empresa.getEmpresaDados().getCentroResultadoContFin());
        }
    }

    @Override
    public MovimentoBancario beforeSaveEntity(MovimentoBancario vo) {
        if (ServiceMovimentoBancarioImpl.isWithData(vo.getContraPartMovimentoBancario())) {
            for (ContraPartMovimentoBancario c : vo.getContraPartMovimentoBancario()) {
                c.setMovimentoBancario(vo);
                if (!this.isNotNull(c.getLancamentoCtbGerencial()).booleanValue()) continue;
                c.getLancamentoCtbGerencial().setHistorico(c.getHistorico());
            }
        }
        EmpresaContabilidade empresaContabilidade = this.serviceEmpresaContabilidadeImpl.findByEmpresa(vo.getEmpresa());
        this.validBeforeSaveEntity(vo, empresaContabilidade);
        if (this.isNotNull(vo.getCentroResultadoContFin()).booleanValue()) {
            vo.setEmpresa(vo.getCentroResultadoContFin().getEmpresa());
        }
        if (this.isEquals(empresaContabilidade.getLancMovimentoBancario(), EnumConstTipoIntegMovimentoBancario.INTEGRAR_ON_LINE.getEnumId())) {
            this.saveIntegracao(vo);
        }
        return vo;
    }

    public void saveIntegracao(MovimentoBancario vo) {
        LoteContabil lote;
        IntegracaoMovBancarioMovimento integracaoMov = vo.getIntegracaoMovBancarioMovimento();
        if (this.isNull(integracaoMov).booleanValue()) {
            integracaoMov = new IntegracaoMovBancarioMovimento();
            integracaoMov.setMovimentoBancario(vo);
            vo.setIntegracaoMovBancarioMovimento(integracaoMov);
        }
        if (this.isNotNull(lote = this.serviceLancamentoImpl.gerarLancamentosMovimentoBancario(integracaoMov)).booleanValue()) {
            lote = this.serviceLoteContabilImpl.saveOrUpdate(lote);
            integracaoMov.setLoteContabil(lote);
        }
    }

    @Override
    public MovimentoBancario beforeDeleteEntity(MovimentoBancario vo) {
        if (this.isNotNull(vo.getTransferenciaValor()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.008"));
        }
        if (this.isNotNull(vo.getGrupoDeBaixaFormas()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.009"));
        }
        if (this.isEquals(vo.getMovimentoConciliacao(), EnumConstantsMentorSimNao.SIM.getValue())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.010"));
        }
        return vo;
    }

    @Override
    public List<MovimentoBancario> findPorDataAndContaValor(Date dataInicial, Date dataFinal, ContaValores contaValor) {
        return this.getGenericDao().findPorDataAndContaValor(dataInicial, dataFinal, contaValor);
    }

    @Override
    public List<MovimentoBancario> findMovimentoPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        List<MovimentoBancario> movimentos = this.getGenericDao().findMovimentoPorPeriodo(dataInicial, dataFinal, grupoEmpresa);
        return movimentos;
    }

    @Async
    public CompletableFuture<List<DTOMovimentoBancario>> findMovimentoPorPeriodoAsync(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        List<DTOMovimentoBancario> result = this.buildToDTO(this.findMovimentoPorPeriodo(dataInicial, dataFinal, grupoEmpresa), DTOMovimentoBancario.class);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public List<MovimentoBancario> findMovimentoPeriodoPaginado(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa, Integer maxResults, Integer first) {
        return this.getGenericDao().findMovimentoPeriodoPaginado(dataInicial, dataFinal, grupoEmpresa, maxResults, first);
    }

    @Override
    public void deleteIntegracaoVincMovimentoBanc(MovimentoBancario vo) {
        if (vo == null || vo.getIntegracaoMovBancarioMovimento() == null) {
            return;
        }
        this.getGenericDao().deleteIntegracaoVincMovimentoBanc(vo);
    }

    public void updateMovimentoBancario(CompensacaoCheque compensacao, Boolean dataNula) {
        if (dataNula.booleanValue()) {
            this.getGenericDao().updateMovimentoBancario(compensacao.getCheque(), null);
        } else {
            this.getGenericDao().updateMovimentoBancario(compensacao.getCheque(), compensacao.getDataCompensacao());
        }
    }

    public List<DTOEntidadeResIdNome> carregarModeloLancamentoBancario(Short tipoLancamento) {
        if (this.isNull(tipoLancamento).booleanValue()) {
            return null;
        }
        List<ModeloLancBancario> modeloLancBancario = this.serviceModeloLancBancarioImpl.getModelosLancBancario(EnumConstModeloLancamentoBancario.get((Object)tipoLancamento));
        return this.buildToDTOGeneric(modeloLancBancario, DTOEntidadeResIdNome.class);
    }

    public DTOMovimentoBancario criarContraPartida(DTOMovimentoBancario input) {
        MovimentoBancario vo = (MovimentoBancario)this.buildToEntity(input);
        if (ServiceMovimentoBancarioImpl.isWithData(vo.getContraPartMovimentoBancario())) {
            vo.getContraPartMovimentoBancario().clear();
        }
        if (this.isNull(vo.getModeloLancamentoBancario()).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.001"));
        }
        if (!ServiceMovimentoBancarioImpl.isWithData(vo.getModeloLancamentoBancario().getItemModeloLancBancario())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.002"));
        }
        vo.getModeloLancamentoBancario().getItemModeloLancBancario().stream().filter(item -> this.isNull(item.getPlanoConta()) != false || this.isNull(item.getPlanoContaGerencial()) != false || this.isNull(item.getHistoricoPadrao()) != false).findAny().ifPresent(item -> {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.003"));
        });
        List<ContraPartMovimentoBancario> contraPartMovimentoBancario = this.compMovimentoBancario.newContraPartMovimentoBancario(vo);
        vo.setContraPartMovimentoBancario(contraPartMovimentoBancario);
        if (this.isEquals(contraPartMovimentoBancario.size(), 1)) {
            vo.setHistoricoPadrao(contraPartMovimentoBancario.getFirst().getHistoricoPadrao());
        }
        return this.buildToDTOGeneric(vo, DTOMovimentoBancario.class);
    }

    private void validBeforeSaveEntity(MovimentoBancario vo, EmpresaContabilidade empresaContabilidade) {
        Double valorDiferenca;
        OpcoesFinanceiras opcoesFinancira = this.serviceOpcoesFinanceirasImpl.findByEmpresa(vo.getEmpresa());
        if (this.isNull(opcoesFinancira).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.004"));
        }
        if (ServiceMovimentoBancarioImpl.isWithData(vo.getContraPartMovimentoBancario()) && (valorDiferenca = this.helperValidarToleranciaMovimentoFinanceiro.validToleranciaMovimentoFinanceiro(vo, opcoesFinancira.getToleranciaValorMovimentoFinanceiro())) > opcoesFinancira.getToleranciaValorMovimentoFinanceiro()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.005"));
        }
        OpcoesGerenciais opcoesGerenciais = this.serviceOpcoesGerenciaisImpl.findByEmpresa(vo.getEmpresa());
        if (this.isEquals(opcoesGerenciais.getLancarCentroCusto(), EnumConstantsMentorSimNao.SIM.getValue())) {
            AtomicInteger counter = new AtomicInteger(1);
            String idContrapartidaSemCentroCusto = vo.getContraPartMovimentoBancario().stream().filter(contraPart -> this.isNotNull(contraPart.getLancamentoCtbGerencial()) != false && this.isNull(contraPart.getLancamentoCtbGerencial().getCentroCusto()) != false).map(contraPart -> this.isNotNull(contraPart.getIdentificador()) != false ? contraPart.getIdentificador().toString() : String.valueOf(counter.getAndIncrement())).collect(Collectors.joining(","));
            if (this.isStrWithData(idContrapartidaSemCentroCusto)) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.006", new String[]{idContrapartidaSemCentroCusto}));
            }
        }
        if (this.isNull(empresaContabilidade).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.007"));
        }
    }

    public DTOContraPartMovimentoBancario vincularBorderoContrapartida(DTOContraPartMovimentoBancario input, Long idBordero) throws ExceptionObjNotFound {
        BorderoTitulos borderoTitulos = (BorderoTitulos)this.serviceBorderoTitulosImpl.getOrThrow(idBordero);
        if (!ServiceMovimentoBancarioImpl.isWithData(borderoTitulos.getItemBorderoCobranca())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0356.015"));
        }
        Double totalBordero = borderoTitulos.getItemBorderoCobranca().stream().mapToDouble(ItemBorderoCobranca::getValorCobrado).sum();
        input.setValor(totalBordero);
        input.setBordero(borderoTitulos.toString());
        input.setBorderoIdentificador(borderoTitulos.getIdentificador());
        return input;
    }

    public List<MovimentoBancario> finsMovimentosByDataCompAndConta(Date dataCompensacao, ContaValores conta) {
        return this.getGenericDao().finsMovimentosByDataCompAndConta(dataCompensacao, conta);
    }
}

