/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.movimentofolha;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidDataRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.CompEventosEsocFecFolha;
import com.touchcomp.basementorservice.dao.impl.DaoMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceMovimentoFolhaImpl
extends ServiceGenericEntityImpl<MovimentoFolha, Long, DaoMovimentoFolhaImpl> {
    @Autowired
    public ServiceMovimentoFolhaImpl(DaoMovimentoFolhaImpl dao) {
        super(dao);
    }

    public List<MovimentoFolha> findFolhaCustoMensal(Date dataInicio, Date dataFinal, Empresa empresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findFolhaCustoMensal(dataInicio, dataFinal, empresa);
    }

    public List<MovimentoFolha> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentosS1200(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<MovimentoFolha> findMovimentosS1200DecTerc(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentosS1200DecTerc(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<MovimentoFolha> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentosS1210(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<MovimentoFolha> findMovimentosByAberturaPeriodo(Long aberturaPeriodo) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentosByAberturaPeriodo(aberturaPeriodo);
    }

    public void fecharFolhasPagamento(Long aberturaPeriodo) {
        ((DaoMovimentoFolhaImpl)this.getGenericDao()).fecharFolhasPagamento(aberturaPeriodo);
    }

    public MovimentoFolha getMovimentoFolhaAdd(Colaborador colaborador, Date dataAfastamento, EmpresaRh empresaRh) {
        CompEventosEsocFecFolha compEsocFechamentoFolha = (CompEventosEsocFecFolha)ConfApplicationContext.getBean(CompEventosEsocFecFolha.class);
        MovimentoFolha movimentoFolha = ((DaoMovimentoFolhaImpl)this.getGenericDao()).getMovimentoFolhaAdd(colaborador, dataAfastamento, empresaRh);
        compEsocFechamentoFolha.criarRubricas1200(movimentoFolha, empresaRh);
        return movimentoFolha;
    }

    public List<MovimentoFolha> findFolhaAbertaColaborador(Long colaborador, Long empresa, Date dataFinal) {
        if (this.isNull(colaborador).booleanValue() || this.isNull(empresa).booleanValue() || this.isNull(dataFinal).booleanValue()) {
            return null;
        }
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findFolhaAbertaColaborador(colaborador, empresa, dataFinal);
    }

    public List<HashMap> findMovimentoFolhaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentoFolhaPorDataPagamentoEmpresa(dataPagamento, empresa);
    }

    public List<HashMap> findMovimentoFolhaPorDataPagamentoEmpresaTipoCalculo(Date dataPagamento, Empresa empresa, Short tipoCalculo) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findMovimentoFolhaPorDataPagamentoEmpresaTipoCalculo(dataPagamento, empresa, tipoCalculo);
    }

    public int getDiasFaltasPeriodo(Colaborador colaborador, Date periodoInicial, Date periodoFinal, Empresa emp) {
        double horasFalta;
        TipoCalculoEvento tipoEventoFaltasHora;
        int qtdFaltas = 0;
        TipoCalculoEvento tipoEventoFaltasDia = this.getSharedData().getEmpresaRh(emp).getTpFaltas();
        if (tipoEventoFaltasDia != null) {
            double diasFaltas = ((DaoMovimentoFolhaImpl)this.getDao()).getQuantidadeFaltasPeriodo(colaborador, periodoInicial, periodoFinal, tipoEventoFaltasDia);
            qtdFaltas = (int)((double)qtdFaltas + diasFaltas);
        }
        if ((tipoEventoFaltasHora = this.getSharedData().getEmpresaRh(emp).getTpFaltaHoras()) != null && (horasFalta = ((DaoMovimentoFolhaImpl)this.getDao()).getQuantidadeFaltasPeriodo(colaborador, periodoInicial, periodoFinal, tipoEventoFaltasHora)) > 0.0) {
            if (!ToolMethods.isWithData((Number)colaborador.getHorasTrabDia())) {
                throw new ExceptionInvalidDataRuntime(new ExcepCodeDetail("E.ERP.0516.015", new Object[]{colaborador}));
            }
            Double referencia = horasFalta / colaborador.getHorasTrabDia();
            qtdFaltas = (int)((double)qtdFaltas + referencia);
        }
        return qtdFaltas;
    }

    public List<Map<String, Object>> getItens(Empresa empresa, Date periodo, TipoCalculoEvento tpPensao, TipoCalculo tipoFolha) {
        return ((DaoMovimentoFolhaImpl)this.getDao()).getValorItemMovFolha(empresa, periodo, tpPensao, tipoFolha);
    }

    public List<Map<String, Object>> getItens(Empresa empresa, Date periodo, TipoCalculoEvento tipoCalculo) {
        return ((DaoMovimentoFolhaImpl)this.getDao()).getValorItemMovFolha(empresa, periodo, tipoCalculo);
    }

    public List<HashMap> findItemMovimentoFolhaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return ((DaoMovimentoFolhaImpl)this.getGenericDao()).findItemMovimentoFolhaPorDataPagamentoEmpresa(dataPagamento, empresa);
    }
}

