/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.movimentoprodutos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoCarregQtdeVlr;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldo;
import com.touchcomp.basementor.constants.enums.sadoestoque.EnumConstSaldoEstTipoSaldoQtde;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorexceptions.exceptions.impl.database.ExceptionDatabase;
import com.touchcomp.basementorservice.dao.impl.DaoListagemMovimentoProdutosImpl;
import com.touchcomp.basementorservice.model.movimentoprodutos.RazaoAnalitico;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceMovimentoProdutosImpl
extends ServiceGenericImpl {
    @Autowired
    DaoListagemMovimentoProdutosImpl daoListagemMovimentoProdutosImpl;
    @Autowired
    ServiceSaldoEstoqueImpl serviceSaldoEstoqueImpl;

    public Collection gerarRelMovimentoProdutos(Params params) {
        return this.findDadosRelMovProd(params);
    }

    public Collection findDadosRelMovProd(Params params) throws ExceptionDatabase {
        ArrayList<RazaoAnalitico> movimentos = new ArrayList<RazaoAnalitico>();
        if (this.isEquals(params.getFiltrarCentroCusto(), params.getConst_origens_centro_custo()) && this.isAffimative(params.getMovimentaEstoque())) {
            movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosComunicadoProducao(params));
            movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosRequisicao(params));
            movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosNFTerceirosRelMovProd(params));
        } else {
            if (this.isAffimative(params.getFiltrarNotasProprias())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosNFPropriaRelMovProd(params));
            }
            if (this.isAffimative(params.getFiltrarComunicadoProducao()) && this.isAffimative(params.getMovimentaEstoque())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosComunicadoProducao(params));
            }
            if (this.isAffimative(params.getFiltrarImplantacoes()) && this.isAffimative(params.getMovimentaEstoque())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosImplantacaoSaldo(params));
            }
            if (this.isAffimative(params.getFiltrarNotasTerceiros())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosNFTerceirosRelMovProd(params));
            }
            if (this.isAffimative(params.getFiltrarRequisicoes()) && this.isAffimative(params.getMovimentaEstoque())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosRequisicao(params));
            }
            if (this.isAffimative(params.getFiltrarTransferencias()) && this.isAffimative(params.getMovimentaEstoque())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosTransfEstOrigem(params));
            }
            if (this.isAffimative(params.getFiltrarTransferencias()) && this.isAffimative(params.getMovimentaEstoque())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosTransfEstDestino(params));
            }
            if (this.isAffimative(params.getFiltrarPedidoComercio())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosPedComercio(params));
            }
            if (this.isAffimative(params.getFiltrarTicketFiscal())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getTicketFiscal(params));
            }
            if (this.isAffimative(params.getFiltrarTicketFiscalEntrada())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getTicketFiscalEntrada(params));
            }
            if (this.isAffimative(params.getFiltrarNfce())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosNFCe(params));
            }
            if (this.isAffimative(params.getFiltrarPedido())) {
                movimentos.addAll(this.daoListagemMovimentoProdutosImpl.getMovimentosPedidoPreVenda(params));
            }
        }
        this.processarMovimentos(movimentos, params);
        return movimentos;
    }

    private void processarMovimentos(List<RazaoAnalitico> movimentos, Params params) throws ExceptionDatabase {
        Collections.sort(movimentos);
        RazaoAnalitico last = null;
        for (RazaoAnalitico aux : movimentos) {
            if (last == null || !ToolMethods.isEquals((Object)last.getIdProduto(), (Object)aux.getIdProduto())) {
                SaldoEstoqueGeralBasico s = this.findSaldoAnterior(aux, params);
                if (s != null) {
                    aux.setSaldoQtdAnterior(s.getQuantidade());
                    aux.setSaldoVlrAnterior(s.getValor());
                    aux.setValorMedioAnt(s.getValorMedio());
                }
            } else {
                aux.setSaldoQtdAnterior(last.getSaldoQuantitativo());
                aux.setSaldoVlrAnterior(last.getSaldoValor());
                aux.setValorMedioAnt(last.getValorMedio());
            }
            if (ToolMethods.isEquals((Object)aux.getEntradaSaida(), (Object)0) || ToolMethods.isEquals((Object)aux.getEntradaSaida(), (Object)2)) {
                aux.setQtdEntradaDia(ToolFormatter.arrredondarNumero((Double)(aux.getQtdEntradaDia() + aux.getQuantidade()), (int)6));
                aux.setVlrEntradaDia(ToolFormatter.arrredondarNumero((Double)(aux.getVlrEntradaDia() + aux.getQuantidade() * aux.getValorUnitario()), (int)6));
            } else {
                aux.setQtdSaidaDia(ToolFormatter.arrredondarNumero((Double)(aux.getQtdSaidaDia() + aux.getQuantidade()), (int)6));
            }
            aux.setSaldoQuantitativo(ToolFormatter.arrredondarNumero((Double)(aux.getSaldoQtdAnterior() + aux.getQtdEntradaDia() - aux.getQtdSaidaDia()), (int)6));
            if (aux.getSaldoQtdAnterior() < 0.0 && aux.getQtdEntradaDia() > 0.0) {
                aux.setValorMedio(ToolFormatter.arrredondarNumero((Double)((aux.getSaldoVlrAnterior() + aux.getVlrEntradaDia()) / aux.getQtdEntradaDia()), (int)6));
            } else if (aux.getSaldoQtdAnterior() + aux.getQtdEntradaDia() > 0.0) {
                aux.setValorMedio(ToolFormatter.arrredondarNumero((Double)((aux.getSaldoVlrAnterior() + aux.getVlrEntradaDia()) / (aux.getSaldoQtdAnterior() + aux.getQtdEntradaDia())), (int)6));
            } else {
                aux.setValorMedio(0.0);
            }
            aux.setVlrSaidaDia(ToolFormatter.arrredondarNumero((Double)(aux.getQtdSaidaDia() * aux.getValorMedio()), (int)6));
            aux.setSaldoValor(ToolFormatter.arrredondarNumero((Double)(aux.getSaldoQuantitativo() * aux.getValorMedio()), (int)6));
            if (this.isEquals(params.getExibirValoresEntradaSaida(), EnumConstantsMentorSimNao.SIM.getValue())) {
                aux.setValorTotal(aux.getQuantidade() * aux.getValorUnitario());
            }
            if (aux.getSaldoQuantitativo() == 0.0) {
                aux.setSaldoValor(0.0);
            }
            if (aux.getSaldoQuantitativo() < 0.0) {
                aux.setValorMedio(0.0);
                aux.setVlrSaidaDia(0.0);
                aux.setSaldoValor(0.0);
            }
            last = aux;
        }
    }

    private SaldoEstoqueGeralBasico findSaldoAnterior(RazaoAnalitico aux, Params params) throws ExceptionDatabase {
        List<SaldoEstoqueGeralBasico> sal;
        Date dataConsulta = ToolDate.previousDays((Date)params.getDataInicial(), (int)1);
        Long idGradeInLocal = params.getIdGradeCorInicial();
        Long idGradeFimLocal = params.getIdGradeCorFinal();
        Long idCentroEstInicial = params.getIdCentroEstInicial();
        Long idCentroEstFinal = params.getIdCentroEstFinal();
        Long idLote = params.getIdLote();
        if (!this.isAffimative(params.getFiltrarLote())) {
            idLote = null;
        }
        if (!this.isAffimative(params.getFiltrarCentroEstoque())) {
            idCentroEstFinal = null;
            idCentroEstInicial = null;
        }
        if (!this.isAffimative(params.getFiltrarGradeCor())) {
            idGradeFimLocal = null;
            idGradeInLocal = null;
        }
        if (!ServiceMovimentoProdutosImpl.isWithData(sal = this.serviceSaldoEstoqueImpl.findSaldoGradeCentroEstoqueLoteListaBasico(aux.getIdProduto(), aux.getIdProduto(), idGradeInLocal, idGradeFimLocal, dataConsulta, params.getEmpresa().getIdentificador(), params.getEmpresa().getIdentificador(), idLote, idCentroEstInicial, idCentroEstFinal, null, EnumConstCentroEstTipoPropTerc.get((Object)params.getTipoCentroEstoque()), null, EnumConstSaldoEstTipoSaldo.TIPO_SALDO_PRODUTO, EnumConstSaldoEstTipoSaldoQtde.TIPO_SALDO_QTQ_TUDO, EnumConstSaldoEstTipoCarregQtdeVlr.TIPO_SALDO_QTQ_VLR_TUDO))) {
            return null;
        }
        return sal.get(0);
    }

    public static class Params {
        private final Empresa empresa;
        private final Date dataInicial;
        private final Date dataFinal;
        private final Short filtrarProduto;
        private final Long idInicial;
        private final Long idFinal;
        private final Short filtrarGradeCor;
        private final Long idGradeCorInicial;
        private final Long idGradeCorFinal;
        private final String gradeCor;
        private final Short filtrarEspecie;
        private final Long idEspecieInicial;
        private final Long idEspecieFinal;
        private final Short filtrarSubespecieProduto;
        private final Long idSubespecieInicial;
        private final Long idSubespecieFinal;
        private final Short filtrarLote;
        private final Long idLote;
        private final Short filtrarCentroEstoque;
        private final Long idCentroEstInicial;
        private final Long idCentroEstFinal;
        private final Short filtrarCentroCusto;
        private final Long idCentroCusto;
        private final Short movimentaEstoque;
        private final Short tipoCentroEstoque;
        private final Short exibirMovimentos;
        private final Short exibirNomeClienteForne;
        private final Short exibirValoresMonetarios;
        private final Short exibirValoresEntradaSaida;
        private final Short exibirDescricaoCentroCusto;
        private final Short filtrarRequisicoes;
        private final Short filtrarImplantacoes;
        private final Short filtrarNotasProprias;
        private final Short filtrarNotasTerceiros;
        private final Short filtrarTransferencias;
        private final Short filtrarComunicadoProducao;
        private final Short filtrarPedidoComercio;
        private final Short filtrarTicketFiscal;
        private final Short filtrarTicketFiscalEntrada;
        private final Short filtrarNfce;
        private final Short filtrarPedido;
        private final Short const_origens_centro_custo = 2;

        public Params(Empresa empresa, Date dataInicial, Date dataFinal, Short filtrarProduto, Long idInicial, Long idFinal, Short filtrarGradeCor, Long idGradeCorInicial, Long idGradeCorFinal, String gradeCor, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubespecieProduto, Long idSubespecieInicial, Long idSubespecieFinal, Short filtrarLote, Long idLote, Short filtrarCentroEstoque, Long idCentroEstInicial, Long idCentroEstFinal, Short filtrarCentroCusto, Long idCentroCusto, Short movimentaEstoque, Short tipoCentroEstoque, Short exibirMovimentos, Short exibirNomeClienteForne, Short exibirValoresMonetarios, Short exibirValoresEntradaSaida, Short exibirDescricaoCentroCusto, Short filtrarRequisicoes, Short filtrarImplantacoes, Short filtrarNotasProprias, Short filtrarNotasTerceiros, Short filtrarTransferencias, Short filtrarComunicadoProducao, Short filtarPedidoComercio, Short filtrarTicketFiscal, Short filtrarTicketFiscalEntrada, Short filtrarNfce, Short filtrarPedido) {
            this.empresa = empresa;
            this.dataInicial = dataInicial;
            this.dataFinal = dataFinal;
            this.filtrarProduto = filtrarProduto;
            this.idInicial = idInicial;
            this.idFinal = idFinal;
            this.filtrarGradeCor = filtrarGradeCor;
            this.idGradeCorInicial = idGradeCorInicial;
            this.idGradeCorFinal = idGradeCorFinal;
            this.gradeCor = gradeCor;
            this.filtrarEspecie = filtrarEspecie;
            this.idEspecieInicial = idEspecieInicial;
            this.idEspecieFinal = idEspecieFinal;
            this.filtrarSubespecieProduto = filtrarSubespecieProduto;
            this.idSubespecieInicial = idSubespecieInicial;
            this.idSubespecieFinal = idSubespecieFinal;
            this.filtrarLote = filtrarLote;
            this.idLote = idLote;
            this.filtrarCentroEstoque = filtrarCentroEstoque;
            this.idCentroEstInicial = idCentroEstInicial;
            this.idCentroEstFinal = idCentroEstFinal;
            this.filtrarCentroCusto = filtrarCentroCusto;
            this.idCentroCusto = idCentroCusto;
            this.movimentaEstoque = movimentaEstoque;
            this.tipoCentroEstoque = tipoCentroEstoque;
            this.exibirMovimentos = exibirMovimentos;
            this.exibirNomeClienteForne = exibirNomeClienteForne;
            this.exibirValoresMonetarios = exibirValoresMonetarios;
            this.exibirValoresEntradaSaida = exibirValoresEntradaSaida;
            this.exibirDescricaoCentroCusto = exibirDescricaoCentroCusto;
            this.filtrarRequisicoes = filtrarRequisicoes;
            this.filtrarImplantacoes = filtrarImplantacoes;
            this.filtrarNotasProprias = filtrarNotasProprias;
            this.filtrarNotasTerceiros = filtrarNotasTerceiros;
            this.filtrarTransferencias = filtrarTransferencias;
            this.filtrarComunicadoProducao = filtrarComunicadoProducao;
            this.filtrarPedidoComercio = filtarPedidoComercio;
            this.filtrarTicketFiscal = filtrarTicketFiscal;
            this.filtrarTicketFiscalEntrada = filtrarTicketFiscalEntrada;
            this.filtrarNfce = filtrarNfce;
            this.filtrarPedido = filtrarPedido;
        }

        @Generated
        public Empresa getEmpresa() {
            return this.empresa;
        }

        @Generated
        public Date getDataInicial() {
            return this.dataInicial;
        }

        @Generated
        public Date getDataFinal() {
            return this.dataFinal;
        }

        @Generated
        public Short getFiltrarProduto() {
            return this.filtrarProduto;
        }

        @Generated
        public Long getIdInicial() {
            return this.idInicial;
        }

        @Generated
        public Long getIdFinal() {
            return this.idFinal;
        }

        @Generated
        public Short getFiltrarGradeCor() {
            return this.filtrarGradeCor;
        }

        @Generated
        public Long getIdGradeCorInicial() {
            return this.idGradeCorInicial;
        }

        @Generated
        public Long getIdGradeCorFinal() {
            return this.idGradeCorFinal;
        }

        @Generated
        public String getGradeCor() {
            return this.gradeCor;
        }

        @Generated
        public Short getFiltrarEspecie() {
            return this.filtrarEspecie;
        }

        @Generated
        public Long getIdEspecieInicial() {
            return this.idEspecieInicial;
        }

        @Generated
        public Long getIdEspecieFinal() {
            return this.idEspecieFinal;
        }

        @Generated
        public Short getFiltrarSubespecieProduto() {
            return this.filtrarSubespecieProduto;
        }

        @Generated
        public Long getIdSubespecieInicial() {
            return this.idSubespecieInicial;
        }

        @Generated
        public Long getIdSubespecieFinal() {
            return this.idSubespecieFinal;
        }

        @Generated
        public Short getFiltrarLote() {
            return this.filtrarLote;
        }

        @Generated
        public Long getIdLote() {
            return this.idLote;
        }

        @Generated
        public Short getFiltrarCentroEstoque() {
            return this.filtrarCentroEstoque;
        }

        @Generated
        public Long getIdCentroEstInicial() {
            return this.idCentroEstInicial;
        }

        @Generated
        public Long getIdCentroEstFinal() {
            return this.idCentroEstFinal;
        }

        @Generated
        public Short getFiltrarCentroCusto() {
            return this.filtrarCentroCusto;
        }

        @Generated
        public Long getIdCentroCusto() {
            return this.idCentroCusto;
        }

        @Generated
        public Short getMovimentaEstoque() {
            return this.movimentaEstoque;
        }

        @Generated
        public Short getTipoCentroEstoque() {
            return this.tipoCentroEstoque;
        }

        @Generated
        public Short getExibirMovimentos() {
            return this.exibirMovimentos;
        }

        @Generated
        public Short getExibirNomeClienteForne() {
            return this.exibirNomeClienteForne;
        }

        @Generated
        public Short getExibirValoresMonetarios() {
            return this.exibirValoresMonetarios;
        }

        @Generated
        public Short getExibirValoresEntradaSaida() {
            return this.exibirValoresEntradaSaida;
        }

        @Generated
        public Short getExibirDescricaoCentroCusto() {
            return this.exibirDescricaoCentroCusto;
        }

        @Generated
        public Short getFiltrarRequisicoes() {
            return this.filtrarRequisicoes;
        }

        @Generated
        public Short getFiltrarImplantacoes() {
            return this.filtrarImplantacoes;
        }

        @Generated
        public Short getFiltrarNotasProprias() {
            return this.filtrarNotasProprias;
        }

        @Generated
        public Short getFiltrarNotasTerceiros() {
            return this.filtrarNotasTerceiros;
        }

        @Generated
        public Short getFiltrarTransferencias() {
            return this.filtrarTransferencias;
        }

        @Generated
        public Short getFiltrarComunicadoProducao() {
            return this.filtrarComunicadoProducao;
        }

        @Generated
        public Short getFiltrarPedidoComercio() {
            return this.filtrarPedidoComercio;
        }

        @Generated
        public Short getFiltrarTicketFiscal() {
            return this.filtrarTicketFiscal;
        }

        @Generated
        public Short getFiltrarTicketFiscalEntrada() {
            return this.filtrarTicketFiscalEntrada;
        }

        @Generated
        public Short getFiltrarNfce() {
            return this.filtrarNfce;
        }

        @Generated
        public Short getFiltrarPedido() {
            return this.filtrarPedido;
        }

        @Generated
        public Short getConst_origens_centro_custo() {
            return this.const_origens_centro_custo;
        }
    }
}

