/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.naturezaoperacao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNaturezaOperacaoImpl
extends ServiceGenericEntityImpl<NaturezaOperacao, Long, DaoNaturezaOperacaoImpl> {
    @Autowired
    public ServiceNaturezaOperacaoImpl(DaoNaturezaOperacaoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public NaturezaOperacao beforeSave(NaturezaOperacao aux) {
        if (aux.getEmpresas() != null) {
            aux.getEmpresas().forEach(i -> i.setNaturezaOperacao(aux));
        }
        return aux;
    }

    public List<NaturezaOperacao> getNaturezasPedAlmox(Empresa empresa) {
        return ((DaoNaturezaOperacaoImpl)this.getGenericDao()).getNaturezasPedAlmox(empresa);
    }

    public List<NaturezaOperacao> getNaturezasNecCompra(Empresa empresa) {
        return ((DaoNaturezaOperacaoImpl)this.getGenericDao()).getNaturezasNecCompra(empresa);
    }

    public NaturezaOperacao getNaturezaNecCompra(Long identificador, Empresa empresa) throws ExceptionInvalidData {
        NaturezaOperacao natureza = ((DaoNaturezaOperacaoImpl)this.getGenericDao()).getNaturezaNecCompra(identificador, empresa);
        if (this.isNull(natureza).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1064.002", new Object[]{identificador});
        }
        return natureza;
    }

    public NaturezaOperacao atualizaOpcaoDispNFCe(NaturezaOperacao nat) {
        ServiceModeloFiscalImpl service = this.getBean(ServiceModeloFiscalImpl.class);
        List<ModeloFiscal> modelos = service.get(nat);
        for (ModeloFiscal modelo : modelos) {
            new HelperModeloFiscal().build(modelo).setOpcaoDisponivelNFCe(nat.getNatOperacaoDispNFCe());
        }
        service.saveOrUpdate(modelos);
        return this.saveOrUpdate(nat);
    }

    public List<NaturezaOperacao> getNatOpEntAtivaDev(Empresa logedEmpresa) {
        return ((DaoNaturezaOperacaoImpl)this.getDao()).getNatOpEntAtivaDev(logedEmpresa);
    }

    public List<NaturezaOperacao> getNatOpSaiAtivaDev(Empresa logedEmpresa) {
        return ((DaoNaturezaOperacaoImpl)this.getDao()).getNatOpSaiAtivaDev(logedEmpresa);
    }

    public List getNatOpSaiAtiva(Empresa empresa) {
        return ((DaoNaturezaOperacaoImpl)this.getDao()).getNatOpSaiAtiva(empresa);
    }

    public List<NaturezaOperacao> getNatOpFatEntAtivaDev(Empresa logedEmpresa) {
        return ((DaoNaturezaOperacaoImpl)this.getDao()).getNatOpFatEntAtivaDev(logedEmpresa);
    }

    public List<NaturezaOperacao> getNaturezasOperacaoEntrada() {
        return ((DaoNaturezaOperacaoImpl)this.getDao()).getNaturezasOperacaoEntrada();
    }
}

