/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.naturezarequisicao;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.EnumParamCtbRequisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.dao.impl.DaoNaturezaRequisicaoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNaturezaRequisicaoImpl
extends ServiceGenericEntityImpl<NaturezaRequisicao, Long, DaoNaturezaRequisicaoImpl> {
    ServiceProdutoImpl serviceProduto;

    @Autowired
    public ServiceNaturezaRequisicaoImpl(DaoNaturezaRequisicaoImpl genericDao, ServiceProdutoImpl serviceProduto) {
        super(genericDao);
        this.serviceProduto = serviceProduto;
    }

    public List<NaturezaRequisicao> get(Produto produto, GrupoEmpresa grupoEmpresa) {
        if (produto == null) {
            return new LinkedList<NaturezaRequisicao>();
        }
        return ((DaoNaturezaRequisicaoImpl)this.getGenericDao()).get(produto, grupoEmpresa);
    }

    public List<NaturezaRequisicao> get(Produto produto, Empresa empresa) {
        return this.get(produto, empresa.getEmpresaDados().getGrupoEmpresa());
    }

    public List<NaturezaRequisicao> getOrThrow(Produto produto, Empresa empresa) throws ExceptionParamCtbRequisicao {
        return this.getOrThrow(produto, empresa.getEmpresaDados().getGrupoEmpresa());
    }

    public List<NaturezaRequisicao> getOrThrow(Long produto, Empresa empresa) throws ExceptionParamCtbRequisicao {
        return this.getOrThrow((Produto)this.serviceProduto.get(produto), empresa.getEmpresaDados().getGrupoEmpresa());
    }

    public List<NaturezaRequisicao> getOrThrow(Produto produto, GrupoEmpresa grupoEmpresa) throws ExceptionParamCtbRequisicao {
        if (produto == null) {
            return new LinkedList<NaturezaRequisicao>();
        }
        List<NaturezaRequisicao> res = ((DaoNaturezaRequisicaoImpl)this.getGenericDao()).get(produto, grupoEmpresa);
        if (res == null || res.isEmpty()) {
            throw new ExceptionParamCtbRequisicao(EnumParamCtbRequisicao.NENHUMA_PARAETRIZACAO_ENCONTRADA, new Object[]{grupoEmpresa, null, produto});
        }
        return res;
    }

    public NaturezaRequisicao getFirstOrThrow(Produto produto, GrupoEmpresa grupoEmpresa) throws ExceptionParamCtbRequisicao {
        List<NaturezaRequisicao> found = this.getOrThrow(produto, grupoEmpresa);
        if (found != null && found.size() > 0) {
            return found.get(0);
        }
        throw new ExceptionParamCtbRequisicao(EnumParamCtbRequisicao.NENHUMA_PARAETRIZACAO_ENCONTRADA, new Object[]{grupoEmpresa, null, produto});
    }

    public NaturezaRequisicao getFirst(Produto produto, GrupoEmpresa grupoEmpresa) {
        List<NaturezaRequisicao> found = this.get(produto, grupoEmpresa);
        if (found != null && found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    public NaturezaRequisicao getFirstOrThrow(Produto produto, Empresa empresa) throws ExceptionParamCtbRequisicao {
        return this.getFirstOrThrow(produto, empresa.getEmpresaDados().getGrupoEmpresa());
    }
}

