/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.necessidadecompra;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AtendPedAlmoxItemGradeNecComp;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoNecessidadeCompraImpl;
import com.touchcomp.basementorservice.helpers.impl.necessidadecomrpas.HelperNecessidadeCompras;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cotacaocompra.ServiceCotacaoCompraImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.ServiceLeadTimeFornProdutoImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.leadtimefornecedor.web.DTOLeadTimeFornProdutoRes;
import com.touchcomp.touchvomodel.vo.necessidadecompra.DTONecessidadeCompraRes;
import com.touchcomp.touchvomodel.vo.necessidadecompra.web.DTONecessidadeCompra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNecessidadeCompraImpl
extends ServiceGenericEntityImpl<NecessidadeCompra, Long, DaoNecessidadeCompraImpl> {
    @Autowired
    private HelperNecessidadeCompras helperNecessidadeCompras;
    @Autowired
    private ServiceLeadTimeFornProdutoImpl serviceLeadTimeFornProduto;
    @Autowired
    private ServiceUsuarioImpl serviceUsuarioImpl;
    @Autowired
    private ServiceEmpresaImpl serviceEmpresaImpl;
    @Autowired
    private ServiceOpcoesCompraSuprimentosImpl serviceOpcoesCompraSuprimentosImpl;
    @Autowired
    private ServiceOpcoesContabeisImpl serviceOpcoesContabeisImpl;
    @Autowired
    private ServiceOpcoesEstoqueImpl serviceOpcoesEstoqueImpl;
    @Autowired
    private ServiceGradeCorImpl serviceGradeCorImpl;

    @Autowired
    public ServiceNecessidadeCompraImpl(DaoNecessidadeCompraImpl dao) {
        super(dao);
    }

    @Override
    public NecessidadeCompra beforeSave(NecessidadeCompra n) {
        if (n != null) {
            if (n.getItemNecCompraDetalhes() != null) {
                for (ItemNecCompraDetalhes in : n.getItemNecCompraDetalhes()) {
                    in.setNecessidadeCompra(n);
                }
            }
            if (n.getAtendPedAlmoxNecCompra() != null) {
                for (AtendPedAlmoxItemGradeNecComp ita : n.getAtendPedAlmoxNecCompra()) {
                    ita.setNecessidadeCompra(n);
                }
            }
            if (n.getEmailGrupoNecCompra() != null) {
                for (EmailGrupoNecCompra e : n.getEmailGrupoNecCompra()) {
                    e.setNecessidadeCompra(n);
                }
            }
            if (n.getLiberacaoNecCompraItem() != null) {
                n.getLiberacaoNecCompraItem().setNecessidadeCompra(n);
            }
        }
        return n;
    }

    public List<DTONecessidadeCompraRes> getNecessidadesCompra(Usuario usuario, Empresa empresa, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        List<Object> necessidades = new LinkedList();
        necessidades = opcoesCompraSuprimentos.getUsarLibNecessidadeCompra() != null && this.isEquals(opcoesCompraSuprimentos.getUsarLibNecessidadeCompra(), EnumConstantsMentorSimNao.SIM.getValue()) ? ((DaoNecessidadeCompraImpl)this.getGenericDao()).findNecessidadesCompraAbertasLiberadas(usuario, empresa, opcoesCompraSuprimentos) : ((DaoNecessidadeCompraImpl)this.getGenericDao()).findNecessidadesCompraAbertas(usuario, empresa, opcoesCompraSuprimentos);
        return this.buildToDTOGeneric(necessidades, DTONecessidadeCompraRes.class);
    }

    public List<HashMap> getListaNecessidadesCompras(List<DTONecessidadeCompraRes> data) {
        ArrayList<HashMap> listNecessidadeCompra = new ArrayList<HashMap>();
        for (DTONecessidadeCompraRes dto : data) {
            NecessidadeCompra necessidadeCompra = (NecessidadeCompra)this.get(dto.getIdentificador());
            if (this.isNull(necessidadeCompra).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1064.001", new Object[]{dto.getIdentificador()}));
            }
            HashMap<String, NecessidadeCompra> h = new HashMap<String, NecessidadeCompra>();
            h.put("necessidade", necessidadeCompra);
            listNecessidadeCompra.add(h);
        }
        return listNecessidadeCompra;
    }

    public void deletarNecessidadesCompra(List<DTONecessidadeCompraRes> data) {
        for (DTONecessidadeCompraRes dto : data) {
            NecessidadeCompra necessidadeCompra = (NecessidadeCompra)this.get(dto.getIdentificador());
            if (this.isNull(necessidadeCompra).booleanValue()) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1064.001", new Object[]{dto.getIdentificador()}));
            }
            this.deleteById(new Long[]{dto.getIdentificador()});
        }
    }

    public List getAtendPedAlmox(NecessidadeCompra necessidadeCompra) {
        return ((DaoNecessidadeCompraImpl)this.getGenericDao()).getAtendPedAlmox(necessidadeCompra);
    }

    public List<NecessidadeCompra> getNecessidadesByItemCotacao(Long identificadorItem) {
        return ((DaoNecessidadeCompraImpl)this.getGenericDao()).getNecessidadesByItemCotacao(identificadorItem);
    }

    public List<NecessidadeCompra> getNecessidadesCompraNaoLiberadas(Date dataInicial, Date dataFinal, Empresa empresa, Short filtrarGrupoNecessidadeCompra, GrupoNecCompra grupoNecessidadeCompra, Short filtrarUsuarioSolicitante, Usuario usuarioSolicitante, Short filtrarCentroCusto, CentroCusto centroCusto, Usuario usuarioLiberacao) {
        return this.getNecessidadesCompraNaoLiberadas(dataInicial, dataFinal, this.isNotNull(empresa) != false ? empresa.getIdentificador() : null, filtrarGrupoNecessidadeCompra, this.isNotNull(grupoNecessidadeCompra) != false ? grupoNecessidadeCompra.getIdentificador() : null, filtrarUsuarioSolicitante, this.isNotNull(usuarioSolicitante) != false ? usuarioSolicitante.getIdentificador() : null, filtrarCentroCusto, this.isNotNull(centroCusto) != false ? centroCusto.getIdentificador() : null, this.isNotNull(usuarioLiberacao) != false ? usuarioLiberacao.getIdentificador() : null);
    }

    public List<NecessidadeCompra> getNecessidadesCompraNaoLiberadas(Date dataInicial, Date dataFinal, Long idEmpresa, Short filtrarGrupoNecessidadeCompra, Long idGrupoNecessidadeCompra, Short filtrarUsuarioSolicitante, Long idUsuarioSolicitante, Short filtrarCentroCusto, Long idCentroCusto, Long idUsuarioLiberacao) {
        return ((DaoNecessidadeCompraImpl)this.getGenericDao()).getNecessidadesCompraNaoLiberadas(dataInicial, dataFinal, idEmpresa, filtrarGrupoNecessidadeCompra, idGrupoNecessidadeCompra, filtrarUsuarioSolicitante, idUsuarioSolicitante, filtrarCentroCusto, idCentroCusto, idUsuarioLiberacao);
    }

    public void desativarNecessidadesCompras(List<NecessidadeCompra> listNecessidadeCompra, String motivoDesativacao, SituacaoNecessidadeCompra situacaoNecessidadeCompra) {
        for (NecessidadeCompra necessidadeCompra : listNecessidadeCompra) {
            this.desativarNecessidadeCompra(necessidadeCompra, motivoDesativacao, situacaoNecessidadeCompra);
        }
    }

    public void desativarNecessidadeCompra(NecessidadeCompra necessidadeCompra, String motivoDesativacao, SituacaoNecessidadeCompra situacaoNecessidadeCompra) {
        necessidadeCompra.setDesativarNecessidade(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        necessidadeCompra.setMotivoDesativacao(motivoDesativacao);
        necessidadeCompra.setSituacaoNecessidadeCompra(situacaoNecessidadeCompra);
        ((DaoNecessidadeCompraImpl)this.getDao()).saveOrUpdate(necessidadeCompra);
    }

    public CotacaoCompra gerarCotacao(Long[] idNecessidades, List<DTOLeadTimeFornProdutoRes> leadTimes, CapsUsuario capsUsuario, CapsEmpresa capsEmpresa) throws Exception {
        List necessidades = this.gets(idNecessidades);
        if (TMethods.isWithData((Collection)necessidades)) {
            Usuario usuario = (Usuario)this.serviceUsuarioImpl.getOrThrow(capsUsuario.get());
            Empresa empresa = (Empresa)this.serviceEmpresaImpl.getOrThrow(capsEmpresa.get());
            OpcoesCompraSuprimentos opcoesCompraSup = this.serviceOpcoesCompraSuprimentosImpl.getByIdEmpresa(capsEmpresa.get());
            OpcoesContabeis opcoesContabeis = this.serviceOpcoesContabeisImpl.getByIdEmpresa(capsEmpresa.get());
            OpcoesEstoque opcoesEstoque = this.serviceOpcoesEstoqueImpl.getByIdEmpresa(capsEmpresa.get());
            ServiceCotacaoCompraImpl serviceCotacaoCompra = (ServiceCotacaoCompraImpl)ConfApplicationContext.getBean(ServiceCotacaoCompraImpl.class);
            CotacaoCompra cotacaoCompra = this.helperNecessidadeCompras.gerarCotacaoCompraFromNecessidade(necessidades, this.buildParamLeadTimes(leadTimes), usuario, empresa, opcoesCompraSup, opcoesContabeis, opcoesEstoque);
            return serviceCotacaoCompra.saveOrUpdate(cotacaoCompra);
        }
        return null;
    }

    private List<HashMap> buildParamLeadTimes(List<DTOLeadTimeFornProdutoRes> leadTimes) throws ExceptionObjNotFound {
        LinkedList<HashMap> ret = new LinkedList<HashMap>();
        if (TMethods.isWithData(leadTimes)) {
            for (DTOLeadTimeFornProdutoRes dto : leadTimes) {
                LeadTimeFornProduto lead = (LeadTimeFornProduto)this.serviceLeadTimeFornProduto.getOrThrow(dto.getIdentificador());
                if (!this.verificarExisteLead(lead, ret)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("LEAD_TIME", lead);
                map.put("COTAR", dto.getCotar());
                ret.add(map);
            }
        }
        return ret;
    }

    private boolean verificarExisteLead(LeadTimeFornProduto lead, List<HashMap> ret) {
        for (HashMap h : ret) {
            if (!this.isEquals(((LeadTimeFornProduto)h.get("LEAD_TIME")).getLeadTimeFornecedor().getUnidadeFatFornecedor(), lead.getLeadTimeFornecedor().getUnidadeFatFornecedor())) continue;
            return false;
        }
        return true;
    }

    public Double findSaldoCompraAbertoGradeCor(GradeCor gradeCor) {
        return ((DaoNecessidadeCompraImpl)this.getGenericDao()).findSaldoCompraAbertoGradeCor(gradeCor);
    }

    public List<DTONecessidadeCompra> pesqusarNecessidadeCompra(Long idGradeProduto, Class<DTONecessidadeCompra> aClass) throws ExceptionObjNotFound {
        List<Object> listNecessidadeCompra = new ArrayList();
        GradeCor gradeCor = (GradeCor)this.serviceGradeCorImpl.getOrThrow(idGradeProduto);
        if (this.isNotNull(gradeCor).booleanValue()) {
            listNecessidadeCompra = ((DaoNecessidadeCompraImpl)this.getGenericDao()).pesqusarNecessidadeCompra(gradeCor);
        }
        return this.buildToDTO(listNecessidadeCompra, aClass);
    }
}

