/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfce;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FinalidadeEmNFe;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeCaixa;
import com.touchcomp.basementor.model.vo.NFCeCancelamento;
import com.touchcomp.basementor.model.vo.NFCeChequeTerceiros;
import com.touchcomp.basementor.model.vo.NFCeConsumidor;
import com.touchcomp.basementor.model.vo.NFCeEnderecoEntrega;
import com.touchcomp.basementor.model.vo.NFCeLoteNotas;
import com.touchcomp.basementor.model.vo.NFCeObsContrib;
import com.touchcomp.basementor.model.vo.NFCeObsFisco;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.NFCePessoa;
import com.touchcomp.basementor.model.vo.NFCeTitulo;
import com.touchcomp.basementor.model.vo.NFCeTotalizadores;
import com.touchcomp.basementor.model.vo.NFCeTransp;
import com.touchcomp.basementor.model.vo.NFCeVolume;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VersaoNFe;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNFCe;
import com.touchcomp.basementorservice.helpers.impl.nfce.HelperCancelaDenegaNFCe;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.bandeiracartaonfe.ServiceBandeiraCartaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.bandeiratef.ServiceBandeiraTEFImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.embalagem.ServiceEmbalagemImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.finalidademnfe.ServiceFinalidadeEmNFeImpl;
import com.touchcomp.basementorservice.service.impl.inutilizacaonumeracaonfe.ServiceInutilizacaoNumeracaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.modelodocfiscal.ServiceModeloDocFiscalImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImpl;
import com.touchcomp.basementorservice.service.impl.nfce.auxiliar.v8.AuxItensNFCeV8;
import com.touchcomp.basementorservice.service.impl.nfce.auxiliar.v8.AuxPagamentosNFCeV8;
import com.touchcomp.basementorservice.service.impl.nfcecaixa.ServiceNFCeCaixaImpl;
import com.touchcomp.basementorservice.service.impl.nfcecontrolecaixa.ServiceNFCeControleCaixaImpl;
import com.touchcomp.basementorservice.service.impl.nfceperiodoemissao.ServiceNFCePeriodoEmissaoImpl;
import com.touchcomp.basementorservice.service.impl.objectobsdinamica.ServiceObjectObsDinamicaImpl;
import com.touchcomp.basementorservice.service.impl.obsfaturamento.ServiceObsFaturamentoImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.periodoemissaonfe.ServicePeriodoEmissaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorservice.service.impl.tipoemissaonfe.ServiceTipoEmissaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.tipofrete.ServiceTipoFreteImpl;
import com.touchcomp.basementorservice.service.impl.tipopagamentonfe.ServiceTipoPagamentoNFeImpl;
import com.touchcomp.basementorservice.service.impl.transportador.ServiceTransportadorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatcliente.ServiceUnidadeFatClienteImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementorservice.service.impl.versaonfe.ServiceVersaoNFeImpl;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNFCe;
import com.touchcomp.basementorxml.service.impl.xmlnfce.ServiceXMLNFCeImpl;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeCancelamento;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeChequeTerceiros;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeConsumidor;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeEnderecoEntrega;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeInutilizacao;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeLoteNotas;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeObsContrib;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeObsFisco;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCePagamento;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCePessoa;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeTitulo;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeTotalizadores;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeTransp;
import com.touchcomp.touchvomodel.vo.nfce.v7.DTONFCeV7;
import com.touchcomp.touchvomodel.vo.nfce.v7.DTONFeVolumeV7;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildNFCeV8
extends ServiceGenericImpl {
    @Autowired
    ServiceNFCeImpl serviceNFce;
    @Autowired
    ServiceFinalidadeEmNFeImpl serviceFinalidadeEmNFeImpl;
    @Autowired
    ServiceEmpresaImpl serviceEmpresa;
    @Autowired
    ServiceCondicoesPagamentoImpl serviceCondicoes;
    @Autowired
    ServiceModeloDocFiscalImpl serviceModeloDocFiscal;
    @Autowired
    ServiceNaturezaOperacaoImpl serviceNatureza;
    @Autowired
    ServicePessoaImpl servicePessoa;
    @Autowired
    ServicePedidoImpl servicePedido;
    @Autowired
    ServicePeriodoEmissaoNFeImpl servicePeriodoEmissaoNFe;
    @Autowired
    ServiceNFCePeriodoEmissaoImpl servicePeriodoEmissaoNFCe;
    @Autowired
    ServiceNFCeCaixaImpl serviceNFCeCaixa;
    @Autowired
    ServiceNFCeControleCaixaImpl serviceNFCeControleCaixa;
    @Autowired
    ServiceSituacaoDocumentoImpl serviceSituacaoDoc;
    @Autowired
    ServiceUnidadeFatClienteImpl serviceUnidade;
    @Autowired
    ServiceRepresentanteImpl serviceRepresentante;
    @Autowired
    ServiceInutilizacaoNumeracaoNFeImpl serviceInutilizacao;
    @Autowired
    ServiceTipoEmissaoNFeImpl serviceTipoEmissao;
    @Autowired
    ServiceVersaoNFeImpl serviceVersao;
    @Autowired
    ServiceEmbalagemImpl serviceEmbalagemImpl;
    @Autowired
    ServiceCidadeImpl serviceCidadeImpl;
    @Autowired
    ServiceTipoFreteImpl serviceTipoFrete;
    @Autowired
    ServiceTransportadorImpl serviceTransportador;
    @Autowired
    ServiceUnidadeFederativaImpl serviceUf;
    @Autowired
    ServiceTipoPagamentoNFeImpl serviceTipoPag;
    @Autowired
    ServiceMeioPagamentoImpl serviceMeioPag;
    @Autowired
    ServiceBandeiraTEFImpl serviceBandeira;
    @Autowired
    ServiceBandeiraCartaoNFeImpl serviceBandeiraCartao;
    @Autowired
    ServiceObjectObsDinamicaImpl serviceObsObject;
    @Autowired
    ServiceObsFaturamentoImpl serviceObsFat;
    @Autowired
    InterfaceStaticObjects sharedData;
    @Autowired
    private ServiceXMLNFCeImpl serviceXMLNFCeImpl;

    public List<PackObjectsSinc> saveNFe(String data) throws ExceptionBase {
        List liberacoes = ToolJson.readJsonList((String)data, DTONFCeV7.class);
        List<PackObjectsSinc> ret = this.sincronizaNFe(liberacoes);
        return ret;
    }

    public List<PackObjectsSinc> sincronizaNFe(List<DTONFCeV7> listNfce) throws ExceptionParametrizacao, ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        ArrayList<NFCe> toSave = new ArrayList<NFCe>();
        ArrayList<NFCe> all = new ArrayList<NFCe>();
        for (DTONFCeV7 dtoNFCe : listNfce) {
            NFCe nota = this.criarNFCe(dtoNFCe);
            if (EnumConstNFeStatus.isStatusCancelada((Integer)nota.getStatus())) {
                this.cancelarNotaFiscal(nota);
            } else if (EnumConstNFeStatus.isStatusDenegada((Integer)nota.getStatus())) {
                this.denegarNotaFiscal(nota);
            } else if (EnumConstNFeStatus.isStatusInutilizada((Integer)nota.getStatus()) || nota.getInutilizacaoNFe() != null && EnumConstNFeStatus.isStatusInutilizada((String)nota.getInutilizacaoNFe().getStatus())) {
                this.inutilizarNotaFiscal(nota);
            } else {
                this.getPagamentosNFCe(nota, dtoNFCe);
                nota = this.serviceNFce.saveOrUpdate(nota);
                toSave.add(nota);
            }
            all.add(nota);
        }
        this.gerarXMLNFCe(toSave, listNfce);
        List<PackObjectsSinc> temp = this.toPackObjectSinc(all);
        return temp;
    }

    protected List<PackObjectsSinc> toPackObjectSinc(List<NFCe> aux) {
        LinkedList<PackObjectsSinc> ret = new LinkedList<PackObjectsSinc>();
        for (NFCe a : aux) {
            PackObjectsSinc p = new PackObjectsSinc();
            p.setIdObjectMentor(a.getIdentificador());
            p.setStatus(Short.valueOf((short)1));
            p.setSerialObjetoOrigem(a.getSerialForSinc());
            ret.add(p);
        }
        return ret;
    }

    private void gerarXMLNFCe(List<NFCe> toSave, List<DTONFCeV7> listNfce) {
        for (NFCe nf : toSave) {
            String xml = null;
            String xmlAutorizacao = null;
            for (DTONFCeV7 nfce : listNfce) {
                if (!ToolMethods.isEquals((Object)nf.getSerialForSinc(), (Object)nfce.getSerialForSinc())) continue;
                if (nfce.getXml() != null) {
                    xml = new String(nfce.getXml());
                }
                if (nfce.getXmlAutorizacao() == null) break;
                xmlAutorizacao = new String(nfce.getXmlAutorizacao());
                break;
            }
            if (xml == null && xmlAutorizacao == null) continue;
            XMLNFCe x = this.serviceXMLNFCeImpl.getOrCreateXMLNFCe(nf.getIdentificador());
            x.setIdNFCe(nf.getIdentificador());
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            sb.append(xml);
            x.setConteudoXML(sb.toString());
            this.serviceXMLNFCeImpl.saveOrUpdate((Object)x);
        }
    }

    private NFCe criarNFCe(DTONFCeV7 dto) throws ExceptionObjectNotFound, ExceptionTitulo {
        NFCe n = this.getNFCe(dto);
        if (n == null) {
            n = new NFCe();
            n.setSerialForSinc(dto.getSerialForSinc());
        }
        n.setStatus(dto.getStatus());
        n.setSituacaoDocumento(this.serviceSituacaoDoc.getByCodigo(n.getStatus()));
        n.setAmbiente(dto.getAmbiente());
        n.setChaveNFCe(dto.getChaveNFCe());
        n.setCodigoCSCContribuinte(dto.getCodigoCSCContribuinte());
        n.setDadosTransporte(this.getDadosTransporte(dto.getDadosTransporte(), n));
        n.setDataAutorizacao(dto.getDataAutorizacao());
        n.setDataEmissao(dto.getDataEmissao());
        n.setDataPrevSaida(dto.getDataPrevSaida());
        n.setDigestValue(dto.getDigestValue());
        n.setDigitoVerificador(dto.getDigitoVerificador());
        n.setEmpresa((Empresa)this.serviceEmpresa.get(dto.getEmpresaIdentificador()));
        n.setEnderecoEntrega(this.getEnderecoEntrega(dto.getEnderecoEntrega(), n));
        n.setFinalidadeEmNFe((FinalidadeEmNFe)this.serviceFinalidadeEmNFeImpl.get(dto.getFinalidadeEmNFeIdentificador()));
        if (n.getFinalidadeEmNFe() == null && ToolMethods.isWithData((Number)dto.getFinalidadeEmissao())) {
            n.setFinalidadeEmNFe((FinalidadeEmNFe)this.serviceFinalidadeEmNFeImpl.get(dto.getFinalidadeEmissao().toString()));
        }
        n.setFormatoImpressao(dto.getFormatoImpressao());
        n.setIdentificadorCSCContribuinte(dto.getIdentificadorCSCContribuinte());
        n.setIndicadorConsumidorFinal(dto.getIndicadorConsumidorFinal());
        n.setIndicadorPresencaConsumidor(dto.getIndicadorPresencaConsumidor());
        n.setInutilizacaoNFe(this.getInutilizacaoNFCe(n, dto.getInutilizacaoNFe()));
        this.getItensNFCe(n, dto);
        n.setLoteNotas(this.getLoteNotas(dto.getLoteNotas(), n));
        n.setModeloDocFiscal((ModeloDocFiscal)this.serviceModeloDocFiscal.get(dto.getModeloDocFiscalIdentificador()));
        n.setMotivo(dto.getMotivo());
        n.setNaturezaOperacao((NaturezaOperacao)this.serviceNatureza.get(dto.getNaturezaOperacaoIdentificador()));
        n.setNfCeCaixa((NFCeCaixa)this.serviceNFCeCaixa.get(dto.getNfCeCaixaIdentificador()));
        n.setNfCeCancelamento(this.getNFCeCancelamento(dto.getNfCeCancelamento(), n));
        n.setNfCeConsumidor(this.getNFCeConsumidor(dto.getNfCeConsumidor()));
        n.setNfCeControleCaixa(this.serviceNFCeControleCaixa.getBySerial(dto.getNfCeControleCaixaSerialForSinc()));
        n.setNfceCancelamentoAnterior(this.getCancelamentoAnterior(dto.getNfceCancelamentoAnterior(), n));
        n.setNfcePessoa(this.getNFCePessoa(dto.getNfcePessoa(), n));
        n.setNrProtocolo(dto.getNrProtocolo());
        n.setNumero(dto.getNumero());
        n.setNumeroRandomico(dto.getNumeroRandomico());
        n.setObjObsGeralContrib((ObjectObsDinamica)this.serviceObsObject.get(dto.getObjObsGeralContribIdentificador()));
        n.setObjObsGeralFisco((ObjectObsDinamica)this.serviceObsObject.get(dto.getObjObsGeralFiscoIdentificador()));
        n.setObsGeralContrib(dto.getObsGeralContrib());
        n.setObsGeralFisco(dto.getObsGeralFisco());
        this.getObsContrib(dto.getObsContribuinte(), n);
        this.getObsFisco(dto.getObsFisco(), n);
        n.setPedido(this.servicePedido.getBySerialForSync(dto.getPedidoSerialForSync()));
        n.setPeriodoEmissaoNFCe(this.servicePeriodoEmissaoNFCe.getBySerial(dto.getPeriodoEmissaoNFCeSerialForSinc()));
        n.setPeriodoEmissaoNFe(this.getPeriodoEmissaoNFe(dto, n));
        n.setPessoaAutorizada((Pessoa)this.servicePessoa.get(dto.getPessoaAutorizadaIdentificador()));
        n.setRepresentante((Representante)this.serviceRepresentante.get(dto.getRepresentanteIdentificador()));
        n.setSerie(dto.getSerie());
        n.setTipoAmbiente(dto.getTipoAmbiente());
        n.setTipoEmissao(dto.getTipoEmissao());
        n.setTipoEntSai(dto.getTipoEntSai());
        n.setTotalizadores(this.getTotalizadores(n, dto));
        n.setUnidadeFatCliente((UnidadeFatCliente)this.serviceUnidade.get(dto.getUnidadeFatClienteIdentificador()));
        if (n.getUnidadeFatCliente() != null) {
            n.setCategoriaPessoa(n.getUnidadeFatCliente().getCategoriaPessoa());
            n.setClassificacaoCliente(n.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        }
        n.setUrlConsulta(dto.getUrlConsulta());
        n.setUrlQrCode(dto.getUrlQrCode());
        n.setVersaoAplicativo(dto.getVersaoAplicativo());
        n.setVersaoNfe((VersaoNFe)this.serviceVersao.get(dto.getVersaoNfeIdentificador()));
        n.setVolumes(this.getVolumes(n, dto));
        this.getLivrosFiscais(n);
        return n;
    }

    private NFCe getNFCe(DTONFCeV7 dtoNFCe) {
        NFCe nfce = this.serviceNFce.getBySerial(dtoNFCe.getSerialForSinc());
        if (nfce == null) {
            nfce = this.serviceNFce.get(dtoNFCe.getNumero(), dtoNFCe.getSerie(), dtoNFCe.getModeloDocFiscalIdentificador(), dtoNFCe.getEmpresaIdentificador());
        }
        return nfce;
    }

    private NFCeConsumidor getNFCeConsumidor(DTONFCeConsumidor nfCeConsumidor) {
        if (nfCeConsumidor == null) {
            return null;
        }
        NFCeConsumidor n = new NFCeConsumidor();
        n.setCpfCnpj(nfCeConsumidor.getCpfCnpj());
        n.setEmail(nfCeConsumidor.getEmail());
        n.setNome(nfCeConsumidor.getNome());
        n.setPassaporte(nfCeConsumidor.getPassaporte());
        return n;
    }

    private InutilizacaoNumeracaoNFe getInutilizacaoNFCe(NFCe n, DTONFCeInutilizacao inutilizacaoNFe) {
        if (inutilizacaoNFe == null) {
            return null;
        }
        InutilizacaoNumeracaoNFe in = n.getInutilizacaoNFe();
        if (in == null) {
            in = this.serviceInutilizacao.getBySerial(inutilizacaoNFe.getSerialForSinc());
        }
        if (in == null) {
            in = new InutilizacaoNumeracaoNFe();
        }
        in.setChaveID(inutilizacaoNFe.getChaveID());
        in.setConteudoEnviado(inutilizacaoNFe.getConteudoEnviado());
        in.setConteudoInutilizacao(inutilizacaoNFe.getConteudoInutilizacao());
        in.setDataCadastro(inutilizacaoNFe.getDataCadastro());
        in.setEmpresa(n.getEmpresa());
        in.setEnviado(inutilizacaoNFe.getEnviado());
        in.setJustificativa(inutilizacaoNFe.getJustificativa());
        in.setModeloDocFiscal(n.getModeloDocFiscal());
        in.setMotivo(inutilizacaoNFe.getMotivo());
        in.setNfce(n);
        in.setNumProtocolo(inutilizacaoNFe.getNumProtocolo());
        in.setNumeroFinal(inutilizacaoNFe.getNumeroFinal());
        in.setNumeroInicial(inutilizacaoNFe.getNumeroInicial());
        in.setPeriodo(inutilizacaoNFe.getPeriodo());
        in.setSerialForSinc(inutilizacaoNFe.getSerialForSinc());
        in.setSerie(inutilizacaoNFe.getSerie());
        in.setStatus(inutilizacaoNFe.getStatus());
        in.setTipoEmissaoNFe((TipoEmissaoNFe)this.serviceTipoEmissao.get(inutilizacaoNFe.getTipoEmissaoNFeIdentificador()));
        return in;
    }

    private List<NFCeVolume> getVolumes(NFCe n, DTONFCeV7 dto) {
        List aux = n.getVolumes();
        aux.clear();
        for (DTONFeVolumeV7 vol : dto.getVolumes()) {
            NFCeVolume nv = new NFCeVolume();
            nv.setEmbalagem((Embalagem)this.serviceEmbalagemImpl.get(vol.getEmbalagemIdentificador()));
            nv.setMarca(vol.getMarca());
            nv.setNfCe(n);
            nv.setNumeroVolume(vol.getNumeroVolume());
            nv.setPesoBruto(vol.getPesoBruto());
            nv.setPesoLiquido(vol.getPesoLiquido());
            nv.setQuantidade(vol.getQuantidade());
            nv.setSerialForSinc(vol.getSerialForSinc());
            aux.add(nv);
        }
        return aux;
    }

    private NFCeTotalizadores getTotalizadores(NFCe n, DTONFCeV7 dtoNFCe) {
        DTONFCeTotalizadores dto = dtoNFCe.getTotalizadores();
        NFCeTotalizadores nt = n.getTotalizadores();
        if (nt == null) {
            nt = new NFCeTotalizadores();
            nt.setNFCe(n);
        }
        nt.setBaseCalculoICMS(dto.getBaseCalculoICMS());
        nt.setBaseCalculoICMSST(dto.getBaseCalculoICMSST());
        nt.setPercDescontoInf(dto.getPercDescontoInf());
        nt.setPercDescontoTotal(dto.getPercDescontoTotal());
        nt.setPercDespAcessInf(dto.getPercDespAcessInf());
        nt.setPercDespAcessTotal(dto.getPercDespAcessTotal());
        nt.setPercFreteInf(dto.getPercFreteInf());
        nt.setPercFreteTotal(dto.getPercFreteTotal());
        nt.setPercSeguroInf(dto.getPercSeguroInf());
        nt.setPercSeguroTotal(dto.getPercSeguroTotal());
        nt.setPercValorDesconto(dto.getPercValorDesconto());
        nt.setPercValorDespAcess(dto.getPercValorDespAcess());
        nt.setPercValorFrete(dto.getPercValorFrete());
        nt.setPercValorSeguro(dto.getPercValorSeguro());
        nt.setValorDescontoInf(dto.getValorDescontoInf());
        nt.setValorDespAcessoriasInf(dto.getValorDespAcessoriasInf());
        nt.setValorFreteInf(dto.getValorFreteInf());
        nt.setValorSeguroInf(dto.getValorSeguroInf());
        nt.setValorICMSDesonerado(dto.getValorICMSDesonerado());
        nt.setValorICMSFundoCombatePobreza(dto.getValorICMSFundoCombatePobreza());
        nt.setValorTotalBruto(dto.getValorTotalBruto());
        nt.setValorTotalCOFINS(dto.getValorTotalCOFINS());
        nt.setValorTotalDesconto(dto.getValorTotalDesconto());
        nt.setValorTotalDespAcessorias(dto.getValorTotalDespAcessorias());
        nt.setValorTotalFrete(dto.getValorTotalFrete());
        nt.setValorTotalSeguro(dto.getValorTotalSeguro());
        nt.setValorTotalDosProdutosServicos(dto.getValorTotalDosProdutosServicos());
        nt.setValorTotalFundoCombatePobreza(dto.getValorTotalFundoCombatePobreza());
        nt.setValorTotalFundoCombatePobrezaST(dto.getValorTotalFundoCombatePobrezaST());
        nt.setValorTotalFundoCombatePobrezaSTRetido(dto.getValorTotalFundoCombatePobrezaSTRetido());
        nt.setValorTotalICMS(dto.getValorTotalICMS());
        nt.setValorTotalICMSST(dto.getValorTotalICMSST());
        nt.setValorTotalII(dto.getValorTotalII());
        nt.setValorTotalIPI(dto.getValorTotalIPI());
        nt.setValorTotalIPIDevolvido(dto.getValorTotalIPIDevolvido());
        nt.setValorTotalNFe(dto.getValorTotalNFe());
        nt.setValorTotalPIS(dto.getValorTotalPIS());
        nt.setValorTotalTributos(dto.getValorTotalTributos());
        return nt;
    }

    private NFCeEnderecoEntrega getEnderecoEntrega(DTONFCeEnderecoEntrega enderecoEntrega, NFCe nfce) {
        if (enderecoEntrega == null) {
            return null;
        }
        NFCeEnderecoEntrega end = nfce.getEnderecoEntrega();
        if (end == null) {
            end = new NFCeEnderecoEntrega();
        }
        end.setBairro(enderecoEntrega.getBairro());
        end.setCep(enderecoEntrega.getBairro());
        end.setCidade((Cidade)this.serviceCidadeImpl.get(enderecoEntrega.getCidadeIdentificador()));
        end.setComplemento(enderecoEntrega.getComplemento());
        end.setCpfCnpj(enderecoEntrega.getCpfCnpj());
        end.setLogradouro(enderecoEntrega.getLogradouro());
        end.setNfce(nfce);
        end.setNomePessoaResp(enderecoEntrega.getNomePessoaResp());
        end.setNumero(enderecoEntrega.getNumero());
        end.setObservacao(enderecoEntrega.getObservacao());
        end.setReferencia(enderecoEntrega.getReferencia());
        return end;
    }

    private NFCeTransp getDadosTransporte(DTONFCeTransp dt, NFCe nfce) {
        if (dt == null) {
            return null;
        }
        NFCeTransp t = nfce.getDadosTransporte();
        if (t == null) {
            t = new NFCeTransp();
        }
        t.setNfce(nfce);
        t.setPlacaVeiculo(dt.getPlacaVeiculo());
        t.setRegistroANTTVeiculo(dt.getRegistroANTTVeiculo());
        t.setTipoFrete((TipoFrete)this.serviceTipoFrete.get(dt.getTipoFreteIdentificador()));
        t.setTransportador((Transportador)this.serviceTransportador.get(dt.getTransportadorIdentificador()));
        t.setUfVeiculo((UnidadeFederativa)this.serviceUf.get(dt.getUfVeiculoIdentificador()));
        t.setValorFrete(dt.getValorFrete());
        return t;
    }

    private NFCeLoteNotas getLoteNotas(DTONFCeLoteNotas dto, NFCe n) {
        if (dto == null) {
            return null;
        }
        if (n.getIdentificador() != null && n.getIdentificador() > 0L && n.getLoteNotas() == null) {
            return null;
        }
        NFCeLoteNotas t = n.getLoteNotas();
        if (t == null) {
            t = new NFCeLoteNotas();
        }
        t.setDataCadastro(dto.getDataCadastro());
        t.setDataRecepcao(dto.getDataRecepcao());
        t.setNumeroProtocolo(dto.getNumeroProtocolo());
        t.setRetorno(dto.getRetorno());
        t.setStatus(dto.getStatus());
        t.setTipoAmbiente(dto.getTipoAmbiente());
        t.setVersaoNFe((VersaoNFe)this.serviceVersao.get(dto.getVersaoNFeIdentificador()));
        return t;
    }

    private NFCeCancelamento getNFCeCancelamento(DTONFCeCancelamento dto, NFCe n) {
        if (dto == null) {
            return null;
        }
        NFCeCancelamento t = n.getNfCeCancelamento();
        if (t == null) {
            t = new NFCeCancelamento();
        }
        t.setDataCancelamento(dto.getDataCancelamento());
        t.setJustificativa(dto.getJustificativa());
        t.setMotivo(dto.getMotivo());
        t.setNrProtocoloCancelamento(dto.getNrProtocoloCancelamento());
        t.setStatus(dto.getStatus());
        return t;
    }

    private NFCeCancelamento getCancelamentoAnterior(DTONFCeCancelamento dto, NFCe n) {
        if (dto == null) {
            return null;
        }
        NFCeCancelamento t = n.getNfceCancelamentoAnterior();
        if (t == null) {
            t = new NFCeCancelamento();
        }
        t.setDataCancelamento(dto.getDataCancelamento());
        t.setJustificativa(dto.getJustificativa());
        t.setMotivo(dto.getMotivo());
        t.setNrProtocoloCancelamento(dto.getNrProtocoloCancelamento());
        t.setStatus(dto.getStatus());
        return t;
    }

    private NFCePessoa getNFCePessoa(DTONFCePessoa dto, NFCe n) {
        if (dto == null) {
            return null;
        }
        NFCePessoa t = n.getNfcePessoa();
        if (t == null) {
            t = new NFCePessoa();
        }
        t.setBairro(dto.getBairro());
        t.setCel1(dto.getCel1());
        t.setCel2(dto.getCel2());
        t.setCep(dto.getCep());
        t.setCidade((Cidade)this.serviceCidadeImpl.get(dto.getCidadeIdentificador()));
        t.setComplemento(dto.getComplemento());
        t.setCpfCnpj(dto.getCpfCnpj());
        t.setEmail(dto.getEmail());
        t.setEmpresa(n.getEmpresa());
        t.setFone1(dto.getFone1());
        t.setFone2(dto.getFone2());
        t.setInscricaoEstadual(dto.getInscricaoEstadual());
        t.setInscricaoMunicipal(dto.getInscricaoMunicipal());
        t.setLogradouro(dto.getLogradouro());
        t.setNome(dto.getNome());
        t.setNomeFantasia(dto.getNomeFantasia());
        t.setNumero(dto.getNumero());
        t.setObservacao(dto.getObservacao());
        t.setPassaporte(dto.getPassaporte());
        t.setReferencia(dto.getReferencia());
        return t;
    }

    private List<NFCeTitulo> getTitulos(DTONFCePagamento dtoPag, NFCePagamento p) {
        LinkedList<NFCeTitulo> titulos = new LinkedList<NFCeTitulo>();
        if (dtoPag == null) {
            return titulos;
        }
        for (DTONFCeTitulo dto : dtoPag.getTitulos()) {
            NFCeTitulo n = new NFCeTitulo();
            n.setDataCadastro(dto.getDataCadastro());
            n.setDataVencimento(dto.getDataVencimento());
            n.setNfcePagamento(p);
            n.setNumeroParcela(dto.getNumeroParcela());
            n.setSerialForSinc(dto.getSerialForSinc());
            n.setValor(dto.getValor());
            titulos.add(n);
        }
        return titulos;
    }

    private List<NFCeChequeTerceiros> getChequeTerceiros(DTONFCePagamento dto, NFCePagamento p) {
        LinkedList<NFCeChequeTerceiros> cheques = new LinkedList<NFCeChequeTerceiros>();
        if (dto.getChequeTerceiros() == null) {
            return cheques;
        }
        for (DTONFCeChequeTerceiros ch : dto.getChequeTerceiros()) {
            NFCeChequeTerceiros n = new NFCeChequeTerceiros();
            n.setAgencia(ch.getAgencia());
            n.setAgenciaDC(ch.getAgenciaDC());
            n.setBanco(ch.getBanco());
            n.setC1c2c3(ch.getC1c2c3());
            n.setCnpjTitular(ch.getCnpjTitular());
            n.setCodigoCMC(ch.getCodigoCMC());
            n.setContaCorrente(ch.getContaCorrente());
            n.setContaCorrenteDC(ch.getContaCorrenteDC());
            n.setDataBomPara(ch.getDataBomPara());
            n.setDataEntrada(ch.getDataEntrada());
            n.setDataVencimento(ch.getDataVencimento());
            n.setNfcePagamento(p);
            n.setNumero(ch.getNumero());
            n.setSerialForSinc(ch.getSerialForSinc());
            n.setTipoCompensacao(ch.getTipoCompensacao());
            n.setTitular(n.getTitular());
            n.setValor(n.getValor());
            cheques.add(n);
        }
        return cheques;
    }

    private void getObsContrib(List<DTONFCeObsContrib> obsContribuinte, NFCe n) {
        if (obsContribuinte == null) {
            return;
        }
        for (DTONFCeObsContrib dto : obsContribuinte) {
            Boolean achou = false;
            ObsFaturamento obsFat = (ObsFaturamento)this.serviceObsFat.get(dto.getObsFaturamentoIdentificador());
            for (NFCeObsContrib c : n.getObsContribuinte()) {
                if (!ToolMethods.isEquals((Object)obsFat, (Object)c.getObsFaturamento())) continue;
                c.setConteudo(dto.getConteudo());
                achou = true;
            }
            if (achou.booleanValue()) continue;
            NFCeObsContrib ob = new NFCeObsContrib();
            ob.setConteudo(dto.getConteudo());
            ob.setNfce(n);
            ob.setObsFaturamento(obsFat);
            n.getObsContribuinte().add(ob);
        }
    }

    private void getObsFisco(List<DTONFCeObsFisco> obsFisco, NFCe n) {
        if (obsFisco == null) {
            return;
        }
        for (DTONFCeObsFisco dto : obsFisco) {
            Boolean achou = false;
            ObsFaturamento obsFat = (ObsFaturamento)this.serviceObsFat.get(dto.getObsFaturamentoIdentificador());
            for (NFCeObsFisco c : n.getObsFisco()) {
                if (!ToolMethods.isEquals((Object)obsFat, (Object)c.getObsFaturamento())) continue;
                c.setConteudo(dto.getConteudo());
                achou = true;
            }
            if (achou.booleanValue()) continue;
            NFCeObsFisco ob = new NFCeObsFisco();
            ob.setConteudo(dto.getConteudo());
            ob.setNfce(n);
            ob.setObsFaturamento(obsFat);
            n.getObsFisco().add(ob);
        }
    }

    private void getItensNFCe(NFCe n, DTONFCeV7 dto) {
        new AuxItensNFCeV8().setItensNFCe(n, dto);
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoNFe(DTONFCeV7 dto, NFCe nfce) {
        PeriodoEmissaoNFe periodoEmissao = this.servicePeriodoEmissaoNFe.getBySerial(dto.getPeriodoEmissaoNFeSerialForSinc());
        if (periodoEmissao == null) {
            String tipoEmissao = nfce.getChaveNFCe().substring(34, 35);
            periodoEmissao = this.getPeriodoEmissaoNFeFromTipoEmissao(nfce.getEmpresa(), tipoEmissao);
        }
        return periodoEmissao;
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoNFeFromTipoEmissao(Empresa empresa, String tipoEmissao) {
        return this.servicePeriodoEmissaoNFe.findPeriodoEmissaoNFeAtivoFromTipoEmissao(empresa, tipoEmissao);
    }

    private void gerarLivrosFiscais(NFCe n) {
        n.getLivrosFiscais().clear();
        n.setLivrosFiscais(this.getLivrosFiscaisNFCe(n));
    }

    private List<LivroFiscal> getLivrosFiscaisNFCe(NFCe aux) {
        return new CompLivroFiscalNFCe().gerarLivrosFiscais(aux.getModeloDocFiscal(), aux.getSituacaoDocumento(), aux.getDataEmissao(), aux.getEmpresa(), aux.getItens(), aux.getLivrosFiscais());
    }

    private boolean isCrediarioOrBoleto(NFCe aux) {
        for (NFCePagamento pag : aux.getPagamentos()) {
            if (!pag.getStatus().equals((short)1) || !pag.getTipoPagamentoNFe().getCodigo().equals("05") && !pag.getTipoPagamentoNFe().getCodigo().equals("15")) continue;
            return true;
        }
        return false;
    }

    private OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) {
        return this.sharedData.getOpcoesFinanceiras(empresa);
    }

    private OpcoesContabeis getOpcoesContabeis(Empresa empresa) {
        return this.sharedData.getOpcoesContabeis(empresa);
    }

    private NFCeOpcoes getOpcoesNFCe(Empresa empresa) {
        return this.sharedData.getOpcoesNFCe(empresa);
    }

    private List<Titulo> getTituloNFCe(NFCe aux) {
        ArrayList<Titulo> list = new ArrayList<Titulo>();
        for (NFCePagamento p : aux.getPagamentos()) {
            if (p.getTitulosGerados() == null || p.getTitulosGerados().isEmpty()) continue;
            list.addAll(p.getTitulosGerados());
        }
        return list;
    }

    private void getPagamentosNFCe(NFCe n, DTONFCeV7 dto) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        new AuxPagamentosNFCeV8().getPagamentos(dto.getPagamentos(), n, this.getOpcoesFinanceiras(n.getEmpresa()), this.getOpcoesContabeis(n.getEmpresa()), this.getOpcoesNFCe(n.getEmpresa()));
    }

    private void getLivrosFiscais(NFCe n) {
        if (EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)n.getStatus())) {
            this.gerarLivrosFiscais(n);
        } else {
            n.getLivrosFiscais().clear();
        }
    }

    private void cancelarNotaFiscal(NFCe nota) {
        HelperCancelaDenegaNFCe helper = new HelperCancelaDenegaNFCe();
        helper.build(nota).cancelarNotaFiscal(null);
    }

    private void denegarNotaFiscal(NFCe nota) {
        HelperCancelaDenegaNFCe helper = new HelperCancelaDenegaNFCe();
        helper.build(nota).denegarNotaFiscal(null);
    }

    private void inutilizarNotaFiscal(NFCe nota) {
        HelperCancelaDenegaNFCe helper = new HelperCancelaDenegaNFCe();
        helper.build(nota).inutilizarNotaFiscal(null);
    }
}

