/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfce;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosNaoBaixados;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.service.impl.boletotitulo.ServiceBoletoTituloImpl;
import com.touchcomp.basementorservice.service.impl.logtitulos.ServiceLogTituloImpl;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.retornocnab.ServiceItemRetornoCnabImpl;
import com.touchcomp.basementorservice.service.impl.retornocnab.ServiceRetornoCnabCobrancaTitulosNaoBaixadosImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCancelamentoNFCe {
    @Autowired
    ServiceRetornoCnabCobrancaTitulosNaoBaixadosImpl serviceRetCnab;
    @Autowired
    ServiceLogTituloImpl serviceLogTitulos;
    @Autowired
    ServiceItemRetornoCnabImpl serviceItemRetornoCnab;
    @Autowired
    ServiceBoletoTituloImpl serviceBoleto;
    @Autowired
    ServicePedidoImpl servicePedido;
    @Autowired
    ServiceNFCeImpl serviceNotaFiscal;

    public NFCe cancelarDadosNFCe(NFCe nfce, SituacaoPedidos sitCanc) {
        this.cancelarItens(nfce);
        this.cancelarLivrosFiscais(nfce);
        this.cancelarPedido(nfce, sitCanc);
        this.cancelarFinanceiro(nfce);
        nfce = this.serviceNotaFiscal.saveOrUpdate(nfce);
        return nfce;
    }

    public NFCe inutilizarNotaFiscal(NFCe nfce, SituacaoPedidos sitCanc) {
        nfce.getLivrosFiscais().clear();
        this.cancelarPedido(nfce, sitCanc);
        this.cancelarFinanceiro(nfce);
        nfce = this.serviceNotaFiscal.saveOrUpdate(nfce);
        return nfce;
    }

    private void cancelarLogsTitulos(Titulo t) {
        List<LogTitulos> logs = this.serviceLogTitulos.get(t);
        for (LogTitulos l : logs) {
            l.setTitulo(null);
            this.serviceLogTitulos.saveOrUpdateFlush(l);
        }
    }

    private void cancelarRetCnabs(Titulo t) {
        if (!ToolMethods.isWithData((Number)t.getIdentificador())) {
            return;
        }
        List<RetornoCnabCobrancaTitulosNaoBaixados> titNaoBaixadosCnab = this.serviceRetCnab.get(t);
        for (RetornoCnabCobrancaTitulosNaoBaixados r : titNaoBaixadosCnab) {
            this.serviceRetCnab.delete(r);
        }
        List<ItemRetornoCnab> itemRetornoCnab = this.serviceItemRetornoCnab.get(t);
        for (ItemRetornoCnab irc : itemRetornoCnab) {
            this.serviceItemRetornoCnab.delete(irc);
        }
    }

    private void cancelarBoletos(Titulo t) {
        List<BoletoTitulo> boletos = this.serviceBoleto.getBoletos(t);
        for (BoletoTitulo l : boletos) {
            l.setTitulo(null);
            this.serviceBoleto.saveOrUpdate(l);
        }
    }

    private void cancelarPedido(NFCe nfce, SituacaoPedidos sitCanc) {
        if (nfce.getPedido() != null && sitCanc != null) {
            this.servicePedido.atualizaSitPedido(nfce.getPedido(), sitCanc);
        }
    }

    private void cancelarFinanceiro(NFCe nfce) {
        for (NFCePagamento i : nfce.getPagamentos()) {
            for (Titulo t : i.getTitulosGerados()) {
                if (!ToolMethods.isWithData((Number)t.getIdentificador())) continue;
                this.cancelarLogsTitulos(t);
                this.cancelarRetCnabs(t);
                this.cancelarBoletos(t);
            }
        }
        nfce.getPagamentos().clear();
    }

    private void cancelarLivrosFiscais(NFCe nfce) {
        for (LivroFiscal lv : nfce.getLivrosFiscais()) {
            lv.setCancelado(Short.valueOf((short)1));
        }
    }

    private void cancelarItens(NFCe nfce) {
        for (NFCeItem i : nfce.getItens()) {
            i.setMovimentacaoFisica(Short.valueOf((short)0));
            i.setStatus(Short.valueOf((short)0));
        }
    }
}

