/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfce;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeChequeTerceiros;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.components.livrofiscal.impl.CompLivroFiscalNFCe;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoNFCeImpl;
import com.touchcomp.basementorservice.helpers.impl.nfce.HelperNFCeItem;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.converters.DTONFCeControleCaixaConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePeriodoEmissaoConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePeriodoEmissaoNFeConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePreAbastecimentoConverter;
import com.touchcomp.basementorservice.service.converters.DTOPedidoPreVendaConverter;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.periodoemissaonfe.ServicePeriodoEmissaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNFCe;
import com.touchcomp.basementorxml.service.impl.xmlnfce.ServiceXMLNFCeImpl;
import com.touchcomp.touchvomodel.vo.nfce.v10.DTONFCeV10;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNFCeImplV10
extends ServiceGenericEntityImpl<NFCe, Long, DaoNFCeImpl> {
    @Autowired
    private DTONFCePeriodoEmissaoConverter periodoEmissaoConverter;
    @Autowired
    private DTONFCePeriodoEmissaoNFeConverter periodoEmissaoNFeConverter;
    @Autowired
    private DTONFCeControleCaixaConverter controleCaixaConverter;
    @Autowired
    private DTONFCePreAbastecimentoConverter preAbastecimento;
    @Autowired
    private DTOPedidoPreVendaConverter pedidoPreVenda;
    @Autowired
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao;
    @Autowired
    private ServiceModeloFiscalImpl serviceModeloFiscal;
    @Autowired
    private ServicePeriodoEmissaoNFeImpl servicePeriodoEmissaoNFe;
    @Autowired
    private ServiceXMLNFCeImpl serviceXMLNFCeImpl;
    @Autowired
    InterfaceStaticObjects sharedData;
    @Autowired
    private SCompPlanoConta scPlanoConta;

    public ServiceNFCeImplV10(DaoNFCeImpl repository) {
        super(repository);
    }

    public NFCe getBySerial(String serialForSinc) {
        return this.getRepository().getBySerialForSinc(serialForSinc);
    }

    public DaoNFCeImpl getRepository() {
        return (DaoNFCeImpl)super.getGenericDao();
    }

    @Override
    public NFCe getObjectIfExists(Object aux) {
        if (ToolMethods.isEquals((Object)aux, null)) {
            return null;
        }
        DTONFCeV10 dtoNFCe = (DTONFCeV10)aux;
        NFCe nfce = this.getBySerial(dtoNFCe.getSerialForSinc());
        if (nfce == null) {
            nfce = this.getRepository().get(dtoNFCe.getNumero(), dtoNFCe.getSerie(), dtoNFCe.getModeloDocFiscalIdentificador(), dtoNFCe.getEmpresaIdentificador());
        }
        return nfce;
    }

    @Override
    public NFCe beforeSave(NFCe aux) {
        if (aux.getPeriodoEmissaoNFe() == null) {
            String tipoEmissao = aux.getChaveNFCe().substring(34, 35);
            aux.setPeriodoEmissaoNFe(this.getPeriodoEmissaoNFeFromTipoEmissao(aux.getEmpresa(), tipoEmissao));
        }
        aux.setSituacaoDocumento(this.getBean(ServiceSituacaoDocumentoImpl.class).getByCodigo(aux.getStatus()));
        aux.getItens().forEach(a -> {
            a.setNfce(aux);
            a.setDataEmissao(aux.getDataEmissao());
            a.setEmpresa(aux.getEmpresa());
            a.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(a.getProduto()));
            a.setMovimentacaoFisica(Short.valueOf(EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)a.getNfce().getStatus()) ? this.serviceModeloFiscal.movimentacaoFisicaByModelo(a.getModeloFiscal().getIdentificador()) : (short)0));
            if (!ToolMethods.isAffirmative((Number)a.getStatus())) {
                a.setMovimentacaoFisica(Short.valueOf((short)0));
            }
            new HelperNFCeItem((NFCeItem)a).setNatReceitaPisCofins();
            System.out.println("Item " + a.getNumeroItem() + ":" + a.getQuantidadeComercial() + ", " + a.getValorUnitarioComercial());
        });
        for (NFCePagamento a2 : aux.getPagamentos()) {
            a2.setNfce(aux);
            for (NFCeChequeTerceiros c2 : a2.getChequeTerceiros()) {
                c2.setNfcePagamento(a2);
                if (c2.getChequeTerceiros() == null) continue;
                c2.getChequeTerceiros().setRepresentante(aux.getRepresentante());
                if (aux.getUnidadeFatCliente() == null) continue;
                c2.getChequeTerceiros().setPessoa(aux.getUnidadeFatCliente().getPessoa());
            }
            a2.getTitulos().forEach(c -> c.setNfcePagamento(a2));
        }
        aux.getLiberacoes().forEach(a -> a.setNfce(aux));
        aux.getObsFisco().forEach(a -> a.setNfce(aux));
        aux.getObsContribuinte().forEach(a -> a.setNfce(aux));
        if (aux.getInutilizacaoNFe() != null && aux.getInutilizacaoNFe().getEmpresa() != null) {
            aux.getInutilizacaoNFe().setNfce(aux);
        } else {
            aux.setInutilizacaoNFe(null);
        }
        aux.getVolumes().forEach(i -> i.setNfCe(aux));
        if (aux.getUnidadeFatCliente() != null) {
            aux.setClassificacaoCliente(aux.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            aux.setCategoriaPessoa(aux.getUnidadeFatCliente().getCategoriaPessoa());
        }
        if (EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)aux.getStatus())) {
            this.gerarLivrosFiscais(aux);
            try {
                if (this.isCrediarioOrBoleto(aux)) {
                    this.gerarTitulosCrediarioOrBoleto(aux);
                }
            }
            catch (ExceptionInvalidData | ExceptionObjectNotFound | ExceptionTitulo ex) {
                this.getLogger().error(ex);
                throw new RuntimeException(ex);
            }
            this.gerarChequeTerceiros(aux, this.getOpcoesFinanceiras(aux.getEmpresa()));
        } else {
            aux.getLivrosFiscais().clear();
            for (NFCePagamento pagamento : aux.getPagamentos()) {
                pagamento.getTitulos().clear();
                pagamento.getChequeTerceiros().clear();
                pagamento.setStatus(Short.valueOf((short)0));
            }
        }
        return super.beforeSave(aux);
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder builder) {
        builder.addDTOConverter((DTOEntityConversor)this.periodoEmissaoConverter);
        builder.addDTOConverter((DTOEntityConversor)this.periodoEmissaoNFeConverter);
        builder.addDTOConverter((DTOEntityConversor)this.controleCaixaConverter);
        builder.addDTOConverter((DTOEntityConversor)this.preAbastecimento);
        builder.addDTOConverter((DTOEntityConversor)this.pedidoPreVenda);
    }

    private List<LivroFiscal> getLivrosFiscaisNFCe(NFCe aux) {
        return new CompLivroFiscalNFCe().gerarLivrosFiscais(aux.getModeloDocFiscal(), aux.getSituacaoDocumento(), aux.getDataEmissao(), aux.getEmpresa(), aux.getItens(), aux.getLivrosFiscais());
    }

    private void gerarTitulosCrediarioOrBoleto(NFCe aux) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        OpcoesFinanceiras opcoesFinanceiras = this.getOpcoesFinanceiras(aux.getEmpresa());
        NFCeOpcoes opcoesNFCe = this.getOpcoesNFCe(aux.getEmpresa());
        PlanoConta pc = this.scPlanoConta.getPlanoConta(aux.getUnidadeFatCliente().getCliente(), this.getOpcoesContabeis(aux.getEmpresa()));
        CategoriaPessoa categoria = aux.getUnidadeFatCliente().getCategoriaPessoa();
        Pessoa pessoa = aux.getUnidadeFatCliente().getCliente().getPessoa();
        ((CompGeracaoTitulos)Context.get(CompGeracaoTitulos.class)).gerarTitulos(aux, opcoesFinanceiras, pessoa, pc, categoria, opcoesNFCe);
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(aux, this.getTituloNFCe(aux), aux.getEmpresa());
    }

    private void gerarLivrosFiscais(NFCe aux) {
        aux.getLivrosFiscais().clear();
        aux.setLivrosFiscais(this.getLivrosFiscaisNFCe(aux));
    }

    public OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesFinanceiras(empresa);
    }

    public OpcoesContabeis getOpcoesContabeis(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesContabeis(empresa);
    }

    private boolean isCrediarioOrBoleto(NFCe aux) {
        for (NFCePagamento pag : aux.getPagamentos()) {
            if (!pag.getStatus().equals((short)1) || !pag.getTipoPagamentoNFe().getCodigo().equals("05") && !pag.getTipoPagamentoNFe().getCodigo().equals("15")) continue;
            return true;
        }
        return false;
    }

    private void gerarChequeTerceiros(NFCe nfce, OpcoesFinanceiras opcoesFinanceiras) {
        for (NFCePagamento pag : nfce.getPagamentos()) {
            if (!pag.getStatus().equals((short)1)) continue;
            for (NFCeChequeTerceiros cn : pag.getChequeTerceiros()) {
                if (cn.getAgencia() == null || cn.getAgencia().isEmpty()) continue;
                ChequeTerceiros c = cn.getChequeTerceiros();
                if (c == null) {
                    c = new ChequeTerceiros();
                }
                c.setAgencia(cn.getAgencia());
                c.setAgenciaDC(cn.getAgenciaDC());
                c.setBanco(cn.getBanco());
                c.setContaCorrente(cn.getContaCorrente());
                c.setContaCorrenteDC(cn.getContaCorrenteDC());
                c.setDataCadastro(nfce.getDataEmissao());
                c.setDataEntrada(cn.getDataEntrada());
                c.setDataVencimento(cn.getDataVencimento());
                c.setEmpresa(nfce.getEmpresa());
                c.setNumero(cn.getNumero());
                c.setValor(cn.getValor());
                c.setValorSaldo(cn.getValor());
                c.setCnpjTitular(cn.getCnpjTitular());
                c.setTitular(cn.getTitular());
                c.setC1c2c3(cn.getC1c2c3());
                c.setCodigoCMC(cn.getCodigoCMC());
                c.setDataBomPara(cn.getDataBomPara());
                if (nfce.getUnidadeFatCliente() != null && nfce.getUnidadeFatCliente().getCliente().getClassificacaoClientes() != null) {
                    c.setClassificacaoPessoa(nfce.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
                } else {
                    c.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
                }
                cn.setChequeTerceiros(c);
            }
        }
    }

    private NFCeOpcoes getOpcoesNFCe(Empresa empresa) {
        return this.sharedData.getOpcoesNFCe(empresa);
    }

    private List<Titulo> getTituloNFCe(NFCe aux) {
        ArrayList<Titulo> list = new ArrayList<Titulo>();
        for (NFCePagamento p : aux.getPagamentos()) {
            if (p.getTitulosGerados() == null || p.getTitulosGerados().isEmpty()) continue;
            list.addAll(p.getTitulosGerados());
        }
        return list;
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoNFeFromTipoEmissao(Empresa empresa, String tipoEmissao) {
        return this.servicePeriodoEmissaoNFe.findPeriodoEmissaoNFeAtivoFromTipoEmissao(empresa, tipoEmissao);
    }

    @Override
    public NFCe saveOrUpdateOnly(NFCe entity) {
        NFCe nfce = super.saveOrUpdate(entity);
        if (nfce.getIdentificador() != null && nfce.getXml() != null) {
            XMLNFCe x = this.serviceXMLNFCeImpl.getOrCreateXMLNFCe(nfce.getIdentificador());
            x.setIdNFCe(nfce.getIdentificador());
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            sb.append(nfce.getXml());
            x.setConteudoXML(sb.toString());
            this.serviceXMLNFCeImpl.saveOrUpdate((Object)x);
        }
        return nfce;
    }

    @Override
    public List<NFCe> saveOrUpdate(List<NFCe> lista) {
        List<Object> listaNFCe = new ArrayList();
        listaNFCe = super.saveOrUpdate(lista);
        for (NFCe nFCe : listaNFCe) {
            if (nFCe.getIdentificador() == null) continue;
            String xml = null;
            String xmlAutorizacao = null;
            for (NFCe nfce2 : lista) {
                if (nfce2.getXml() == null || !ToolMethods.isEquals((Object)nFCe.getSerialForSinc(), (Object)nfce2.getSerialForSinc())) continue;
                if (nfce2.getXml() != null) {
                    xml = new String(nfce2.getXml());
                }
                if (nfce2.getXmlAutorizacao() == null) continue;
                xmlAutorizacao = new String(nfce2.getXmlAutorizacao());
            }
            if (xml == null) continue;
            XMLNFCe x = this.serviceXMLNFCeImpl.getOrCreateXMLNFCe(nFCe.getIdentificador());
            x.setIdNFCe(nFCe.getIdentificador());
            x.setConteudoXML(xml);
            x.setConteudoAprovacao(xmlAutorizacao);
            this.serviceXMLNFCeImpl.saveOrUpdate((Object)x);
        }
        return listaNFCe;
    }

    public void atualizarNatRecPisCofinsItens(Date dataIn, Date dataFim) {
        ((DaoNFCeImpl)this.getDao()).atualizarNatRecPisCofinsItens(dataIn, dataFim);
    }
}

