/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfce.auxiliar.v10;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.BandeiraCartaoNFe;
import com.touchcomp.basementor.model.vo.BandeiraTEF;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeChequeTerceiros;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.NFCeTitulo;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.service.impl.bandeiracartaonfe.ServiceBandeiraCartaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.bandeiratef.ServiceBandeiraTEFImpl;
import com.touchcomp.basementorservice.service.impl.condicoespagamento.ServiceCondicoesPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.meiopagamento.ServiceMeioPagamentoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.tipopagamentonfe.ServiceTipoPagamentoNFeImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeChequeTerceiros;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCePagamento;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeTitulo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxPagamentosNFCeV10 {
    ServiceBandeiraCartaoNFeImpl serviceBandeiraCartaoNFe = (ServiceBandeiraCartaoNFeImpl)Context.get(ServiceBandeiraCartaoNFeImpl.class);
    ServiceBandeiraTEFImpl serviceBandeiraTEF = (ServiceBandeiraTEFImpl)Context.get(ServiceBandeiraTEFImpl.class);
    ServiceMeioPagamentoImpl serviceMeioPagamento = (ServiceMeioPagamentoImpl)Context.get(ServiceMeioPagamentoImpl.class);
    ServiceCondicoesPagamentoImpl serviceCondicoesPagamento = (ServiceCondicoesPagamentoImpl)Context.get(ServiceCondicoesPagamentoImpl.class);
    ServicePessoaImpl servicePessoa = (ServicePessoaImpl)Context.get(ServicePessoaImpl.class);
    ServiceTipoPagamentoNFeImpl serviceTipoPagamento = (ServiceTipoPagamentoNFeImpl)Context.get(ServiceTipoPagamentoNFeImpl.class);
    SCompPlanoConta scPlanoConta = (SCompPlanoConta)Context.get(SCompPlanoConta.class);

    public void getPagamentos(List<DTONFCePagamento> dtoPagamentos, NFCe n, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, NFCeOpcoes opcoesNFCe) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSinc(dtoPagamentos, n.getPagamentos())) {
            aux.addAll(n.getPagamentos());
        }
        for (DTONFCePagamento dto : dtoPagamentos) {
            NFCePagamento p = null;
            Optional<NFCePagamento> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)dto.getSerialForSinc())).findFirst();
            if (found.isPresent()) {
                p = found.get();
            } else {
                p = new NFCePagamento();
                p.setNfce(n);
                n.getPagamentos().add(p);
            }
            p.setBandeiraCartaoNFe((BandeiraCartaoNFe)this.serviceBandeiraCartaoNFe.get(dto.getBandeiraCartaoNFeIdentificador()));
            p.setBandeiraTEF((BandeiraTEF)this.serviceBandeiraTEF.get(dto.getBandeiraTEFIdentificador()));
            p.setCodigoBandeiraTEF(dto.getCodigoBandeiraTEF());
            p.setCondicoesPagamento((CondicoesPagamento)this.serviceCondicoesPagamento.get(dto.getCondicoesPagamentoIdentificador()));
            p.setMeioPagamento((MeioPagamento)this.serviceMeioPagamento.get(dto.getMeioPagamentoIdentificador()));
            p.setNrAutorizacao(dto.getNrAutorizacao());
            p.setNumeroParcelas(dto.getNumeroParcelas());
            p.setPermitirTEF(dto.getPermitirTEF());
            p.setSerialForSinc(dto.getSerialForSinc());
            p.setStatus(dto.getStatus());
            p.setTipoPagamentoNFe((TipoPagamentoNFe)this.serviceTipoPagamento.get(dto.getTipoPagamentoNFeIdentificador()));
            p.setValor(dto.getValor());
            p.setValorLiquido(dto.getValorLiquido());
            p.setValorTroco(dto.getValorTroco());
            if (ToolMethods.isAffirmative((Number)p.getStatus())) {
                this.setDadosTitulos(p, dto);
                this.setDadosChequeTerceiros(p, dto);
                continue;
            }
            p.getTitulos().clear();
            p.getTitulosGerados().clear();
            p.getChequeTerceiros().clear();
        }
        if (EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)n.getStatus())) {
            if (this.isCrediarioOrBoleto(n)) {
                this.setTitulosCrediarioOrBoleto(n, opcoesFinanceiras, opcoesContabeis, opcoesNFCe);
            }
            this.setChequeTerceiros(n, opcoesFinanceiras);
        }
    }

    private boolean checkIfContainsSerialForSinc(List<DTONFCePagamento> pagamentos, List<NFCePagamento> infPagamentoNfPropria) {
        Optional<DTONFCePagamento> found1 = pagamentos.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<NFCePagamento> found2 = infPagamentoNfPropria.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private boolean checkIfContainsSerialForSincCh(List<NFCeChequeTerceiros> chequeTerceiros, List<DTONFCeChequeTerceiros> dtoChequeTerceiros) {
        Optional<NFCeChequeTerceiros> found1 = chequeTerceiros.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<DTONFCeChequeTerceiros> found2 = dtoChequeTerceiros.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private boolean checkIfContainsSerialForSincTit(List<NFCeTitulo> titulos, List<DTONFCeTitulo> titulosNF) {
        Optional<NFCeTitulo> found1 = titulos.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<DTONFCeTitulo> found2 = titulosNF.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private void setDadosTitulos(NFCePagamento nfcePag, DTONFCePagamento dtoPag) {
        if (!ToolMethods.isWithData((Collection)dtoPag.getTitulos())) {
            return;
        }
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSincTit(nfcePag.getTitulos(), dtoPag.getTitulos())) {
            aux.addAll(nfcePag.getTitulos());
        }
        NFCeTitulo nfceTit = null;
        for (DTONFCeTitulo dtoTit : dtoPag.getTitulos()) {
            Optional<NFCeTitulo> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)dtoTit.getSerialForSinc())).findFirst();
            if (found.isPresent()) {
                nfceTit = found.get();
            } else {
                nfceTit = new NFCeTitulo();
                nfceTit.setNfcePagamento(nfcePag);
                nfcePag.getTitulos().add(nfceTit);
            }
            nfceTit.setDataCadastro(dtoTit.getDataCadastro());
            nfceTit.setDataVencimento(dtoTit.getDataVencimento());
            nfceTit.setNumeroParcela(dtoTit.getNumeroParcela());
            nfceTit.setSerialForSinc(dtoTit.getSerialForSinc());
            nfceTit.setValor(dtoTit.getValor());
        }
    }

    private void setDadosChequeTerceiros(NFCePagamento pag, DTONFCePagamento dtoPag) {
        if (!ToolMethods.isWithData((Collection)dtoPag.getChequeTerceiros())) {
            return;
        }
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSincCh(pag.getChequeTerceiros(), dtoPag.getChequeTerceiros())) {
            aux.addAll(pag.getChequeTerceiros());
        }
        for (DTONFCeChequeTerceiros dtoCheque : dtoPag.getChequeTerceiros()) {
            NFCeChequeTerceiros inf = null;
            Optional<NFCeChequeTerceiros> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)dtoCheque.getSerialForSinc())).findFirst();
            if (found.isPresent()) {
                inf = found.get();
            } else {
                inf = new NFCeChequeTerceiros();
                inf.setNfcePagamento(pag);
                pag.getChequeTerceiros().add(inf);
            }
            inf.setAgencia(dtoCheque.getAgencia());
            inf.setAgenciaDC(dtoCheque.getAgenciaDC());
            inf.setBanco(dtoCheque.getBanco());
            inf.setC1c2c3(dtoCheque.getC1c2c3());
            inf.setCnpjTitular(dtoCheque.getCnpjTitular());
            inf.setCodigoCMC(dtoCheque.getCodigoCMC());
            inf.setContaCorrente(dtoCheque.getContaCorrente());
            inf.setContaCorrenteDC(dtoCheque.getContaCorrenteDC());
            inf.setDataBomPara(dtoCheque.getDataBomPara());
            inf.setDataEntrada(dtoCheque.getDataEntrada());
            inf.setDataVencimento(dtoCheque.getDataVencimento());
            inf.setNumero(dtoCheque.getNumero());
            inf.setSerialForSinc(dtoCheque.getSerialForSinc());
            inf.setTipoCompensacao(dtoCheque.getTipoCompensacao());
            inf.setTitular(dtoCheque.getTitular());
            inf.setValor(dtoCheque.getValor());
        }
    }

    private boolean isCrediarioOrBoleto(NFCe aux) {
        for (NFCePagamento pag : aux.getPagamentos()) {
            if (!pag.getStatus().equals((short)1) || !pag.getTipoPagamentoNFe().getCodigo().equals("05") && !pag.getTipoPagamentoNFe().getCodigo().equals("15")) continue;
            return true;
        }
        return false;
    }

    private void setTitulosCrediarioOrBoleto(NFCe aux, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis, NFCeOpcoes opcoesNFCe) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        Pessoa pessoa = aux.getUnidadeFatCliente().getCliente().getPessoa();
        PlanoConta pc = this.scPlanoConta.getPlanoConta(aux.getUnidadeFatCliente().getCliente(), opcoesContabeis);
        CategoriaPessoa categoria = aux.getUnidadeFatCliente().getCategoriaPessoa();
        ((CompGeracaoTitulos)Context.get(CompGeracaoTitulos.class)).gerarTitulos(aux, opcoesFinanceiras, pessoa, pc, categoria, opcoesNFCe);
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(aux, this.getTituloNFCe(aux), aux.getEmpresa());
    }

    private void setChequeTerceiros(NFCe nfce, OpcoesFinanceiras opcoes) {
        for (NFCePagamento pag : nfce.getPagamentos()) {
            if (!pag.getStatus().equals((short)1)) continue;
            for (NFCeChequeTerceiros inf : pag.getChequeTerceiros()) {
                ChequeTerceiros c = inf.getChequeTerceiros();
                if (c == null) {
                    c = new ChequeTerceiros();
                    inf.setChequeTerceiros(c);
                }
                c.setAgencia(inf.getAgencia());
                c.setAgenciaDC(inf.getAgenciaDC());
                c.setBanco(inf.getBanco());
                c.setC1c2c3(inf.getC1c2c3());
                c.setCodigoCMC(inf.getCodigoCMC());
                c.setCnpjTitular(inf.getCnpjTitular());
                c.setContaCorrente(inf.getContaCorrente());
                c.setContaCorrenteDC(inf.getContaCorrenteDC());
                c.setDataCadastro(new Date());
                c.setDataEntrada(inf.getDataEntrada());
                c.setDataVencimento(inf.getDataVencimento());
                c.setDataBomPara(inf.getDataBomPara());
                c.setEmpresa(pag.getNfce().getEmpresa());
                c.setNumero(inf.getNumero());
                c.setTitular(inf.getTitular());
                c.setSerialForSinc(inf.getSerialForSinc());
                c.setValor(inf.getValor());
                c.setValorSaldo(inf.getValor());
                if (pag.getNfce().getUnidadeFatCliente() != null) {
                    c.setPessoa(pag.getNfce().getUnidadeFatCliente().getCliente().getPessoa());
                }
                c.setRepresentante(pag.getNfce().getRepresentante());
                if (pag.getNfce() != null && pag.getNfce().getUnidadeFatCliente() != null && pag.getNfce().getUnidadeFatCliente().getCliente().getClassificacaoClientes() != null) {
                    c.setClassificacaoPessoa(pag.getNfce().getUnidadeFatCliente().getCliente().getClassificacaoClientes());
                    continue;
                }
                c.setClassificacaoPessoa(opcoes.getClassificacaoClientes());
            }
        }
    }

    private List<Titulo> getTituloNFCe(NFCe aux) {
        ArrayList<Titulo> list = new ArrayList<Titulo>();
        for (NFCePagamento p : aux.getPagamentos()) {
            if (p.getTitulosGerados() == null || p.getTitulosGerados().isEmpty()) continue;
            list.addAll(p.getTitulosGerados());
        }
        return list;
    }
}

