/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfce.auxiliar.v11;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ClasseEnquadramentoIPI;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaIpi;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ModalidadeIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.MotivoDesoneracaoIcms;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCeItemCofins;
import com.touchcomp.basementor.model.vo.NFCeItemICMS;
import com.touchcomp.basementor.model.vo.NFCeItemIpi;
import com.touchcomp.basementor.model.vo.NFCeItemPis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementorservice.helpers.impl.nfce.HelperNFCeItem;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.centroestoque.ServiceCentroEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.cest.ServiceCestImpl;
import com.touchcomp.basementorservice.service.impl.cfop.ServiceCfopImpl;
import com.touchcomp.basementorservice.service.impl.classeenquadramentoipi.ServiceClasseEnquadramentoIPIImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.incidenciaicms.ServiceIncidenciaIcmsImpl;
import com.touchcomp.basementorservice.service.impl.incidenciaipi.ServiceIncidenciaIpiImpl;
import com.touchcomp.basementorservice.service.impl.incidenciapiscofins.ServiceIncidenciaPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modalidadeicms.ServiceModalidadeIcmsImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.motivodesoneracaoicms.ServiceMotivoDesoneracaoIcmsImpl;
import com.touchcomp.basementorservice.service.impl.ncm.ServiceNcmImpl;
import com.touchcomp.basementorservice.service.impl.nfcepreabastecimento.ServiceNFCePreAbastecimentoImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.representante.ServiceRepresentanteImpl;
import com.touchcomp.basementorservice.service.impl.unidademedida.ServiceUnidadeMedidaImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeItemCofins;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeItemICMS;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeItemIpi;
import com.touchcomp.touchvomodel.vo.nfce.DTONFCeItemPis;
import com.touchcomp.touchvomodel.vo.nfce.v11.DTONFCeItemV11;
import com.touchcomp.touchvomodel.vo.nfce.v11.DTONFCeV11;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class AuxItensNFCeV11
extends ServiceGenericImpl {
    ServiceCentroEstoqueImpl serviceCentroEstoque = (ServiceCentroEstoqueImpl)Context.get(ServiceCentroEstoqueImpl.class);
    ServiceCfopImpl serviceCfop = (ServiceCfopImpl)Context.get(ServiceCfopImpl.class);
    ServiceGradeCorImpl serviceGradeCor = (ServiceGradeCorImpl)Context.get(ServiceGradeCorImpl.class);
    ServiceLoteFabricacaoImpl serviceLoteFabricacao = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    ServiceProdutoImpl serviceProduto = (ServiceProdutoImpl)Context.get(ServiceProdutoImpl.class);
    ServiceModeloFiscalImpl serviceModeloFiscal = (ServiceModeloFiscalImpl)Context.get(ServiceModeloFiscalImpl.class);
    ServiceNcmImpl serviceNcm = (ServiceNcmImpl)Context.get(ServiceNcmImpl.class);
    ServiceNFCePreAbastecimentoImpl servicePreAbastecimento = (ServiceNFCePreAbastecimentoImpl)Context.get(ServiceNFCePreAbastecimentoImpl.class);
    ServiceRepresentanteImpl serviceRepresentante = (ServiceRepresentanteImpl)Context.get(ServiceRepresentanteImpl.class);
    ServiceUnidadeMedidaImpl serviceUnidadeMedida = (ServiceUnidadeMedidaImpl)Context.get(ServiceUnidadeMedidaImpl.class);
    ServiceUsuarioImpl serviceUsuario = (ServiceUsuarioImpl)Context.get(ServiceUsuarioImpl.class);
    ServiceIncidenciaIcmsImpl serviceIncidenciaIcms = (ServiceIncidenciaIcmsImpl)Context.get(ServiceIncidenciaIcmsImpl.class);
    ServiceIncidenciaPisCofinsImpl serviceIncidenciaPisCofins = (ServiceIncidenciaPisCofinsImpl)Context.get(ServiceIncidenciaPisCofinsImpl.class);
    ServiceIncidenciaIpiImpl serviceIncidenciaIpi = (ServiceIncidenciaIpiImpl)Context.get(ServiceIncidenciaIpiImpl.class);
    ServiceModalidadeIcmsImpl serviceModalidadeIcms = (ServiceModalidadeIcmsImpl)Context.get(ServiceModalidadeIcmsImpl.class);
    ServiceMotivoDesoneracaoIcmsImpl serviceMotivoDesoneracaoIcms = (ServiceMotivoDesoneracaoIcmsImpl)Context.get(ServiceMotivoDesoneracaoIcmsImpl.class);
    ServiceClasseEnquadramentoIPIImpl serviceClasseEnqIPI = (ServiceClasseEnquadramentoIPIImpl)Context.get(ServiceClasseEnquadramentoIPIImpl.class);
    ServiceCestImpl serviceCest = (ServiceCestImpl)Context.get(ServiceCestImpl.class);

    public void setItensNFCe(NFCe nfce, DTONFCeV11 dto) {
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSinc(nfce.getItens(), dto.getItens())) {
            aux.addAll(nfce.getItens());
        }
        LinkedList<NFCeItem> added = new LinkedList<NFCeItem>();
        for (DTONFCeItemV11 itemDTO : dto.getItens()) {
            Optional<NFCeItem> found = aux.stream().filter(it -> ToolMethods.isEquals((Object)it.getSerialForSinc(), (Object)itemDTO.getSerialForSinc())).findFirst();
            NFCeItem i = found.isPresent() ? found.get() : new NFCeItem();
            added.add(i);
            i.setNfce(nfce);
            i.setCentroEstoque((CentroEstoque)this.serviceCentroEstoque.get(itemDTO.getCentroEstoqueIdentificador()));
            i.setCest(null);
            i.setCfop((Cfop)this.serviceCfop.get(itemDTO.getCfopIdentificador()));
            i.setCodigoBarras(itemDTO.getCodigoBarras());
            i.setCodigoBarrasTributavel(itemDTO.getCodigoBarrasTributavel());
            i.setCompoeTotal(itemDTO.getCompoeTotal());
            i.setDataEmissao(nfce.getDataEmissao());
            i.setEmpresa(nfce.getEmpresa());
            i.setFatorConversao(itemDTO.getFatorConversao());
            i.setGradeCor((GradeCor)this.serviceGradeCor.get(itemDTO.getGradeCorIdentificador()));
            i.setInfAdicionalProd(itemDTO.getInfAdicionalProd());
            i.setProduto((Produto)this.serviceProduto.get(itemDTO.getProdutoIdentificador()));
            i.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(i.getProduto()));
            i.setModeloFiscal((ModeloFiscal)this.serviceModeloFiscal.get(itemDTO.getModeloFiscalIdentificador()));
            i.setStatus(itemDTO.getStatus());
            i.setMovimentacaoFisica(Short.valueOf(EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus()) ? this.serviceModeloFiscal.movimentacaoFisicaByModelo(i.getModeloFiscal().getIdentificador()) : (short)0));
            if (!ToolMethods.isAffirmative((Number)i.getStatus())) {
                i.setMovimentacaoFisica(Short.valueOf((short)0));
            }
            i.setNcm(i.getProduto().getNcm());
            i.setNumeroItem(itemDTO.getNumeroItem());
            i.setNumeroPedidoCliente(itemDTO.getNumeroPedidoCliente());
            i.setNumeroPedidoItemCliente(itemDTO.getNumeroPedidoItemCliente());
            i.setPercTributosPrevistos(itemDTO.getPercTributosPrevistos());
            i.setPercValorDesconto(itemDTO.getPercValorDesconto());
            i.setPercValorDespAcess(itemDTO.getPercValorDespAcess());
            i.setPercValorFrete(itemDTO.getPercValorFrete());
            i.setPercValorSeguro(itemDTO.getPercValorSeguro());
            i.setPercentualComissao(itemDTO.getPercentualComissao());
            i.setPercentualDesconto(itemDTO.getPercentualDesconto());
            i.setPercentualDescontoInf(itemDTO.getPercentualDescontoInf());
            i.setPercentualDescontoRat(itemDTO.getPercentualDescontoRat());
            i.setPercentualDespAcess(itemDTO.getPercentualDespAcess());
            i.setPercentualDespAcessInf(itemDTO.getPercentualDespAcessInf());
            i.setPercentualDespAcessRat(itemDTO.getPercentualDespAcessRat());
            i.setPercentualFrete(itemDTO.getPercentualFrete());
            i.setPercentualFreteInf(itemDTO.getPercentualFreteInf());
            i.setPercentualFreteRat(itemDTO.getPercentualFreteRat());
            i.setPercentualSeguro(itemDTO.getPercentualSeguro());
            i.setPercentualSeguroInf(itemDTO.getPercentualSeguroInf());
            i.setPercentualSeguroRat(itemDTO.getPercentualSeguroRat());
            i.setPreAbastecimento(this.servicePreAbastecimento.getBySerial(itemDTO.getPreAbastecimentoSerialForSinc()));
            i.setQuantidadeComercial(itemDTO.getQuantidadeComercial());
            i.setQuantidadeTributaria(itemDTO.getQuantidadeTributaria());
            i.setRepresentante((Representante)this.serviceRepresentante.get(itemDTO.getRepresentanteIdentificador()));
            i.setSerialForSinc(itemDTO.getSerialForSinc());
            i.setUnidadeMedidaTrib((UnidadeMedida)this.serviceUnidadeMedida.get(itemDTO.getUnidadeMedidaTribIdentificador()));
            i.setUsuarioCancelamento(null);
            i.setValorCusto(itemDTO.getValorCusto());
            i.setValorDesconto(itemDTO.getValorDesconto());
            i.setValorDescontoInf(itemDTO.getValorDescontoInf());
            i.setValorDescontoRat(itemDTO.getValorDescontoRat());
            i.setValorDespesasAcessorias(itemDTO.getValorDespesasAcessorias());
            i.setValorDespesasAcessoriasInf(itemDTO.getValorDespesasAcessoriasInf());
            i.setValorDespesasAcessoriasRat(itemDTO.getValorDespesasAcessoriasRat());
            i.setValorFrete(itemDTO.getValorFrete());
            i.setValorFreteInf(itemDTO.getValorFreteInf());
            i.setValorFreteRat(itemDTO.getValorFreteRat());
            i.setValorSeguro(itemDTO.getValorSeguro());
            i.setValorSeguroInf(itemDTO.getValorSeguroInf());
            i.setValorSeguroRat(itemDTO.getValorSeguroRat());
            i.setValorTotal(itemDTO.getValorTotal());
            i.setValorTotalBruto(itemDTO.getValorTotalBruto());
            i.setValorTotalTributos(itemDTO.getValorTotalTributos());
            i.setValorUnitarioComercial(itemDTO.getValorUnitarioComercial());
            i.setValorUnitarioTributario(itemDTO.getValorUnitarioTributario());
            i.setIcms(this.getIcms(itemDTO.getIcms(), i));
            i.setIpi(this.getIpi(itemDTO.getIpi(), i));
            i.setCofins(this.getCofins(itemDTO.getCofins(), i));
            i.setPis(this.getPis(itemDTO.getPis(), i, i.getCofins().getIncidenciaPisCofins()));
            new HelperNFCeItem(i).setNatReceitaPisCofins();
        }
        nfce.getItens().clear();
        nfce.getItens().addAll(added);
    }

    private boolean checkIfContainsSerialForSinc(List<NFCeItem> itensNFCe, List<DTONFCeItemV11> itensDTO) {
        Optional<DTONFCeItemV11> found1 = itensDTO.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<NFCeItem> found2 = itensNFCe.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private NFCeItemICMS getIcms(DTONFCeItemICMS dto, NFCeItem item) {
        NFCeItemICMS icms = null;
        icms = item.getIcms() != null ? item.getIcms() : new NFCeItemICMS();
        icms.setAliquotaIcms(dto.getAliquotaIcms());
        icms.setAliquotaIcmsFundoCombPobreza(dto.getAliquotaIcmsFundoCombPobreza());
        icms.setAliquotaIcmsSTRetido(dto.getAliquotaIcmsSTRetido());
        icms.setAliquotaIcmsSimples(dto.getAliquotaIcmsSimples());
        icms.setIncidenciaIcms((IncidenciaIcms)this.serviceIncidenciaIcms.get(dto.getIncidenciaIcmsIdentificador()));
        icms.setModalidadeIcms((ModalidadeIcms)this.serviceModalidadeIcms.get(dto.getModalidadeIcmsIdentificador()));
        icms.setMotivoDesoneracaoIcms((MotivoDesoneracaoIcms)this.serviceMotivoDesoneracaoIcms.get(dto.getMotivoDesoneracaoIcmsIdentificador()));
        icms.setPercDiferimento(dto.getPercDiferimento());
        icms.setPercRedBCIcms(dto.getPercRedBCIcms());
        icms.setValorBcCalculoIcms(dto.getValorBcCalculoIcms());
        icms.setValorBcCalculoIcmsFundoCombPobreza(dto.getValorBcCalculoIcmsFundoCombPobreza());
        icms.setValorBcCalculoIcmsStRetido(dto.getValorBcCalculoIcmsStRetido());
        icms.setValorIcms(dto.getValorIcms());
        icms.setValorIcmsDesonerado(dto.getValorIcmsDesonerado());
        icms.setValorIcmsDiferimento(dto.getValorIcmsDiferimento());
        icms.setValorIcmsFundoCombPobreza(dto.getValorIcmsFundoCombPobreza());
        icms.setValorIcmsIsento(dto.getValorIcmsIsento());
        icms.setValorIcmsOutros(dto.getValorIcmsOutros());
        icms.setValorIcmsSimples(dto.getValorIcmsSimples());
        icms.setValorIcmsStRetido(dto.getValorIcmsStRetido());
        icms.setValorIcmsTributado(dto.getValorIcmsTributado());
        icms.setValoricmsOperacao(dto.getValoricmsOperacao());
        icms.setVrNaoTribIcms(dto.getVrNaoTribIcms());
        icms.setValorUnidBCIcmsSTRetAnt(dto.getValorUnidBCIcmsSTRetAnt());
        icms.setValorUnidIcmsSTRetAnt(dto.getValorUnidIcmsSTRetAnt());
        return icms;
    }

    private NFCeItemCofins getCofins(DTONFCeItemCofins dto, NFCeItem item) {
        NFCeItemCofins cofins = null;
        cofins = item.getCofins() != null ? item.getCofins() : new NFCeItemCofins();
        cofins.setAliquota(dto.getAliquota());
        cofins.setAliquotaQuantidade(dto.getAliquotaQuantidade());
        cofins.setIncidenciaPisCofins((IncidenciaPisCofins)this.serviceIncidenciaPisCofins.get(dto.getIncidenciaPisCofinsIdentificador()));
        cofins.setQuantidadeVendida(dto.getQuantidadeVendida());
        cofins.setValor(dto.getValor());
        cofins.setValorBaseCalculo(dto.getValorBaseCalculo());
        return cofins;
    }

    private NFCeItemPis getPis(DTONFCeItemPis dto, NFCeItem item, IncidenciaPisCofins inc) {
        NFCeItemPis pis = null;
        pis = item.getPis() != null ? item.getPis() : new NFCeItemPis();
        pis.setAliquota(dto.getAliquota());
        pis.setAliquotaQuantidade(dto.getAliquotaQuantidade());
        pis.setIncidenciaPisCofins(inc);
        pis.setQuantidadeVendida(dto.getQuantidadeVendida());
        pis.setValor(dto.getValor());
        pis.setValorBaseCalculo(dto.getValorBaseCalculo());
        return pis;
    }

    private NFCeItemIpi getIpi(DTONFCeItemIpi dto, NFCeItem item) {
        NFCeItemIpi ipi = null;
        ipi = item.getIpi() != null ? item.getIpi() : new NFCeItemIpi();
        ipi.setAliquota(dto.getAliquota());
        ipi.setClasseEnqIpi((ClasseEnquadramentoIPI)this.serviceClasseEnqIPI.get(dto.getClasseEnqIpiIdentificador()));
        ipi.setIncidenciaIpi((IncidenciaIpi)this.serviceIncidenciaIpi.get(dto.getIncidenciaIpiIdentificador()));
        ipi.setQuantidadeVendida(dto.getQuantidadeVendida());
        ipi.setValorIpiComercio(dto.getValorIpiComercio());
        ipi.setValorIpiIndustria(dto.getValorIpiIndustria());
        ipi.setValorIpiIsento(dto.getValorIpiIsento());
        ipi.setValorIpiObservacao(dto.getValorIpiObservacao());
        ipi.setValorIpiOutros(dto.getValorIpiOutros());
        ipi.setValorIpiTributado(dto.getValorIpiTributado());
        return ipi;
    }
}

