/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfceencerranteabastecimento;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.model.vo.BicoBombaCombustivel;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCeEncerranteAbastecimento;
import com.touchcomp.basementorservice.dao.impl.DaoNFCeEncerranteAbastecimentoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.converters.DTONFCeControleCaixaConverter;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNFCeEncerranteAbastecimentoImpl
extends ServiceGenericEntityImpl<NFCeEncerranteAbastecimento, Long, DaoNFCeEncerranteAbastecimentoImpl> {
    @Autowired
    private DTONFCeControleCaixaConverter controleCaixaConverter;

    @Autowired
    public ServiceNFCeEncerranteAbastecimentoImpl(DaoNFCeEncerranteAbastecimentoImpl genericDao) {
        super(genericDao);
    }

    @Override
    public DaoNFCeEncerranteAbastecimentoImpl getGenericDao() {
        return (DaoNFCeEncerranteAbastecimentoImpl)super.getGenericDao();
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder builder) {
        builder.addDTOConverter((DTOEntityConversor)this.controleCaixaConverter);
    }

    public List<NFCeEncerranteAbastecimento> findEncerrantesAbastecimentoByControleCaixa(NFCeControleCaixa nfceControleCaixa) {
        return ((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).findEncerrantesAbastecimentoByControleCaixa(nfceControleCaixa);
    }

    public List<NFCeEncerranteAbastecimento> analiseGerarEncerrantes(NFCeControleCaixa nfceControleCaixa) {
        if (this.isNull(nfceControleCaixa.getDataFechamento()).booleanValue()) {
            return null;
        }
        List<NFCeEncerranteAbastecimento> list = this.findEncerrantesAbastecimentoByControleCaixa(nfceControleCaixa);
        this.redefinirDatasEncerrantes(nfceControleCaixa, list);
        ArrayList<BicoBombaCombustivel> listBicos = new ArrayList<BicoBombaCombustivel>();
        ArrayList<NFCeEncerranteAbastecimento> novosEncerrantes = new ArrayList<NFCeEncerranteAbastecimento>();
        for (NFCeEncerranteAbastecimento n : list) {
            BicoBombaCombustivel b = n.getBico();
            if (listBicos.contains(b)) continue;
            listBicos.add(b);
            Boolean statusAberto = false;
            Boolean statusFechado = false;
            List<NFCeEncerranteAbastecimento> listPar = list.stream().filter(aux -> this.isEquals(aux.getBico(), b)).collect(Collectors.toList());
            for (NFCeEncerranteAbastecimento e : listPar) {
                if (this.isEquals(e.getStatus(), EnumConstAbertoFechado.ABERTO.getValue())) {
                    statusAberto = true;
                }
                if (!this.isEquals(e.getStatus(), EnumConstAbertoFechado.FECHADO.getValue())) continue;
                statusFechado = true;
            }
            if (!statusAberto.booleanValue() || !statusFechado.booleanValue()) {
                NFCeEncerranteAbastecimento newEncerrante = this.gerarNovoEncerranete(listPar);
                novosEncerrantes.add(newEncerrante);
                continue;
            }
            if (!statusAberto.booleanValue() || !statusFechado.booleanValue()) continue;
            boolean achou = false;
            for (NFCeEncerranteAbastecimento e : listPar) {
                if (e.getQuantidade() != 0.0 && e.getValor() != 0.0) continue;
                achou = this.atualizarEncerrante(e);
            }
            if (!achou) continue;
            ((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).saveOrUpdate(listPar);
        }
        if (!novosEncerrantes.isEmpty()) {
            list.addAll(((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).saveOrUpdate(novosEncerrantes));
        }
        return list;
    }

    private NFCeEncerranteAbastecimento gerarNovoEncerranete(List<NFCeEncerranteAbastecimento> listPar) {
        NFCeEncerranteAbastecimento n = listPar.get(0);
        NFCeEncerranteAbastecimento newEnc = new NFCeEncerranteAbastecimento();
        newEnc.setBico(n.getBico());
        newEnc.setControleCaixa(n.getControleCaixa());
        newEnc.setSerialForSinc("");
        if (this.isEquals(n.getStatus(), EnumConstAbertoFechado.ABERTO.getValue())) {
            NFCeEncerranteAbastecimento posterior = this.findEncerramentoPosterior(n);
            newEnc.setStatus(Short.valueOf(EnumConstAbertoFechado.FECHADO.getValue()));
            Date dataHorafechamento = ToolDate.colocarHorasEmData((Date)n.getDataEncerramento(), (int)20, (int)0, (int)0);
            newEnc.setDataEncerramento(dataHorafechamento);
            newEnc.setValor(posterior.getValor());
            newEnc.setQuantidade(posterior.getQuantidade());
        } else {
            NFCeEncerranteAbastecimento anterior = this.findEncerramentoAnterior(n);
            newEnc.setStatus(Short.valueOf(EnumConstAbertoFechado.ABERTO.getValue()));
            Date dataHoraAbertura = ToolDate.colocarHorasEmData((Date)n.getDataEncerramento(), (int)6, (int)0, (int)0);
            newEnc.setDataEncerramento(dataHoraAbertura);
            newEnc.setValor(anterior.getValor());
            newEnc.setQuantidade(anterior.getQuantidade());
        }
        return newEnc;
    }

    private Boolean atualizarEncerrante(NFCeEncerranteAbastecimento n) {
        boolean atualizou = false;
        if (this.isEquals(n.getStatus(), EnumConstAbertoFechado.ABERTO.getValue())) {
            NFCeEncerranteAbastecimento anterior = this.findEncerramentoAnterior(n);
            if (anterior != null && anterior.getValor() > 0.0) {
                n.setValor(anterior.getValor());
                atualizou = true;
            }
            if (anterior != null && anterior.getQuantidade() > 0.0) {
                n.setQuantidade(anterior.getQuantidade());
                atualizou = true;
            }
        } else {
            NFCeEncerranteAbastecimento posterior = this.findEncerramentoPosterior(n);
            if (posterior != null && posterior.getValor() > 0.0) {
                n.setValor(posterior.getValor());
                atualizou = true;
            }
            if (posterior != null && posterior.getQuantidade() > 0.0) {
                n.setQuantidade(posterior.getQuantidade());
                atualizou = true;
            }
        }
        return atualizou;
    }

    private NFCeEncerranteAbastecimento findEncerramentoPosterior(NFCeEncerranteAbastecimento n) {
        return ((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).findEncerramentoPosterior(n);
    }

    private NFCeEncerranteAbastecimento findEncerramentoAnterior(NFCeEncerranteAbastecimento n) {
        return ((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).findEncerramentoAnterior(n);
    }

    private void redefinirDatasEncerrantes(NFCeControleCaixa nfceControleCaixa, List<NFCeEncerranteAbastecimento> encerrantes) {
        Date dataAbertura = ToolDate.dataSemHora((Date)nfceControleCaixa.getDataAbertura());
        Boolean atualiza = false;
        for (NFCeEncerranteAbastecimento e : encerrantes) {
            if (ToolMethods.isEquals((Object)e.getDataEncerramento(), (Object)dataAbertura)) continue;
            if (ToolMethods.isEquals((Object)e.getStatus(), (Object)EnumConstAbertoFechado.FECHADO.getValue())) {
                e.setDataEncerramento(ToolDate.colocarHorasEmData((Date)dataAbertura, (int)20, (int)0, (int)0));
            } else {
                e.setDataEncerramento(ToolDate.colocarHorasEmData((Date)dataAbertura, (int)6, (int)0, (int)0));
            }
            atualiza = true;
        }
        if (atualiza.booleanValue()) {
            ((DaoNFCeEncerranteAbastecimentoImpl)this.getDao()).saveOrUpdate(encerrantes);
        }
    }
}

