/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfcepessoa;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.ClienteFaturamento;
import com.touchcomp.basementor.model.vo.ClienteFichaFinanceira;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.GeracaoContaPessoa;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCePessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PessoaDadosFinanceiros;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoNFCePessoaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cliente.ServiceClienteImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNFCePessoaImpl
extends ServiceGenericEntityImpl<NFCePessoa, Long, DaoNFCePessoaImpl> {
    @Autowired
    private ServiceClienteImpl serviceCliente;
    @Autowired
    private ServicePessoaImpl servicePessoa;
    @Autowired
    private InterfaceStaticObjects sharedData;

    @Autowired
    public ServiceNFCePessoaImpl(DaoNFCePessoaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public NFCePessoa beforeSave(NFCePessoa aux) {
        try {
            this.converterNFCePessoaInUnidadeFatCliente(aux);
            return aux;
        }
        catch (ExceptionInvalidData ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    private void converterNFCePessoaInUnidadeFatCliente(NFCePessoa np) throws ExceptionInvalidData {
        if (np != null) {
            PessoaDadosFinanceiros df;
            Complemento c;
            Endereco e;
            String cnpj = np.getCpfCnpj();
            Cliente cliente = this.serviceCliente.getClienteCpfCpnj(cnpj);
            if (cliente != null) {
                return;
            }
            Pessoa p = this.servicePessoa.getByCPFCNPJ(np.getCpfCnpj());
            if (p == null) {
                p = new Pessoa();
                e = new Endereco();
                c = new Complemento();
                df = new PessoaDadosFinanceiros();
            } else {
                e = p.getEndereco();
                c = p.getComplemento();
                df = p.getPessoaDadosFinanceiros();
            }
            p.setAtivo(Short.valueOf((short)1));
            p.setDataCadastro(new Date());
            p.setNome(np.getNome());
            p.setNomeFantasia(np.getNomeFantasia());
            p.setTipoPessoa(Short.valueOf(EnumConstTipoPessoa.PESSOA_PRIMARIA.value));
            p.setPessoaDadosFinanceiros(df);
            p.setContasPessoa(new GeracaoContaPessoa());
            e.setBairro(np.getBairro());
            e.setCep(np.getCep());
            e.setCidade(np.getCidade());
            e.setComplemento(np.getComplemento());
            e.setLogradouro(np.getLogradouro());
            e.setNumero(np.getNumero());
            e.setObservacao(np.getObservacao());
            e.setReferencia(np.getReferencia());
            p.setEndereco(e);
            c.setAtivo(Short.valueOf((short)1));
            c.setCel1(np.getCel1());
            c.setCel2(np.getCel2());
            c.setFone1(np.getFone1());
            c.setFone2(np.getFone2());
            c.setInscEst(np.getInscricaoEstadual());
            c.setInscricaoMunicipal(np.getInscricaoMunicipal());
            c.setCnpj(np.getCpfCnpj());
            c.setPassaporte(np.getPassaporte());
            c.setContribuinteEstado(this.getContribuinteEstado(c.getInscEst(), e.getCidade().getUf().getSigla()));
            c.setTipoPessoa(this.getTipoPessoa(cnpj));
            c.setDataNascimento(np.getDataNascimento());
            c.setPessoa(p);
            p.setComplemento(c);
            NFCeOpcoes opcoesNFCe = this.sharedData.getOpcoesNFCe(np.getEmpresa());
            cliente = new Cliente();
            cliente.setEmpresa(np.getEmpresa());
            cliente.setDataCadastro(new Date());
            cliente.setRegiao(opcoesNFCe.getRegiao());
            cliente.setClassificacaoClientes(opcoesNFCe.getClassificacaoClientes());
            cliente.setPessoa(p);
            cliente.setAtivo(Short.valueOf((short)1));
            ClienteFinanceiro cf = new ClienteFinanceiro();
            cf.setCliente(cliente);
            cf.setHabilParaCompra(Integer.valueOf(0));
            cf.setObservacao("Cliente cadastrado no Touch NFCe");
            ClienteFichaFinanceira cff = new ClienteFichaFinanceira();
            cff.setCliente(cliente);
            ClienteFaturamento cfa = new ClienteFaturamento();
            cfa.setCliente(cliente);
            cfa.setCategoriaPessoa(opcoesNFCe.getCategoriaPessoa());
            cfa.setRepresentante(opcoesNFCe.getRepresentante());
            cfa.setTipoFrete(opcoesNFCe.getTipoFrete());
            cfa.setTipoConsumidor(Short.valueOf((short)1));
            cliente.setFinanceiro(cf);
            cliente.setFaturamento(cfa);
            cliente.setFichaFinanceira(cff);
            UnidadeFatCliente u = new UnidadeFatCliente();
            u.setCliente(cliente);
            u.setUnidadeFatPadrao(Short.valueOf((short)1));
            u.setCategoriaPessoa(opcoesNFCe.getCategoriaPessoa());
            u.setPessoa(p);
            cliente.getUnidadeFatClientes().add(u);
            cliente.setDataAtualizacao(new Timestamp(System.currentTimeMillis()));
            cliente.setPessoa(p);
            this.serviceCliente.saveOrUpdate(cliente);
        }
    }

    private Short getContribuinteEstado(String inscEst, String uf) {
        if (uf != null && uf.equalsIgnoreCase("EX") || inscEst == null || inscEst.trim().length() == 0) {
            return EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId();
        }
        if (inscEst.equalsIgnoreCase("ISENTO")) {
            return EnumConstContrEstadoIcms.ISENTO.getEnumId();
        }
        return EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId();
    }

    private Short getTipoPessoa(String cpfCpj) {
        if (cpfCpj.trim().length() == 11) {
            return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
    }
}

