/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfe;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.DadosTransNfPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EvtNFeCancelamento;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.InutilizacaoNumeracaoNFe;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LocalEntregaNFPropria;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeCancelamento;
import com.touchcomp.basementor.model.vo.NFCeEnderecoEntrega;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCeObsContrib;
import com.touchcomp.basementor.model.vo.NFCeObsFisco;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCeTotalizadores;
import com.touchcomp.basementor.model.vo.NFCeVolume;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalPropriaFreteCtrc;
import com.touchcomp.basementor.model.vo.ObservacaoIntFiscalNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoNotaPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoNFe;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.ValoresNfPropria;
import com.touchcomp.basementor.model.vo.VolumeNFe;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.expedicao.CompExpedicao;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.components.livrofiscal.CompLivroFiscal;
import com.touchcomp.basementorservice.components.titulos.CompGeracaoTitulos;
import com.touchcomp.basementorservice.dao.impl.DaoOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperCancDenegaNotaPropria;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.expedicao.ServiceExpedicaoImpl;
import com.touchcomp.basementorservice.service.impl.nfce.ServiceNFCeImplV11;
import com.touchcomp.basementorservice.service.impl.nfe.ServiceNFeImpl;
import com.touchcomp.basementorservice.service.impl.nfe.auxiliar.v11.AuxItensV11;
import com.touchcomp.basementorservice.service.impl.nfe.auxiliar.v11.AuxPagamentosV11;
import com.touchcomp.basementorservice.service.impl.periodoemissaonfe.ServicePeriodoEmissaoNFeImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorservice.service.impl.situacaodocumento.ServiceSituacaoDocumentoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLNfePropria;
import com.touchcomp.basementorxml.service.impl.xmlnfepropria.ServiceXMLNFePropriaImpl;
import com.touchcomp.touchvomodel.vo.nfce.v11.DTONFCeV11;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildNFeV11
extends ServiceGenericImpl {
    @Autowired
    private ServiceNFeImpl serviceNFe;
    @Autowired
    private ServiceNFCeImplV11 serviceNFce;
    @Autowired
    private DaoOpcoesContabeisBaixaTitulosImpl daoOpcoesContabeisBaixaTitulos;
    @Autowired
    private ServicePeriodoEmissaoNFeImpl servicePeriodoEmissaoNFe;
    @Autowired
    private ServiceXMLNFePropriaImpl serviceXMLNFePropria;
    @Autowired
    private ServiceExpedicaoImpl serviceExpedicao;
    @Autowired
    private CompLancamentosEntradaSaidaFiscais compLancamentos;
    @Autowired
    InterfaceStaticObjects sharedData;
    @Autowired
    private SCompPlanoConta scPlanoConta;
    private HashMap<ClassificacaoClientes, OpcoesContabeisBaixaTitulos> hashOpcoesContabeisBaixaTitulos = new HashMap();

    public List<PackObjectsSinc> saveNFe(String data) throws Exception {
        List liberacoes = ToolJson.readJsonList((String)data, DTONFCeV11.class);
        List<PackObjectsSinc> ret = this.sincronizaNFe(liberacoes);
        return ret;
    }

    public List<PackObjectsSinc> sincronizaNFe(List<DTONFCeV11> listNfce) throws Exception {
        Object listaNFCe = this.serviceNFce.buildToEntity(listNfce);
        this.ajustaValorCustoNulo((List<NFCe>)listaNFCe);
        ArrayList<NotaFiscalPropria> toSave = new ArrayList<NotaFiscalPropria>();
        ArrayList<NotaFiscalPropria> all = new ArrayList<NotaFiscalPropria>();
        for (NFCe nfce : listaNFCe) {
            NotaFiscalPropria nota = this.castNFCeInNotaFiscalPropria(nfce);
            if (EnumConstNFeStatus.isStatusCancelada((Integer)nota.getStatus().intValue())) {
                this.cancelarNotaFiscal(nota);
            } else if (EnumConstNFeStatus.isStatusDenegada((Integer)nota.getStatus().intValue())) {
                this.denegarNotaFiscal(nota);
            } else if (EnumConstNFeStatus.isStatusInutilizada((Integer)nota.getStatus().intValue()) || nota.getInutilizacaoNFe() != null && EnumConstNFeStatus.isStatusInutilizada((String)nota.getInutilizacaoNFe().getStatus())) {
                this.inutilizarNotaFiscal(nota);
            } else {
                this.setInfPagamento(nota, nfce, this.findOpcoesNFCe(nfce.getEmpresa()), this.getOpcoesContabeisBaixaTitulos(nota.getClassificacaoCliente()));
                nota = this.serviceNFe.saveOrUpdate(nota);
                this.setInfPagamentoCupomDesconto(nota);
                toSave.add(nota);
            }
            all.add(nota);
        }
        this.gerarXMLNFPropria(toSave, listNfce);
        List<PackObjectsSinc> temp = this.toPackObjectSinc(all);
        return temp;
    }

    private void cancelarNotaFiscal(NotaFiscalPropria nota) {
        HelperCancDenegaNotaPropria helper = new HelperCancDenegaNotaPropria();
        helper.build(nota).cancelarNotaFiscal(null);
    }

    private void denegarNotaFiscal(NotaFiscalPropria nota) {
        HelperCancDenegaNotaPropria helper = new HelperCancDenegaNotaPropria();
        helper.build(nota).denegarNotaFiscal(null);
    }

    private void inutilizarNotaFiscal(NotaFiscalPropria nota) {
        HelperCancDenegaNotaPropria helper = new HelperCancDenegaNotaPropria();
        helper.build(nota).inutilizarNotaFiscal(null);
    }

    private void ajustaValorCustoNulo(List<NFCe> listaNFCe) {
        for (NFCe nFCe : listaNFCe) {
            for (NFCeItem item : nFCe.getItens()) {
                if (item.getValorCusto() != null) continue;
                item.setValorCusto(Double.valueOf(0.0));
            }
        }
    }

    protected List<PackObjectsSinc> toPackObjectSinc(List<NotaFiscalPropria> aux) {
        LinkedList<PackObjectsSinc> ret = new LinkedList<PackObjectsSinc>();
        for (NotaFiscalPropria a : aux) {
            PackObjectsSinc p = new PackObjectsSinc();
            p.setIdObjectMentor(a.getIdentificador());
            p.setStatus(Short.valueOf((short)1));
            p.setSerialObjetoOrigem(a.getSerialForSinc());
            ret.add(p);
        }
        return ret;
    }

    private void setValoresNFPropria(NotaFiscalPropria n, NFCe nfce) {
        ValoresNfPropria v = n.getValoresNfPropria();
        if (v == null) {
            v = new ValoresNfPropria();
        }
        v.setNotaFiscalPropria(n);
        n.setValoresNfPropria(v);
        NFCeTotalizadores tot = nfce.getTotalizadores();
        v.setPercDescInf(tot.getPercDescontoInf());
        v.setPercFreteInf(tot.getPercFreteInf());
        v.setPercSeguroInf(tot.getPercSeguroInf());
        v.setPercDespAcessInf(tot.getPercDespAcessInf());
        v.setValorDescInf(tot.getValorDescontoInf());
        v.setValorFreteInf(tot.getValorFreteInf());
        v.setValorSeguroInf(tot.getValorSeguroInf());
        v.setValorDespAcessInf(tot.getValorDespAcessoriasInf());
        v.setValorDesconto(tot.getValorTotalDesconto());
        v.setValorFrete(tot.getValorTotalFrete());
        v.setValorSeguro(tot.getValorTotalSeguro());
        v.setValorDespAcess(tot.getValorTotalDespAcessorias());
        v.setValorProduto(tot.getValorTotalDosProdutosServicos());
        v.setValorTotal(tot.getValorTotalNFe());
        v.setValorCofins(tot.getValorTotalCOFINS());
        v.setValorPis(tot.getValorTotalPIS());
        v.setValorIcms(tot.getValorTotalICMS());
        v.setValorIcmsSt(tot.getValorTotalICMSST());
        v.setBcIcmsSt(tot.getBaseCalculoICMSST());
        v.setValorIcmsTributado(tot.getBaseCalculoICMS());
        v.setValorFCP(tot.getValorTotalFundoCombatePobreza());
        v.setValorFCPSt(tot.getValorTotalFundoCombatePobrezaST());
        v.setValorFCPStRetido(tot.getValorTotalFundoCombatePobrezaSTRetido());
        v.setValorEstImpostos(tot.getValorTotalTributos());
        v.setTipoDespAcessInf(Short.valueOf((short)0));
        v.setTipoFreteInf(Short.valueOf((short)0));
        v.setTipoSeguroInf(Short.valueOf((short)0));
        v.setTipoDescInf(Short.valueOf((short)0));
    }

    private void setDadosTransNfPropria(NotaFiscalPropria n, NFCe nfce) {
        DadosTransNfPropria d = n.getDadosTransNfPropria();
        if (d == null) {
            d = new DadosTransNfPropria();
        }
        d.setNotaFiscalPropria(n);
        n.setDadosTransNfPropria(d);
        d.setTipoFrete(nfce.getDadosTransporte().getTipoFrete());
        d.setTransportador(nfce.getDadosTransporte().getTransportador());
        d.setValorServicoTrans(nfce.getDadosTransporte().getValorFrete());
        d.setPlacaVeiculo(nfce.getDadosTransporte().getPlacaVeiculo());
        d.setInscricaoAntt(nfce.getDadosTransporte().getRegistroANTTVeiculo());
        if (nfce.getDadosTransporte().getUfVeiculo() != null) {
            d.setUfPlacaVeiculo(nfce.getDadosTransporte().getUfVeiculo().getSigla());
        }
        n.getNotaPropriaFreteCtrc().clear();
        if (nfce.getDadosTransporte().getValorFrete() > 0.0) {
            NotaFiscalPropriaFreteCtrc aux = new NotaFiscalPropriaFreteCtrc();
            aux.setValorCustoCtrc(nfce.getDadosTransporte().getValorFrete());
            aux.setValorDisponivelCtrc(aux.getValorCustoCtrc());
            aux.setValorFreteCtrc(aux.getValorCustoCtrc());
            aux.setValorUtilizadoCtrc(aux.getValorCustoCtrc());
            aux.setNotaPropria(n);
            n.getNotaPropriaFreteCtrc().add(aux);
        }
    }

    private void setItensNotaPropria(NotaFiscalPropria n, NFCe nfce) throws ExceptionParametrizacao, ExceptionInvalidData {
        new AuxItensV11().setItensNotaPropria(n, nfce, this.getOpcoesContabeis(n.getEmpresa()));
    }

    private void setObsContribuinte(NotaFiscalPropria n, NFCe nfce, NFCeOpcoes opcoesNFCe) {
        String obsContr = nfce.getObsGeralContrib();
        if (obsContr != null && !obsContr.isEmpty()) {
            ObservacaoNotaPropria ob = new ObservacaoNotaPropria();
            ob.setConteudo(obsContr);
            ob.setNotaFiscalPropria(n);
            ob.setObsFaturamento(opcoesNFCe.getObsFaturamentoNFe());
            n.getObservacaoNota().add(ob);
        }
        if (nfce.getObsContribuinte() != null && !nfce.getObsContribuinte().isEmpty()) {
            for (NFCeObsContrib obs : nfce.getObsContribuinte()) {
                ObservacaoNotaPropria ob = new ObservacaoNotaPropria();
                ob.setConteudo(obs.getConteudo());
                ob.setNotaFiscalPropria(n);
                ob.setObsFaturamento(obs.getObsFaturamento());
                n.getObservacaoNota().add(ob);
            }
        }
    }

    private void setObsFisco(NotaFiscalPropria n, NFCe nfce, NFCeOpcoes opcoesNFCe) {
        String obsFisco = nfce.getObsGeralFisco();
        if (obsFisco != null && !obsFisco.isEmpty()) {
            ObservacaoIntFiscalNotaFiscalPropria ob = new ObservacaoIntFiscalNotaFiscalPropria();
            ob.setConteudo(obsFisco);
            ob.setNotaFiscalPropria(n);
            ob.setObsFaturamento(opcoesNFCe.getObsFaturamentoNFe());
            n.getObservacaoIntFiscalNotaFiscalPropria().add(ob);
        }
        if (nfce.getObsFisco() != null && !nfce.getObsFisco().isEmpty()) {
            for (NFCeObsFisco obs : nfce.getObsFisco()) {
                ObservacaoIntFiscalNotaFiscalPropria ob = new ObservacaoIntFiscalNotaFiscalPropria();
                ob.setConteudo(obs.getConteudo());
                ob.setNotaFiscalPropria(n);
                ob.setObsFaturamento(obs.getObsFaturamento());
                n.getObservacaoIntFiscalNotaFiscalPropria().add(ob);
            }
        }
    }

    private void setInfPagamento(NotaFiscalPropria n, NFCe nfce, NFCeOpcoes nfceOpcoes, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos) throws ExceptionInvalidData {
        new AuxPagamentosV11().setInfPagamento(n, nfce, this.findOpcoesFinanceira(n.getEmpresa()), nfceOpcoes, opcoesContabeisBaixaTitulos, this.getOpcoesContabeis(n.getEmpresa()));
    }

    private void setInfPagamentoCupomDesconto(NotaFiscalPropria n) throws ExceptionObjectNotFound, ExceptionTitulo {
        new AuxPagamentosV11().getPagamentosCupomDesconto(n);
    }

    private void setLocalEntrega(NotaFiscalPropria n, NFCe nfce) {
        if (nfce.getEnderecoEntrega() != null && nfce.getEnderecoEntrega().getCpfCnpj() != null && !nfce.getEnderecoEntrega().getCpfCnpj().isEmpty()) {
            NFCeEnderecoEntrega ne = nfce.getEnderecoEntrega();
            LocalEntregaNFPropria l = n.getLocalEntregaNFPropria();
            if (l == null) {
                l = new LocalEntregaNFPropria();
            }
            l.setCnpjEnderecoEntrega(ne.getCpfCnpj());
            l.setNomeEnderecoEntrega(ne.getNomePessoaResp());
            if (ne.getBairro() != null && ne.getCep() != null && ne.getCidade() != null && ne.getLogradouro() != null && ne.getNumero() != null) {
                Endereco endNew = new Endereco();
                endNew.setBairro(ne.getBairro());
                endNew.setCep(ne.getCep());
                endNew.setCidade(ne.getCidade());
                endNew.setComplemento(ne.getComplemento());
                endNew.setLogradouro(ne.getLogradouro());
                endNew.setNumero(ne.getNumero());
                endNew.setObservacao(ne.getObservacao());
                endNew.setReferencia(ne.getReferencia());
                l.setEnderecoEntrega(endNew);
            }
            l.setNotaFiscalPropria(n);
            n.setLocalEntregaNFPropria(l);
            n.setInformarLocalEntregaNFPropria(Short.valueOf((short)1));
        }
    }

    private void setEventoCancelamento(NotaFiscalPropria n, NFCeCancelamento canc) {
        Integer status = n.getStatus().intValue();
        if (status.equals(EnumConstNFeStatus.CANCELADA.getValue()) && canc != null) {
            EvtNFeCancelamento e = n.getEvtNFeCancelamento();
            if (e == null) {
                e = new EvtNFeCancelamento();
                e.setDataCadastro(n.getDataCadastro());
                e.setDataAtualizacao(n.getDataAtualizacao());
                e.setEmpresa(n.getEmpresa());
            }
            e.setDataEvento(canc.getDataCancelamento());
            e.setJustificativaEvento(canc.getJustificativa());
            e.setMotivo(canc.getMotivo());
            e.setNotaFiscalPropria(n);
            e.setNrProtocolo(canc.getNrProtocoloCancelamento());
            e.setNumSeqEvento(Long.valueOf(1L));
            e.setNumeroNota(n.getNumeroNota().toString());
            e.setChave(n.getChaveNFE());
            e.setStatus(Short.valueOf(canc.getStatus().shortValue()));
            e.setUsuario(canc.getUsuario());
            n.setEvtNFeCancelamento(e);
        }
    }

    private void setInutilizacaoNFe(NotaFiscalPropria n, InutilizacaoNumeracaoNFe inutilizacaoNFe) {
        Integer statusInutilizada = EnumConstNFeStatus.INUTILIZADA.getValue();
        if (inutilizacaoNFe != null && inutilizacaoNFe.getStatus() != null && inutilizacaoNFe.getStatus().equals(statusInutilizada.toString())) {
            InutilizacaoNumeracaoNFe i = n.getInutilizacaoNFe();
            if (i == null) {
                i = new InutilizacaoNumeracaoNFe();
            }
            i.setChaveID(inutilizacaoNFe.getChaveID());
            i.setConteudoEnviado(inutilizacaoNFe.getConteudoEnviado());
            i.setConteudoInutilizacao(inutilizacaoNFe.getConteudoInutilizacao());
            i.setDataCadastro(inutilizacaoNFe.getDataCadastro());
            i.setEmpresa(inutilizacaoNFe.getEmpresa());
            i.setEnviado(inutilizacaoNFe.getEnviado());
            i.setJustificativa(inutilizacaoNFe.getJustificativa());
            i.setModeloDocFiscal(inutilizacaoNFe.getModeloDocFiscal());
            i.setMotivo(inutilizacaoNFe.getMotivo());
            i.setNaoEnviarNotaSefaz(inutilizacaoNFe.getNaoEnviarNotaSefaz());
            i.setNumProtocolo(inutilizacaoNFe.getNumProtocolo());
            i.setNumeroInicial(inutilizacaoNFe.getNumeroInicial());
            i.setNumeroFinal(inutilizacaoNFe.getNumeroFinal());
            i.setPeriodo(inutilizacaoNFe.getPeriodo());
            i.setSerie(inutilizacaoNFe.getSerie());
            i.setSerialForSinc(inutilizacaoNFe.getSerialForSinc());
            i.setStatus(inutilizacaoNFe.getStatus());
            i.setTipoEmissaoNFe(inutilizacaoNFe.getTipoEmissaoNFe());
            i.setNotaFiscalPropria(n);
            n.setInutilizacaoNFe(i);
            n.setStatus(Short.valueOf(inutilizacaoNFe.getStatus()));
            n.setMotivo(inutilizacaoNFe.getMotivo());
        }
    }

    private NFCeOpcoes findOpcoesNFCe(Empresa empresa) {
        return this.sharedData.getOpcoesNFCe(empresa);
    }

    private OpcoesFinanceiras findOpcoesFinanceira(Empresa empresa) {
        return this.sharedData.getOpcoesFinanceiras(empresa);
    }

    private OpcoesContabeisBaixaTitulos getOpcoesContabeisBaixaTitulos(ClassificacaoClientes classificacaoClientes) throws ExceptionObjectNotFound {
        OpcoesContabeisBaixaTitulos found = this.hashOpcoesContabeisBaixaTitulos.get(classificacaoClientes);
        if (found == null) {
            found = this.daoOpcoesContabeisBaixaTitulos.findOpcoesContabeisBaixaTituloPorClassificacaoCliente(classificacaoClientes);
            if (found == null) {
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0051.001", new Object[]{classificacaoClientes}));
            }
            this.hashOpcoesContabeisBaixaTitulos.put(classificacaoClientes, found);
        }
        return found;
    }

    private OpcoesContabeis getOpcoesContabeis(Empresa empresa) throws ExceptionObjectNotFound {
        return this.sharedData.getOpcoesContabeis(empresa);
    }

    private MeioPagamento getMeioPagamento(NFCe nfce) {
        return nfce.getCondicoesPagamento() != null ? nfce.getCondicoesPagamento().getMeioPagamento() : null;
    }

    private Date getDataEntradaSaida(NFCe nfce) {
        return nfce.getDataPrevSaida() != null ? nfce.getDataPrevSaida() : nfce.getDataEmissao();
    }

    private NotaFiscalPropria castNFCeInNotaFiscalPropria(NFCe nfce) throws ExceptionParametrizacao, ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        NotaFiscalPropria n = this.getNotaFiscalPropria(nfce);
        if (n == null) {
            n = new NotaFiscalPropria();
            n.setSerialForSinc(nfce.getSerialForSinc());
            n.setDataCadastro(new Date());
            n.setDataAtualizacao(nfce.getDataAtualizacao());
            n.setGeradaNFCe(Short.valueOf((short)1));
        }
        n.setSituacaoDocumento(this.getBean(ServiceSituacaoDocumentoImpl.class).getByCodigo(nfce.getStatus()));
        n.setNfceControleCaixa(nfce.getNfCeControleCaixa());
        n.setSerie(nfce.getSerie());
        n.setSerieInf(nfce.getSerie());
        n.setChaveNFE(nfce.getChaveNFCe());
        n.setChaveNFEInf(nfce.getChaveNFCe());
        n.setCodChaveAcesso(nfce.getNumeroRandomico());
        n.setNumeroNota(Integer.valueOf(nfce.getNumero().intValue()));
        n.setNumeroNotaInf(Integer.valueOf(nfce.getNumero().intValue()));
        n.setEmpresa(nfce.getEmpresa());
        String digitoVerificador = nfce.getChaveNFCe().substring(43);
        n.setDigitoVerificador(Integer.valueOf(digitoVerificador));
        n.setUnidadeFatCliente(nfce.getUnidadeFatCliente());
        if (n.getUnidadeFatCliente() != null) {
            n.setClassificacaoCliente(n.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            n.setCategoriaPessoa(n.getUnidadeFatCliente().getCategoriaPessoa());
        } else {
            n.setClassificacaoCliente(this.findOpcoesFinanceira(n.getEmpresa()).getClassificacaoClientes());
        }
        n.setTipoIntermediadorComercial(nfce.getTipoIntermediadorComercial());
        n.setIntermediadorComercial(nfce.getIntermediadorComercial());
        n.setNaturezaOperacao(nfce.getNaturezaOperacao());
        n.setModeloDocFiscal(nfce.getModeloDocFiscal());
        n.setDataEmissaoNota(nfce.getDataEmissao());
        n.setVersaoNfe(nfce.getVersaoNfe());
        if (nfce.getPeriodoEmissaoNFe() != null) {
            n.setPeriodoEmissaoNFe(nfce.getPeriodoEmissaoNFe());
            n.setTipoEmissao(nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe().getCodigo());
        }
        n.setFinalidadeEmNFe(nfce.getFinalidadeEmNFe());
        n.setFinalidadeEmNFeTipo(nfce.getFinalidadeEmNFeTipo());
        n.setMotivo(nfce.getMotivo());
        n.setFormatoImpressao(Short.valueOf(nfce.getFormatoImpressao()));
        n.setStatus(Short.valueOf(nfce.getStatus().shortValue()));
        n.setNrProtocolo(nfce.getNrProtocolo());
        n.setKm(nfce.getKm());
        n.setPlacaVeiculo(nfce.getPlacaVeiculo());
        n.setDataEntradaSaida(this.getDataEntradaSaida(nfce));
        n.setLiberarImpDanfe(Short.valueOf(EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus()) ? (short)1 : 0));
        n.setHoraEmissao(nfce.getDataEmissao());
        n.setHoraEntradaSaida(nfce.getDataEmissao());
        n.setContribuinteEstado(this.getContribuinteEstado(n));
        n.setMeioPagamento(this.getMeioPagamento(nfce));
        n.setPessoaAutorizada(nfce.getPessoaAutorizada());
        n.setRepresentante(nfce.getRepresentante());
        n.setIndicadorConsumidorFinal(nfce.getIndicadorConsumidorFinal());
        n.setIndicadorPresencaConsumidor(nfce.getIndicadorPresencaConsumidor());
        n.setTipoIntermediadorComercial(nfce.getTipoIntermediadorComercial());
        n.setIntermediadorComercial(nfce.getIntermediadorComercial());
        if (nfce.getPedido() != null) {
            this.criarExpedicaoPadrao(n, nfce.getPedido());
        }
        if (n.getPeriodoEmissaoNFe() == null) {
            String tipoEmissao = n.getChaveNFE().substring(34, 35);
            n.setPeriodoEmissaoNFe(this.getPeriodoEmissaoNFeFromTipoEmissao(n.getEmpresa(), tipoEmissao));
        }
        if (n.getFinalidadeEmNFe() == null) {
            n.setFinalidadeEmNFe(n.getNaturezaOperacao().getFinalidadeEmNFe());
        }
        if (n.getFinalidadeEmNFeTipo() == null) {
            n.setFinalidadeEmNFeTipo(n.getNaturezaOperacao().getFinalidadeEmNFeTipo());
        }
        NFCeOpcoes nfceOpcoes = this.findOpcoesNFCe(n.getEmpresa());
        this.setObsContribuinte(n, nfce, nfceOpcoes);
        this.setObsFisco(n, nfce, nfceOpcoes);
        this.setValoresNFPropria(n, nfce);
        this.setDadosTransNfPropria(n, nfce);
        this.setItensNotaPropria(n, nfce);
        this.setVolumes(n, nfce);
        this.setLocalEntrega(n, nfce);
        this.setEventoCancelamento(n, nfce.getNfCeCancelamento());
        this.setInutilizacaoNFe(n, nfce.getInutilizacaoNFe());
        this.setLivroFiscalAndTituloCrediario(n);
        this.contabilizarNota(n);
        n.setVersaoPdv(nfce.getVersaoPdv());
        return n;
    }

    private void setLivroFiscalAndTituloCrediario(NotaFiscalPropria notaPropria) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        if (EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)notaPropria.getStatus().intValue())) {
            this.gerarLivrosFiscais(notaPropria);
            if (this.isCrediario(notaPropria) && EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)notaPropria.getStatus().intValue())) {
                this.gerarTitulosCrediario(notaPropria);
            }
        }
    }

    private void gerarTitulosCrediario(NotaFiscalPropria aux) throws ExceptionObjectNotFound, ExceptionTitulo, ExceptionInvalidData {
        OpcoesFinanceiras opcoesFinanceiras = this.findOpcoesFinanceira(aux.getEmpresa());
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.getOpcoesContabeisBaixaTitulos(aux.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        Pessoa pessoa = aux.getUnidadeFatCliente().getCliente().getPessoa();
        PlanoConta pc = this.scPlanoConta.getPlanoConta(aux.getUnidadeFatCliente().getCliente(), this.getOpcoesContabeis(aux.getEmpresa()));
        ClassificacaoClientes classificacao = aux.getUnidadeFatCliente().getCliente().getClassificacaoClientes();
        ((CompGeracaoTitulos)Context.get(CompGeracaoTitulos.class)).gerarTitulos(aux, opcoesFinanceiras, pessoa, pc, classificacao);
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(aux, this.getTitulos(aux), aux.getEmpresa(), opcoesContabeisBaixaTitulos);
    }

    private void gerarLivrosFiscais(NotaFiscalPropria aux) {
        if (aux.getLivrosFiscais() == null) {
            aux.setLivrosFiscais(new ArrayList());
        } else {
            aux.getLivrosFiscais().clear();
        }
        aux.getLivrosFiscais().addAll(this.getLivrosFiscaisNFe(aux));
    }

    private List<LivroFiscal> getLivrosFiscaisNFe(NotaFiscalPropria aux) {
        return CompLivroFiscal.gerarLivrosFiscaisNFe(aux.getModeloDocFiscal(), aux.getSituacaoDocumento(), aux.getDataEmissaoNota(), aux.getItensNotaPropria());
    }

    private boolean isCrediario(NotaFiscalPropria aux) {
        for (InfPagamentoNfPropria pag : aux.getInfPagamentoNfPropria()) {
            if (!pag.getTipoPagamentoNFe().getCodigo().equals("05")) continue;
            return true;
        }
        return false;
    }

    private boolean isBoleto(NotaFiscalPropria aux) {
        for (InfPagamentoNfPropria pag : aux.getInfPagamentoNfPropria()) {
            if (!pag.getTipoPagamentoNFe().getCodigo().equals("15")) continue;
            return true;
        }
        return false;
    }

    private List<Titulo> getTitulos(NotaFiscalPropria n) {
        ArrayList<Titulo> aux = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria inf : n.getInfPagamentoNfPropria()) {
            aux.addAll(inf.getTitulos());
        }
        return aux;
    }

    private NotaFiscalPropria getNotaFiscalPropria(NFCe nfce) {
        try {
            NotaFiscalPropria n = this.serviceNFe.getBySerial(nfce.getSerialForSinc());
            if (n != null) {
                return n;
            }
            n = this.serviceNFe.get(nfce.getNumero(), nfce.getSerie(), nfce.getModeloDocFiscal(), nfce.getEmpresa());
            if (n != null) {
                n.setSerialForSinc(nfce.getSerialForSinc());
            }
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private PeriodoEmissaoNFe getPeriodoEmissaoNFeFromTipoEmissao(Empresa empresa, String tipoEmissao) {
        return this.servicePeriodoEmissaoNFe.findPeriodoEmissaoNFeAtivoFromTipoEmissao(empresa, tipoEmissao);
    }

    private void gerarXMLNFPropria(List<NotaFiscalPropria> toSave, List<DTONFCeV11> listNfce) {
        for (NotaFiscalPropria nf : toSave) {
            String xml = null;
            String xmlAutorizacao = null;
            for (DTONFCeV11 nfce : listNfce) {
                if (!ToolMethods.isEquals((Object)nf.getSerialForSinc(), (Object)nfce.getSerialForSinc())) continue;
                if (nfce.getXml() != null) {
                    xml = new String(nfce.getXml());
                }
                if (nfce.getXmlAutorizacao() == null) break;
                xmlAutorizacao = new String(nfce.getXmlAutorizacao());
                break;
            }
            if (xml == null && xmlAutorizacao == null) continue;
            XMLNfePropria x = this.serviceXMLNFePropria.getOrCreateXMLNfePropria(nf.getIdentificador());
            x.setIdNotaPropria(nf.getIdentificador());
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            sb.append(xml);
            x.setConteudoXML(sb.toString());
            x.setConteudoAprovacao(xmlAutorizacao);
            this.serviceXMLNFePropria.saveOrUpdate((Object)x);
        }
    }

    private void contabilizarNota(NotaFiscalPropria n) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        this.compLancamentos.contabilizar(n, this.getOpcoesContabeis(n.getEmpresa()));
    }

    private void setVolumes(NotaFiscalPropria n, NFCe nfce) {
        n.getVolumes().clear();
        for (NFCeVolume v : nfce.getVolumes()) {
            VolumeNFe vl = new VolumeNFe();
            vl.setEmbalagem(v.getEmbalagem());
            vl.setMarca(v.getMarca());
            vl.setNotaFiscalPropria(n);
            vl.setNumeroVolume(v.getNumeroVolume());
            vl.setPesoBruto(v.getPesoBruto());
            vl.setPesoLiquido(vl.getPesoLiquido());
            vl.setQuantidade(vl.getQuantidade());
            n.getVolumes().add(vl);
        }
    }

    private Short getContribuinteEstado(NotaFiscalPropria n) {
        if (n.getUnidadeFatCliente() == null) {
            return EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId();
        }
        switch (EnumConstContrEstadoIcms.get((Object)n.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado())) {
            case CONTRIBUINTE: {
                return EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId();
            }
            case ISENTO: {
                return EnumConstContrEstadoIcms.ISENTO.getEnumId();
            }
        }
        return EnumConstContrEstadoIcms.NAO_CONTRIBUINTE.getEnumId();
    }

    private void criarExpedicaoPadrao(NotaFiscalPropria n, Pedido pedido) {
        Expedicao e = ((CompExpedicao)Context.get(CompExpedicao.class)).getExpedicaoAberta(pedido);
        e.setJustificativa("Expedicao gerada pela pre venda NFCe");
        if (ToolMethods.isWithData((Collection)pedido.getInfPagamentoPedido())) {
            for (InfPagamentoPedido inf : pedido.getInfPagamentoPedido()) {
                if (!ToolMethods.isWithData((Collection)inf.getTitulos())) continue;
                inf.getTitulos().clear();
            }
            for (ItemPedido itemPedido : pedido.getItemPedido()) {
                for (GradeItemPedido g : itemPedido.getGradeItemPedido()) {
                    g.setMovimentacaoFisica(Short.valueOf((short)0));
                }
            }
        }
        e = this.serviceExpedicao.saveOrUpdate(e);
        n.setExpedicao(e);
        e.setNotaFiscalPropria(n);
    }
}

