/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfe;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementorservice.dao.impl.DaoNFeImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.converters.DTONFCeControleCaixaConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePeriodoEmissaoConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePeriodoEmissaoNFeConverter;
import com.touchcomp.basementorservice.service.converters.DTONFCePreAbastecimentoConverter;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceNFeImpl
extends ServiceGenericEntityImpl<NotaFiscalPropria, Long, DaoNFeImpl> {
    @Autowired
    private DTONFCePeriodoEmissaoConverter periodoEmissaoConverter;
    @Autowired
    private DTONFCePeriodoEmissaoNFeConverter periodoEmissaoNFeConverter;
    @Autowired
    private DTONFCeControleCaixaConverter controleCaixaConverter;
    @Autowired
    private DTONFCePreAbastecimentoConverter preAbastecimento;

    public ServiceNFeImpl(DaoNFeImpl repository) {
        super(repository);
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public NotaFiscalPropria getBySerial(String serialForSinc) {
        return this.getRepository().getBySerialForSinc(serialForSinc);
    }

    public DaoNFeImpl getRepository() {
        return (DaoNFeImpl)super.getGenericDao();
    }

    @Override
    public NotaFiscalPropria getObjectIfExists(Object aux) {
        return null;
    }

    @Override
    public NotaFiscalPropria beforeSave(NotaFiscalPropria aux) {
        return super.beforeSave(aux);
    }

    @Override
    protected void addCustomConverters(ToolDTOBuilder builder) {
        builder.addDTOConverter((DTOEntityConversor)this.periodoEmissaoConverter);
        builder.addDTOConverter((DTOEntityConversor)this.periodoEmissaoNFeConverter);
        builder.addDTOConverter((DTOEntityConversor)this.controleCaixaConverter);
        builder.addDTOConverter((DTOEntityConversor)this.preAbastecimento);
    }

    NotaFiscalPropria get(Long numero, String serie, ModeloDocFiscal modeloDocFiscal, Empresa empresa) {
        if (ToolMethods.isEquals((Object)numero, null) || !ToolMethods.isStrWithData((String)serie) || ToolMethods.isEquals((Object)modeloDocFiscal, null) || ToolMethods.isEquals((Object)empresa, null)) {
            return null;
        }
        return this.getRepository().getNotaPropriaOthersAtributos(numero, serie, modeloDocFiscal, empresa);
    }
}

