/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfe.auxiliar.v13;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxItensV13 {
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    private ServiceModeloFiscalImpl serviceModeloFiscal = (ServiceModeloFiscalImpl)Context.get(ServiceModeloFiscalImpl.class);

    public void setItensNotaPropria(NotaFiscalPropria n, NFCe nfce, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSinc(n.getItensNotaPropria(), nfce.getItens())) {
            aux.addAll(n.getItensNotaPropria());
        }
        LinkedList<ItemNotaFiscalPropria> added = new LinkedList<ItemNotaFiscalPropria>();
        for (NFCeItem item : nfce.getItens()) {
            if (!item.getStatus().equals((short)1) && !EnumConstNFeStatus.isStatusCancelada((Integer)n.getStatus().intValue())) continue;
            Optional<ItemNotaFiscalPropria> found = aux.stream().filter(it -> ToolMethods.isEquals((Object)it.getSerialForSinc(), (Object)item.getSerialForSinc())).findFirst();
            ItemNotaFiscalPropria i = found.isPresent() ? found.get() : new ItemNotaFiscalPropria();
            added.add(i);
            i.setNotaFiscalPropria(n);
            i.setCentroEstoque(item.getCentroEstoque());
            if (item.getIpi() != null) {
                i.setClasseEnquadramentoIpi(item.getIpi().getClasseEnqIpi());
            }
            i.setSerialForSinc(item.getSerialForSinc());
            i.setDescontoItem(item.getPercValorDesconto());
            i.setFreteItem(item.getPercValorFrete());
            i.setSeguroItem(item.getPercValorSeguro());
            i.setDespAcessItem(item.getPercValorDespAcess());
            i.setFatorConversao(Double.valueOf(1.0));
            i.setGerarFinanceiro(Short.valueOf((short)1));
            i.setIncidenciaIcms(item.getIcms().getIncidenciaIcms());
            i.setIncidenciaIpi(item.getIpi().getIncidenciaIpi());
            i.setIncidenciaPisCofins(item.getPis().getIncidenciaPisCofins());
            i.setIndicadorTotal(Short.valueOf((short)1));
            i.setInfAdicionalItem(item.getInfAdicionalProd());
            i.setModalidadeIcms(item.getIcms().getModalidadeIcms());
            i.setModeloFiscal(item.getModeloFiscal());
            i.setMotivoDesoneracaoIcms(item.getIcms().getMotivoDesoneracaoIcms());
            if (item.getNumeroPedidoItemCliente() != null) {
                i.setNrItemPedido(item.getNumeroPedidoItemCliente().toString());
            }
            i.setNrPedido(item.getNumeroPedidoCliente());
            i.setNumeroItem(item.getNumeroItem());
            i.setPercComissao(item.getPercentualComissao());
            i.setPercDesconto(item.getPercentualDesconto());
            i.setPercFrete(item.getPercentualFrete());
            i.setPercSeguro(item.getPercentualSeguro());
            i.setPercDespAcessoria(item.getPercentualDespAcess());
            i.setProduto(item.getProduto());
            i.setQuantidadeTotal(item.getQuantidadeComercial());
            i.setQuantidadeTotalTrib(item.getQuantidadeTributaria());
            i.setRepresentante(item.getRepresentante());
            i.setUnidadeMedida(item.getProduto().getUnidadeMedida());
            i.setUnidadeMedidaTrib(item.getProduto().getUnidadeMedida());
            i.setValorDesconto(item.getValorDesconto());
            i.setValorFrete(item.getValorFrete());
            i.setVrSeguro(item.getValorSeguro());
            i.setValorDespAcessoria(item.getValorDespesasAcessorias());
            i.setValorUnitario(item.getValorUnitarioComercial());
            i.setValorUnitarioTrib(item.getValorUnitarioTributario());
            i.setVrProduto(item.getValorTotalBruto());
            i.setCest(i.getProduto().getCest());
            i.setNcm(i.getProduto().getNcm());
            i.setPreAbastecimento(item.getPreAbastecimento());
            i.setValorDescontoItemInf(item.getValorDescontoInf());
            i.setValorDescontoRateado(item.getValorDescontoRat());
            i.setValorFreteItemInf(item.getValorFreteInf());
            i.setValorFreteRateado(item.getValorFreteRat());
            i.setValorSeguroItemInf(item.getValorSeguroInf());
            i.setValorSeguroRateado(item.getValorSeguroRat());
            i.setValorDespAcessItemInf(item.getValorDespesasAcessoriasInf());
            i.setValorDespAcessRateado(item.getValorDespesasAcessoriasRat());
            i.setPercDescontoItemInf(item.getPercentualDescontoInf());
            i.setPercDescontoRateado(item.getPercentualDescontoRat());
            i.setPercFreteItemInf(item.getPercentualFreteInf());
            i.setPercFreteRateado(item.getPercentualFreteRat());
            i.setPercSeguroItemInf(item.getPercentualSeguroInf());
            i.setPercSeguroRateado(item.getPercentualSeguroRat());
            i.setPercDespAcessItemInf(item.getPercentualDespAcessInf());
            i.setPercDespAcessRateado(item.getPercentualDespAcessRat());
            i.setNrLoteFabricacao(item.getNrLoteFabricacao());
            i.setDataFabricacao(item.getDataFabricacao());
            i.setDataValidade(item.getDataValidade());
            new HelperItemNotaPropria(i).setNatReceitaPisCofins();
            this.setItemNotaLivroFiscal(i, item);
            this.setGradesItemNotaPropria(i, item, nfce);
            this.setContasContabeisGerenciais(i, opcoes);
            n.getItensNotaPropria().add(i);
        }
        n.getItensNotaPropria().clear();
        n.getItensNotaPropria().addAll(added);
    }

    private void setContasContabeisGerenciais(ItemNotaFiscalPropria item, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        CompParametrizacaoContabilNF.DadosContas dados = new CompParametrizacaoContabilNF().getPlanoContasNfPropria(item.getModeloFiscal(), item.getProduto(), item.getNotaFiscalPropria().getUnidadeFatCliente(), item.getNotaFiscalPropria().getNaturezaOperacao(), item.getNotaFiscalPropria().getEmpresa(), item.getNotaFiscalPropria().getUnidadeFatCliente().getCategoriaPessoa(), opcoes, item.getItemNotaLivroFiscal().getCfop());
        item.setPlanoContaCred(dados.getPlanoContaCred());
        item.setPlanoContaDeb(dados.getPlanoContaDeb());
        item.setPlanoContaGerencial(dados.getPcGerencial());
    }

    private void setItemNotaLivroFiscal(ItemNotaFiscalPropria itemNota, NFCeItem item) {
        ItemNotaLivroFiscal i = itemNota.getItemNotaLivroFiscal();
        if (i == null) {
            i = new ItemNotaLivroFiscal();
        }
        i.setItemNotaFiscalPropria(itemNota);
        itemNota.setItemNotaLivroFiscal(i);
        i.setCfop(item.getCfop());
        i.setAliqImpostosEstimada(item.getPercTributosPrevistos());
        i.setVlrImpostosEstimado(item.getValorTotalTributos());
        i.setAliquotaCofins(item.getCofins().getAliquota());
        i.setAliquotaCofinsQtde(item.getCofins().getAliquotaQuantidade());
        i.setVrCofins(item.getCofins().getValor());
        i.setVrBCCofins(item.getCofins().getValorBaseCalculo());
        i.setAliquotaPis(item.getPis().getAliquota());
        i.setAliquotaPisQtde(item.getPis().getAliquotaQuantidade());
        i.setVrPis(item.getPis().getValor());
        i.setVrBCPis(item.getPis().getValorBaseCalculo());
        i.setAliquotaIcms(item.getIcms().getAliquotaIcms());
        i.setVrIcms(item.getIcms().getValorIcms());
        i.setVrIcmsTributado(item.getIcms().getValorIcmsTributado());
        i.setVrIcmsIsento(item.getIcms().getValorIcmsIsento());
        i.setVrIcmsDesonerado(item.getIcms().getValorIcmsDesonerado());
        i.setVrIcmsOutros(item.getIcms().getValorIcmsOutros());
        i.setValorICMSSimples(item.getIcms().getValorIcmsSimples());
        i.setValorIcmsDiferimento(item.getIcms().getValorIcmsDiferimento());
        i.setVrICMSSTRet(item.getIcms().getValorIcmsStRetido());
        i.setVrBCICMSSTRet(item.getIcms().getValorBcCalculoIcmsStRetido());
        i.setValorUnidIcmsSTRetAnt(item.getIcms().getValorUnidIcmsSTRetAnt());
        i.setValorUnidBCIcmsSTRetAnt(item.getIcms().getValorUnidBCIcmsSTRetAnt());
        i.setVrBcCalculoIcms(item.getIcms().getValorBcCalculoIcms());
        i.setVrNaoTribICMS(Double.valueOf(item.getIcms().getVrNaoTribIcms() != null ? item.getIcms().getVrNaoTribIcms() : 0.0));
        i.setPercReducaoBCIcms(item.getIcms().getPercRedBCIcms());
        i.setValorTotal(item.getValorTotal());
    }

    private void setGradesItemNotaPropria(ItemNotaFiscalPropria i, NFCeItem item, NFCe nfce) {
        if (i.getGradesNotaFiscalPropria() == null) {
            i.setGradesNotaFiscalPropria(new ArrayList());
        }
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        if (i.getGradesNotaFiscalPropria().size() == 1) {
            g = (GradeItemNotaFiscalPropria)i.getGradesNotaFiscalPropria().get(0);
        } else {
            i.getGradesNotaFiscalPropria().clear();
        }
        g.setGradeCor(item.getGradeCor());
        g.setDataEntradaSaida(i.getNotaFiscalPropria().getDataEmissaoNota());
        g.setMovimentacaoFisica(Short.valueOf(EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus()) ? this.serviceModeloFiscal.movimentacaoFisicaByModelo(i.getModeloFiscal().getIdentificador()) : (short)0));
        g.setQuantidade(item.getQuantidadeComercial());
        g.setItemNotaFiscalPropria(i);
        g.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(item.getGradeCor()));
        g.setEmpresa(nfce.getEmpresa());
        g.setCentroEstoque(item.getCentroEstoque());
        g.setValorCusto(item.getValorCusto());
        i.setCentroEstoque(item.getCentroEstoque());
        this.gerenciarEstoqueTerceiros(g);
        i.getGradesNotaFiscalPropria().add(g);
    }

    private boolean checkIfContainsSerialForSinc(List<ItemNotaFiscalPropria> itensNotaPropria, List<NFCeItem> itens) {
        Optional<NFCeItem> found1 = itens.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<ItemNotaFiscalPropria> found2 = itensNotaPropria.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private void gerenciarEstoqueTerceiros(GradeItemNotaFiscalPropria g) {
        if (g.getItemNotaFiscalPropria() != null && g.getItemNotaFiscalPropria().getNotaFiscalPropria() != null && g.getItemNotaFiscalPropria().getNotaFiscalPropria().getNaturezaOperacao() != null) {
            NaturezaOperacao naturezaOperacao = g.getItemNotaFiscalPropria().getNotaFiscalPropria().getNaturezaOperacao();
            UnidadeFatCliente unidadeFatCliente = g.getItemNotaFiscalPropria().getNotaFiscalPropria().getUnidadeFatCliente();
            if ((naturezaOperacao.getTipoEstoque() == 1 || naturezaOperacao.getTipoEstoque() == 3 || naturezaOperacao.getTipoEstoque() == 4 || naturezaOperacao.getTipoEstoque() == 2 || naturezaOperacao.getTipoEstoque() == 10 || naturezaOperacao.getTipoEstoque() == 11 || naturezaOperacao.getTipoEstoque() == 6) && g.getEstoqueTerceiros() == null && unidadeFatCliente != null) {
                EstoqueTerceiros estoqueTerceiros = new EstoqueTerceiros();
                estoqueTerceiros.setPessoaParceiro(unidadeFatCliente.getPessoa());
                estoqueTerceiros.setNaturezaOperacao(naturezaOperacao);
                estoqueTerceiros.setData(g.getItemNotaFiscalPropria().getNotaFiscalPropria().getDataEmissaoNota());
                estoqueTerceiros.setEmpresa(g.getItemNotaFiscalPropria().getNotaFiscalPropria().getEmpresa());
                estoqueTerceiros.setGradeItemNotaPropria(g);
                estoqueTerceiros.setQuantidade(g.getQuantidade());
                g.setEstoqueTerceiros(estoqueTerceiros);
            }
        }
    }
}

