/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfe.auxiliar.v13;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.BaixaTituloAntecipado;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CupomDesconto;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.InfPagNfPropriaChequeTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeChequeTerceiros;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.NFCeTitulo;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorservice.helpers.impl.titulo.HelperTitulos;
import com.touchcomp.basementorservice.service.impl.cupomdesconto.ServiceCupomDescontoImpl;
import com.touchcomp.basementorservice.service.impl.nfe.ServiceNFeImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxPagamentosV13 {
    ServiceNFeImpl serviceNFe = (ServiceNFeImpl)Context.get(ServiceNFeImpl.class);
    private SCompPlanoConta scPlanoConta = (SCompPlanoConta)Context.get(SCompPlanoConta.class);

    public void setInfPagamento(NotaFiscalPropria n, NFCe nfce, OpcoesFinanceiras opcoes, NFCeOpcoes nfceOpcoes, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSinc(nfce.getPagamentos(), n.getInfPagamentoNfPropria())) {
            aux.addAll(n.getInfPagamentoNfPropria());
        }
        LinkedList<InfPagamentoNfPropria> added = new LinkedList<InfPagamentoNfPropria>();
        InfPagamentoNfPropria inf = null;
        for (NFCePagamento pagNfce : nfce.getPagamentos()) {
            Optional<InfPagamentoNfPropria> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)pagNfce.getSerialForSinc())).findFirst();
            if (found.isPresent()) {
                inf = found.get();
            } else {
                inf = new InfPagamentoNfPropria();
                inf.setNotaFiscalPropria(n);
            }
            if (!ToolMethods.isAffirmative((Number)pagNfce.getStatus())) continue;
            added.add(inf);
            this.setInfoPag(inf, nfce, pagNfce, opcoes, nfceOpcoes, opcoesContabeis);
            inf.setNotaFiscalPropria(n);
        }
        n.getInfPagamentoNfPropria().clear();
        n.getInfPagamentoNfPropria().addAll(added);
        if (inf != null) {
            n.setMeioPagamento(inf.getMeioPagamento());
            n.setCondicaoPagamento(inf.getCondicoesPagamento());
        }
        HelperTitulos helper = (HelperTitulos)Context.get(HelperTitulos.class);
        helper.atualizaTitulosRep(n, opcoes);
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(n, this.getTitulos(n), n.getEmpresa(), opcoesContabeisBaixaTitulos);
    }

    private void setInfoPag(InfPagamentoNfPropria inf, NFCe nfce, NFCePagamento pag, OpcoesFinanceiras opcoes, NFCeOpcoes nfceOpcoes, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        inf.setBandeiraCartaoNFe(pag.getBandeiraCartaoNFe());
        inf.setBandeiraTEF(pag.getBandeiraTEF());
        inf.setCodigoBandeiraTEF(pag.getCodigoBandeiraTEF());
        inf.setMeioPagamento(pag.getMeioPagamento());
        inf.setNrAutorizacao(pag.getNrAutorizacao());
        inf.setCredenciadoraCreditoDebito(pag.getCredenciadoraCreditoDebito());
        inf.setTipoIntegracao(pag.getTipoIntegracao());
        inf.setTipoPagamentoNFe(pag.getTipoPagamentoNFe());
        inf.setValor(pag.getValorLiquido());
        inf.setValorBruto(pag.getValor());
        inf.setValorTroco(pag.getValorTroco());
        inf.setNumeroParcelas(pag.getNumeroParcelas());
        inf.setPermitirTEF(pag.getPermitirTEF());
        inf.setSerialForSinc(pag.getSerialForSinc());
        inf.setCondicoesPagamento(pag.getCondicoesPagamento());
        this.setTitulos(pag, opcoes, nfce, inf, nfceOpcoes, opcoesContabeis);
        this.setChequeTerceiros(nfce, pag, inf, opcoes);
        inf.setSerialForSincCupomDesconto(pag.getSerialForSincCupomDesconto());
    }

    private void setChequeTerceiros(NFCe nfce, NFCePagamento pag, InfPagamentoNfPropria infPag, OpcoesFinanceiras opcoes) {
        if (!ToolMethods.isWithData((Collection)pag.getChequeTerceiros())) {
            return;
        }
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSincCh(pag.getChequeTerceiros(), infPag.getChequeTerceiros())) {
            aux.addAll(infPag.getChequeTerceiros());
        }
        LinkedList<InfPagNfPropriaChequeTerceiros> added = new LinkedList<InfPagNfPropriaChequeTerceiros>();
        InfPagNfPropriaChequeTerceiros inf = null;
        for (NFCeChequeTerceiros cn : pag.getChequeTerceiros()) {
            Optional<InfPagNfPropriaChequeTerceiros> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)cn.getSerialForSinc())).findFirst();
            inf = found.isPresent() ? found.get() : new InfPagNfPropriaChequeTerceiros();
            added.add(inf);
            ChequeTerceiros c = inf.getChequeTerceiros();
            if (c == null) {
                c = new ChequeTerceiros();
            }
            c.setAgencia(cn.getAgencia());
            c.setAgenciaDC(cn.getAgenciaDC());
            c.setBanco(cn.getBanco());
            c.setC1c2c3(cn.getC1c2c3());
            c.setCodigoCMC(cn.getCodigoCMC());
            c.setCnpjTitular(cn.getCnpjTitular());
            c.setContaCorrente(cn.getContaCorrente());
            c.setContaCorrenteDC(cn.getContaCorrenteDC());
            c.setDataCadastro(new Date());
            c.setDataEntrada(cn.getDataEntrada());
            c.setDataVencimento(cn.getDataVencimento());
            c.setDataBomPara(cn.getDataBomPara());
            c.setEmpresa(nfce.getEmpresa());
            c.setNumero(cn.getNumero());
            c.setTitular(cn.getTitular());
            c.setSerialForSinc(cn.getSerialForSinc());
            c.setValor(cn.getValor());
            c.setValorSaldo(cn.getValor());
            if (nfce.getUnidadeFatCliente() != null) {
                c.setPessoa(nfce.getUnidadeFatCliente().getCliente().getPessoa());
            }
            c.setRepresentante(nfce.getRepresentante());
            if (nfce.getUnidadeFatCliente().getCliente().getClassificacaoClientes() != null) {
                c.setClassificacaoPessoa(nfce.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
            } else {
                c.setClassificacaoPessoa(opcoes.getClassificacaoClientes());
            }
            inf.setInfPagamentoNfPropria(infPag);
            inf.setChequeTerceiros(c);
        }
        infPag.getChequeTerceiros().clear();
        infPag.getChequeTerceiros().addAll(added);
    }

    private void setTitulos(NFCePagamento nfcePagamento, OpcoesFinanceiras opcoes, NFCe nfce, InfPagamentoNfPropria infPag, NFCeOpcoes nfceOpcoes, OpcoesContabeis opcoesContabeis) throws ExceptionInvalidData {
        LinkedList<Titulo> added = new LinkedList<Titulo>();
        if (!ToolMethods.isWithData((Collection)nfcePagamento.getTitulos()) || !this.isCreditoOrBoleto(nfcePagamento)) {
            infPag.getTitulos().clear();
            infPag.getTitulos().addAll(added);
            return;
        }
        ArrayList<Titulo> aux = new ArrayList<Titulo>();
        if (this.checkIfContainsSerialForSincTit(nfcePagamento.getTitulos(), infPag.getTitulos())) {
            aux.addAll(infPag.getTitulos());
        }
        Integer nrParcelas = nfcePagamento.getTitulos().size();
        for (NFCeTitulo nFCeTitulo : nfcePagamento.getTitulos()) {
            Optional<Titulo> found = aux.stream().filter(i -> ToolMethods.isEquals((Object)i.getSerialForSinc(), (Object)nFCeTitulo.getSerialForSinc())).findFirst();
            Titulo t = found.isPresent() ? found.get() : new Titulo();
            added.add(t);
            Pessoa pessoa = nfce.getUnidadeFatCliente().getCliente().getPessoa();
            PlanoConta pc = this.scPlanoConta.getPlanoConta(nfce.getUnidadeFatCliente().getCliente(), opcoesContabeis);
            ClassificacaoClientes classificacao = infPag.getNotaFiscalPropria().getClassificacaoCliente();
            if (classificacao == null) {
                classificacao = opcoes.getClassificacaoClientes();
            }
            t.setValor(nFCeTitulo.getValor());
            t.setDataVencimento(nFCeTitulo.getDataVencimento());
            t.setDataCadastro(nFCeTitulo.getDataCadastro());
            t.setNumParcTituloEstnota(nFCeTitulo.getNumeroParcela());
            t.setNumeroParcelas(Short.valueOf(nrParcelas.shortValue()));
            t.setPagRec(Short.valueOf((short)1));
            t.setProvisao(Short.valueOf((short)1));
            t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoes).getCarteiraCobranca(t.getPagRec()));
            t.setTipoDoc(opcoes.getTipoDocFinanceiro());
            t.setObservacao("T\u00edtulo " + nFCeTitulo.getNumeroParcela() + "/" + nrParcelas.shortValue());
            t.setValorMultaEmbutida(Double.valueOf(0.0));
            t.setValorJurosEmbutido(Double.valueOf(0.0));
            t.setPercMulta(Double.valueOf(0.0));
            t.setPercJurosMes(Double.valueOf(0.0));
            t.setDescontoFinanceiro(Double.valueOf(0.0));
            t.setValorAdicional(Double.valueOf(0.0));
            t.setPessoa(pessoa);
            t.setClassificacaoPessoa(classificacao);
            t.setTipoPessoa(EnumConstPessoa.CLIENTE.getEnumId());
            t.setDataEmissao(nFCeTitulo.getDataCadastro());
            t.setDataVencimentoBase(nFCeTitulo.getDataVencimento());
            t.setDataCompetencia(nFCeTitulo.getDataCadastro());
            t.setDataEntradaSaida(t.getDataCompetencia());
            t.setEmpresa(nfce.getEmpresa());
            t.setPlanoConta(pc);
            t.setSerialForSinc(nFCeTitulo.getSerialForSinc());
            t.setMeioPagamento(nfcePagamento.getMeioPagamento());
            t.setCartCobrancaDestino(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoes).getCarteiraCobrancaDestino(pessoa, nfcePagamento.getCondicoesPagamento()));
            t.setInfPagamentoNfPropria(infPag);
            this.setarJurosMultaDescontoTitulo(t, opcoes);
            aux.add(t);
        }
        infPag.getTitulos().clear();
        infPag.getTitulos().addAll(added);
    }

    private boolean checkIfContainsSerialForSinc(List<NFCePagamento> pagamentos, List<InfPagamentoNfPropria> infPagamentoNfPropria) {
        Optional<NFCePagamento> found1 = pagamentos.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<InfPagamentoNfPropria> found2 = infPagamentoNfPropria.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private boolean checkIfContainsSerialForSincCh(List<NFCeChequeTerceiros> chequeTerceiros, List<InfPagNfPropriaChequeTerceiros> chequeTerceirosNF) {
        Optional<NFCeChequeTerceiros> found1 = chequeTerceiros.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<InfPagNfPropriaChequeTerceiros> found2 = chequeTerceirosNF.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private boolean checkIfContainsSerialForSincTit(List<NFCeTitulo> titulos, List<Titulo> titulosNF) {
        Optional<NFCeTitulo> found1 = titulos.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<Titulo> found2 = titulosNF.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private boolean isCreditoOrBoleto(NFCePagamento pag) {
        return pag.getStatus().equals((short)1) && (pag.getTipoPagamentoNFe().getCodigo().equals("05") || pag.getTipoPagamentoNFe().getCodigo().equals("15"));
    }

    private List<Titulo> getTitulos(NotaFiscalPropria n) {
        ArrayList<Titulo> aux = new ArrayList<Titulo>();
        for (InfPagamentoNfPropria inf : n.getInfPagamentoNfPropria()) {
            aux.addAll(inf.getTitulos());
        }
        return aux;
    }

    public NotaFiscalPropria getPagamentosCupomDesconto(NotaFiscalPropria n) {
        Boolean achou = false;
        for (InfPagamentoNfPropria pag : n.getInfPagamentoNfPropria()) {
            ServiceCupomDescontoImpl service;
            CupomDesconto c;
            if (!ToolMethods.isWithData((Collection)pag.getTitulos()) || !ToolMethods.isStrWithData((String)pag.getSerialForSincCupomDesconto()) || (c = (service = (ServiceCupomDescontoImpl)ConfApplicationContext.getBean(ServiceCupomDescontoImpl.class)).getCupomBySerialForSinc(pag.getSerialForSincCupomDesconto())) == null) continue;
            Titulo tituloAntecipadoCupomDesconto = c.getTituloAntecipado();
            GrupoDeBaixa g = new GrupoDeBaixa();
            g.setDataCadastro(new Date());
            g.setDataLiquidacao(n.getDataEmissaoNota());
            g.setEmpresa(n.getEmpresa());
            g.setPagRec(Short.valueOf((short)1));
            GrupoDeBaixaFormas gf = new GrupoDeBaixaFormas();
            gf.setFormaPagamento(Short.valueOf((short)7));
            gf.setGrupoDeBaixa(g);
            Double saldoTituloAntecipado = tituloAntecipadoCupomDesconto.getValor();
            Double totalBaixas = 0.0;
            for (Titulo tituloGerado : pag.getTitulos()) {
                if (!(saldoTituloAntecipado > 0.0)) continue;
                BaixaTitulo b = new BaixaTitulo();
                b.setGrupoDeBaixaFormas(gf);
                if (saldoTituloAntecipado >= tituloGerado.getValor()) {
                    b.setValor(tituloGerado.getValor());
                    b.setTotalOperacao(tituloGerado.getValor());
                    saldoTituloAntecipado = saldoTituloAntecipado - b.getValor();
                } else {
                    b.setValor(saldoTituloAntecipado);
                    b.setTotalOperacao(saldoTituloAntecipado);
                    saldoTituloAntecipado = 0.0;
                }
                totalBaixas = totalBaixas + b.getValor();
                b.setTitulo(tituloGerado);
                gf.getBaixaTitulo().add(b);
            }
            BaixaTituloAntecipado bt = new BaixaTituloAntecipado();
            bt.setGrupoDeBaixaFormas(gf);
            bt.setTitulo(tituloAntecipadoCupomDesconto);
            bt.setDataBaixa(g.getDataLiquidacao());
            bt.setValor(totalBaixas);
            gf.getBaixaTitulosAntecipados().add(bt);
            g.getGrupoDeBaixaFormas().add(gf);
            pag.setGrupoDeBaixaCupomDesconto(g);
            pag.setCupomDesconto(c);
            achou = true;
        }
        if (achou.booleanValue()) {
            n = this.serviceNFe.saveOrUpdate(n);
        }
        return n;
    }

    public void setarJurosMultaDescontoTitulo(Titulo tit, OpcoesFinanceiras opcoes) {
        HelperTitulos helper = (HelperTitulos)Context.get(HelperTitulos.class);
        helper.setarPercJurosMultaDesconto(tit, opcoes);
    }
}

