/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nfe.auxiliar.v14;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.EstoqueTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaCbs;
import com.touchcomp.basementor.model.vo.ItemNotaPropriaIbs;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NFCeItemCbs;
import com.touchcomp.basementor.model.vo.NFCeItemIbs;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.helpers.impl.notapropria.HelperItemNotaPropria;
import com.touchcomp.basementorservice.service.impl.lotefabricacao.ServiceLoteFabricacaoImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxItensV14 {
    private ServiceLoteFabricacaoImpl serviceLoteFabricacao = (ServiceLoteFabricacaoImpl)Context.get(ServiceLoteFabricacaoImpl.class);
    private ServiceModeloFiscalImpl serviceModeloFiscal = (ServiceModeloFiscalImpl)Context.get(ServiceModeloFiscalImpl.class);

    public void setItensNotaPropria(NotaFiscalPropria n, NFCe nfce, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        LinkedList aux = new LinkedList();
        if (this.checkIfContainsSerialForSinc(n.getItensNotaPropria(), nfce.getItens())) {
            aux.addAll(n.getItensNotaPropria());
        }
        LinkedList<ItemNotaFiscalPropria> added = new LinkedList<ItemNotaFiscalPropria>();
        for (NFCeItem itemNFCe : nfce.getItens()) {
            if (!itemNFCe.getStatus().equals((short)1) && !EnumConstNFeStatus.isStatusCancelada((Integer)n.getStatus().intValue())) continue;
            Optional<ItemNotaFiscalPropria> found = aux.stream().filter(it -> ToolMethods.isEquals((Object)it.getSerialForSinc(), (Object)itemNFCe.getSerialForSinc())).findFirst();
            ItemNotaFiscalPropria i = found.isPresent() ? found.get() : new ItemNotaFiscalPropria();
            added.add(i);
            i.setNotaFiscalPropria(n);
            i.setCentroEstoque(itemNFCe.getCentroEstoque());
            if (itemNFCe.getIpi() != null) {
                i.setClasseEnquadramentoIpi(itemNFCe.getIpi().getClasseEnqIpi());
            }
            i.setSerialForSinc(itemNFCe.getSerialForSinc());
            i.setDescontoItem(itemNFCe.getPercValorDesconto());
            i.setFreteItem(itemNFCe.getPercValorFrete());
            i.setSeguroItem(itemNFCe.getPercValorSeguro());
            i.setDespAcessItem(itemNFCe.getPercValorDespAcess());
            i.setFatorConversao(Double.valueOf(1.0));
            i.setGerarFinanceiro(Short.valueOf((short)1));
            i.setIncidenciaIcms(itemNFCe.getIcms().getIncidenciaIcms());
            i.setIncidenciaIpi(itemNFCe.getIpi().getIncidenciaIpi());
            i.setIncidenciaPisCofins(itemNFCe.getPis().getIncidenciaPisCofins());
            i.setIndicadorTotal(Short.valueOf((short)1));
            i.setInfAdicionalItem(itemNFCe.getInfAdicionalProd());
            i.setModalidadeIcms(itemNFCe.getIcms().getModalidadeIcms());
            i.setModeloFiscal(itemNFCe.getModeloFiscal());
            i.setMotivoDesoneracaoIcms(itemNFCe.getIcms().getMotivoDesoneracaoIcms());
            if (itemNFCe.getNumeroPedidoItemCliente() != null) {
                i.setNrItemPedido(itemNFCe.getNumeroPedidoItemCliente().toString());
            }
            i.setNrPedido(itemNFCe.getNumeroPedidoCliente());
            i.setNumeroItem(itemNFCe.getNumeroItem());
            i.setPercComissao(itemNFCe.getPercentualComissao());
            i.setPercDesconto(itemNFCe.getPercentualDesconto());
            i.setPercFrete(itemNFCe.getPercentualFrete());
            i.setPercSeguro(itemNFCe.getPercentualSeguro());
            i.setPercDespAcessoria(itemNFCe.getPercentualDespAcess());
            i.setProduto(itemNFCe.getProduto());
            i.setQuantidadeTotal(itemNFCe.getQuantidadeComercial());
            i.setQuantidadeTotalTrib(itemNFCe.getQuantidadeTributaria());
            i.setRepresentante(itemNFCe.getRepresentante());
            i.setUnidadeMedida(itemNFCe.getProduto().getUnidadeMedida());
            i.setUnidadeMedidaTrib(itemNFCe.getProduto().getUnidadeMedida());
            i.setValorDesconto(itemNFCe.getValorDesconto());
            i.setValorFrete(itemNFCe.getValorFrete());
            i.setVrSeguro(itemNFCe.getValorSeguro());
            i.setValorDespAcessoria(itemNFCe.getValorDespesasAcessorias());
            i.setValorUnitario(itemNFCe.getValorUnitarioComercial());
            i.setValorUnitarioTrib(itemNFCe.getValorUnitarioTributario());
            i.setVrProduto(itemNFCe.getValorTotalBruto());
            i.setCest(i.getProduto().getCest());
            i.setNcm(i.getProduto().getNcm());
            i.setPreAbastecimento(itemNFCe.getPreAbastecimento());
            i.setValorDescontoItemInf(itemNFCe.getValorDescontoInf());
            i.setValorDescontoRateado(itemNFCe.getValorDescontoRat());
            i.setValorFreteItemInf(itemNFCe.getValorFreteInf());
            i.setValorFreteRateado(itemNFCe.getValorFreteRat());
            i.setValorSeguroItemInf(itemNFCe.getValorSeguroInf());
            i.setValorSeguroRateado(itemNFCe.getValorSeguroRat());
            i.setValorDespAcessItemInf(itemNFCe.getValorDespesasAcessoriasInf());
            i.setValorDespAcessRateado(itemNFCe.getValorDespesasAcessoriasRat());
            i.setPercDescontoItemInf(itemNFCe.getPercentualDescontoInf());
            i.setPercDescontoRateado(itemNFCe.getPercentualDescontoRat());
            i.setPercFreteItemInf(itemNFCe.getPercentualFreteInf());
            i.setPercFreteRateado(itemNFCe.getPercentualFreteRat());
            i.setPercSeguroItemInf(itemNFCe.getPercentualSeguroInf());
            i.setPercSeguroRateado(itemNFCe.getPercentualSeguroRat());
            i.setPercDespAcessItemInf(itemNFCe.getPercentualDespAcessInf());
            i.setPercDespAcessRateado(itemNFCe.getPercentualDespAcessRat());
            i.setNrLoteFabricacao(itemNFCe.getNrLoteFabricacao());
            i.setDataFabricacao(itemNFCe.getDataFabricacao());
            i.setDataValidade(itemNFCe.getDataValidade());
            new HelperItemNotaPropria(i).setNatReceitaPisCofins();
            this.setItemNotaLivroFiscal(i, itemNFCe);
            this.setGradesItemNotaPropria(i, itemNFCe, nfce);
            this.setContasContabeisGerenciais(i, opcoes);
            if (itemNFCe.getCbs() != null) {
                this.setItemCbs(i, itemNFCe);
            }
            if (itemNFCe.getIbs() != null) {
                this.setItemIbs(i, itemNFCe);
            }
            n.getItensNotaPropria().add(i);
        }
        n.getItensNotaPropria().clear();
        n.getItensNotaPropria().addAll(added);
    }

    private void setContasContabeisGerenciais(ItemNotaFiscalPropria item, OpcoesContabeis opcoes) throws ExceptionParametrizacao, ExceptionInvalidData {
        CompParametrizacaoContabilNF.DadosContas dados = new CompParametrizacaoContabilNF().getPlanoContasNfPropria(item.getModeloFiscal(), item.getProduto(), item.getNotaFiscalPropria().getUnidadeFatCliente(), item.getNotaFiscalPropria().getNaturezaOperacao(), item.getNotaFiscalPropria().getEmpresa(), item.getNotaFiscalPropria().getUnidadeFatCliente().getCategoriaPessoa(), opcoes, item.getItemNotaLivroFiscal().getCfop());
        item.setPlanoContaCred(dados.getPlanoContaCred());
        item.setPlanoContaDeb(dados.getPlanoContaDeb());
        item.setPlanoContaGerencial(dados.getPcGerencial());
    }

    private void setItemNotaLivroFiscal(ItemNotaFiscalPropria itemNota, NFCeItem item) {
        ItemNotaLivroFiscal i = itemNota.getItemNotaLivroFiscal();
        if (i == null) {
            i = new ItemNotaLivroFiscal();
        }
        i.setItemNotaFiscalPropria(itemNota);
        itemNota.setItemNotaLivroFiscal(i);
        i.setCfop(item.getCfop());
        i.setAliqImpostosEstimada(item.getPercTributosPrevistos());
        i.setVlrImpostosEstimado(item.getValorTotalTributos());
        i.setAliquotaCofins(item.getCofins().getAliquota());
        i.setAliquotaCofinsQtde(item.getCofins().getAliquotaQuantidade());
        i.setVrCofins(item.getCofins().getValor());
        i.setVrBCCofins(item.getCofins().getValorBaseCalculo());
        i.setAliquotaPis(item.getPis().getAliquota());
        i.setAliquotaPisQtde(item.getPis().getAliquotaQuantidade());
        i.setVrPis(item.getPis().getValor());
        i.setVrBCPis(item.getPis().getValorBaseCalculo());
        i.setAliquotaIcms(item.getIcms().getAliquotaIcms());
        i.setVrIcms(item.getIcms().getValorIcms());
        i.setVrIcmsTributado(item.getIcms().getValorIcmsTributado());
        i.setVrIcmsIsento(item.getIcms().getValorIcmsIsento());
        i.setVrIcmsDesonerado(item.getIcms().getValorIcmsDesonerado());
        i.setVrIcmsOutros(item.getIcms().getValorIcmsOutros());
        i.setValorICMSSimples(item.getIcms().getValorIcmsSimples());
        i.setValorIcmsDiferimento(item.getIcms().getValorIcmsDiferimento());
        i.setVrICMSSTRet(item.getIcms().getValorIcmsStRetido());
        i.setVrBCICMSSTRet(item.getIcms().getValorBcCalculoIcmsStRetido());
        i.setValorUnidIcmsSTRetAnt(item.getIcms().getValorUnidIcmsSTRetAnt());
        i.setValorUnidBCIcmsSTRetAnt(item.getIcms().getValorUnidBCIcmsSTRetAnt());
        i.setVrBcCalculoIcms(item.getIcms().getValorBcCalculoIcms());
        i.setVrNaoTribICMS(Double.valueOf(item.getIcms().getVrNaoTribIcms() != null ? item.getIcms().getVrNaoTribIcms() : 0.0));
        i.setPercReducaoBCIcms(item.getIcms().getPercRedBCIcms());
        i.setValorTotal(item.getValorTotal());
        i.setValorTotalItemDoc(item.getValorTotalItemDoc());
    }

    private void setGradesItemNotaPropria(ItemNotaFiscalPropria i, NFCeItem item, NFCe nfce) {
        if (i.getGradesNotaFiscalPropria() == null) {
            i.setGradesNotaFiscalPropria(new ArrayList());
        }
        GradeItemNotaFiscalPropria g = new GradeItemNotaFiscalPropria();
        if (i.getGradesNotaFiscalPropria().size() == 1) {
            g = (GradeItemNotaFiscalPropria)i.getGradesNotaFiscalPropria().get(0);
        } else {
            i.getGradesNotaFiscalPropria().clear();
        }
        g.setGradeCor(item.getGradeCor());
        g.setDataEntradaSaida(i.getNotaFiscalPropria().getDataEmissaoNota());
        g.setMovimentacaoFisica(Short.valueOf(EnumConstNFeStatus.isStatusAutorizadaOuContigencia((Integer)nfce.getStatus()) ? this.serviceModeloFiscal.movimentacaoFisicaByModelo(i.getModeloFiscal().getIdentificador()) : (short)0));
        g.setQuantidade(item.getQuantidadeComercial());
        g.setItemNotaFiscalPropria(i);
        g.setLoteFabricacao(this.serviceLoteFabricacao.findOrCreateLoteUnico(item.getGradeCor()));
        g.setEmpresa(nfce.getEmpresa());
        g.setCentroEstoque(item.getCentroEstoque());
        g.setValorCusto(item.getValorCusto());
        i.setCentroEstoque(item.getCentroEstoque());
        this.gerenciarEstoqueTerceiros(g);
        i.getGradesNotaFiscalPropria().add(g);
    }

    private boolean checkIfContainsSerialForSinc(List<ItemNotaFiscalPropria> itensNotaPropria, List<NFCeItem> itens) {
        Optional<NFCeItem> found1 = itens.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        Optional<ItemNotaFiscalPropria> found2 = itensNotaPropria.stream().filter(i -> !ToolMethods.isStrWithData((String)i.getSerialForSinc())).findFirst();
        if (found1.isPresent()) {
            return false;
        }
        return !found2.isPresent();
    }

    private void gerenciarEstoqueTerceiros(GradeItemNotaFiscalPropria g) {
        if (g.getItemNotaFiscalPropria() != null && g.getItemNotaFiscalPropria().getNotaFiscalPropria() != null && g.getItemNotaFiscalPropria().getNotaFiscalPropria().getNaturezaOperacao() != null) {
            NaturezaOperacao naturezaOperacao = g.getItemNotaFiscalPropria().getNotaFiscalPropria().getNaturezaOperacao();
            UnidadeFatCliente unidadeFatCliente = g.getItemNotaFiscalPropria().getNotaFiscalPropria().getUnidadeFatCliente();
            if ((naturezaOperacao.getTipoEstoque() == 1 || naturezaOperacao.getTipoEstoque() == 3 || naturezaOperacao.getTipoEstoque() == 4 || naturezaOperacao.getTipoEstoque() == 2 || naturezaOperacao.getTipoEstoque() == 10 || naturezaOperacao.getTipoEstoque() == 11 || naturezaOperacao.getTipoEstoque() == 6) && g.getEstoqueTerceiros() == null && unidadeFatCliente != null) {
                EstoqueTerceiros estoqueTerceiros = new EstoqueTerceiros();
                estoqueTerceiros.setPessoaParceiro(unidadeFatCliente.getPessoa());
                estoqueTerceiros.setNaturezaOperacao(naturezaOperacao);
                estoqueTerceiros.setData(g.getItemNotaFiscalPropria().getNotaFiscalPropria().getDataEmissaoNota());
                estoqueTerceiros.setEmpresa(g.getItemNotaFiscalPropria().getNotaFiscalPropria().getEmpresa());
                estoqueTerceiros.setGradeItemNotaPropria(g);
                estoqueTerceiros.setQuantidade(g.getQuantidade());
                g.setEstoqueTerceiros(estoqueTerceiros);
            }
        }
    }

    private void setItemCbs(ItemNotaFiscalPropria i, NFCeItem item) {
        ItemNotaPropriaCbs cbs = null;
        NFCeItemCbs nfceItemCbs = item.getCbs();
        if (i.getImpostoCBS() != null) {
            cbs = i.getImpostoCBS();
        } else {
            cbs = new ItemNotaPropriaCbs();
            i.setImpostoCBS(cbs);
        }
        cbs.setAliquotaCBS(nfceItemCbs.getAliquotaCBS());
        cbs.setAliquotaCredPresumidoCBS(nfceItemCbs.getAliquotaCredPresumidoCBS());
        cbs.setAliquotaEfetivaCBS(nfceItemCbs.getAliquotaEfetivaCBS());
        cbs.setAliquotaEspecificaCBS(nfceItemCbs.getAliquotaEspecificaCBS());
        cbs.setBaseCalculoCBS(nfceItemCbs.getBaseCalculoCBS());
        cbs.setPercRedAliquotaCBS(nfceItemCbs.getPercRedAliquotaCBS());
        cbs.setPercRedBC(nfceItemCbs.getPercRedBC());
        cbs.setValorCBS(nfceItemCbs.getValorCBS());
        cbs.setValorCredPresCBS(nfceItemCbs.getValorCredPresCBS());
        cbs.setValorDevCBS(nfceItemCbs.getValorDevCBS());
        cbs.setValorDiferimentoCBS(nfceItemCbs.getValorDiferimentoCBS());
        cbs.setIncidenciaTributaria(nfceItemCbs.getIncidenciaTributaria());
        cbs.setIncidenciaTributariaClass(nfceItemCbs.getIncidenciaTributariaClass());
    }

    private void setItemIbs(ItemNotaFiscalPropria i, NFCeItem itemNFCe) {
        ItemNotaPropriaIbs ibs = null;
        NFCeItemIbs nfceItemIbs = itemNFCe.getIbs();
        if (i.getImpostoIBS() != null) {
            ibs = i.getImpostoIBS();
        } else {
            ibs = new ItemNotaPropriaIbs();
            i.setImpostoIBS(ibs);
        }
        ibs.setIncidenciaTributaria(nfceItemIbs.getIncidenciaTributaria());
        ibs.setIncidenciaTributariaClass(nfceItemIbs.getIncidenciaTributariaClass());
        ibs.setAliquotaDiferimentoIBSMun(nfceItemIbs.getAliquotaDiferimentoIBSMun());
        ibs.setAliquotaDiferimentoIBSUF(nfceItemIbs.getAliquotaDiferimentoIBSUF());
        ibs.setAliquotaEfetivaIBSMun(nfceItemIbs.getAliquotaEfetivaIBSMun());
        ibs.setAliquotaEfetivaIBSUF(nfceItemIbs.getAliquotaEfetivaIBSUF());
        ibs.setAliquotaIBSMun(nfceItemIbs.getAliquotaIBSMun());
        ibs.setAliquotaIBSUF(nfceItemIbs.getAliquotaIBSUF());
        ibs.setPercRedAliquotaIBSMun(nfceItemIbs.getPercRedAliquotaIBSMun());
        ibs.setPercRedAliquotaIBSUF(nfceItemIbs.getPercRedAliquotaIBSUF());
        ibs.setPercRedBC(nfceItemIbs.getPercRedBC());
        ibs.setValorBaseCalcIBS(nfceItemIbs.getValorBaseCalcIBS());
        ibs.setValorDevolucaoIBSMun(nfceItemIbs.getValorDevolucaoIBSMun());
        ibs.setValorDevolucaoIBSUF(nfceItemIbs.getValorDevolucaoIBSUF());
        ibs.setValorDiferimentoIBSMun(nfceItemIbs.getValorDiferimentoIBSMun());
        ibs.setValorDiferimentoIBSUF(nfceItemIbs.getValorDiferimentoIBSUF());
        ibs.setValorIBSMun(nfceItemIbs.getValorIBSMun());
        ibs.setValorIBSUF(nfceItemIbs.getValorIBSUF());
    }
}

