/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.nodo;

import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoNodoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNodoImpl
extends ServiceGenericEntityImpl<Nodo, Long, DaoNodoImpl> {
    @Autowired
    public ServiceNodoImpl(DaoNodoImpl genericDao) {
        super(genericDao);
    }

    public Nodo getNodoByVoClass(String classe) {
        return ((DaoNodoImpl)this.getGenericDao()).getNodoByVoClass(classe);
    }

    public Nodo getNodoByVoClassOrTrhow(String classe) throws ExceptionObjNotFound {
        Nodo nodo = ((DaoNodoImpl)this.getGenericDao()).getNodoByVoClass(classe);
        this.throwIfNull(nodo, (Serializable)((Object)classe));
        return nodo;
    }

    public List<Nodo> getNodosMenuLiberados() {
        return ((DaoNodoImpl)this.getDao()).getNodosMenuLiberados();
    }

    public List<Nodo> getNodosMenu() {
        return ((DaoNodoImpl)this.getDao()).getNodosMenu();
    }

    public List<Nodo> getNodosRecurso() {
        return ((DaoNodoImpl)this.getDao()).getNodosRecursos();
    }

    public List<Nodo> getNodosUtilizaCertificadoDigital() {
        return ((DaoNodoImpl)this.getDao()).getNodosUtilizaCertificadoDigital();
    }

    @Override
    public Nodo beforeSaveEntity(Nodo aux) {
        aux.setDataUltimaModificacao(new Date());
        aux.setPossuiFiltrosFixos(Short.valueOf(aux.getFiltrosFixos() != null && !aux.getFiltrosFixos().isEmpty() ? (short)1 : 0));
        aux.getFiltrosFixos().forEach(i -> i.setNodo(aux));
        return aux;
    }
}

